// media/mojo/mojom/cdm_storage.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/cdm_storage.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/cdm_storage.mojom-params-data.h"
#include "media/mojo/mojom/cdm_storage.mojom-shared-message-ids.h"

#include "media/mojo/mojom/cdm_storage.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_MOJO_MOJOM_CDM_STORAGE_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_CDM_STORAGE_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
const char CdmStorage::Name_[] = "media.mojom.CdmStorage";

class CdmStorage_Open_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmStorage_Open_ForwardToCallback(
      CdmStorage::OpenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CdmStorage::OpenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CdmStorage_Open_ForwardToCallback);
};

CdmStorageProxy::CdmStorageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmStorageProxy::Open(
    const WTF::String& in_file_name, OpenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::CdmStorage::Open", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_name"), in_file_name,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCdmStorage_Open_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmStorage_Open_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_name)::BaseType> file_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_file_name, file_name_fragment);
  params->file_name.Set(
      file_name_fragment.is_null() ? nullptr : file_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_name in CdmStorage.Open request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmStorage::Name_);
  message.set_method_name("Open");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmStorage_Open_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CdmStorage_Open_ProxyToResponder {
 public:
  static CdmStorage::OpenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CdmStorage_Open_ProxyToResponder> proxy(
        new CdmStorage_Open_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CdmStorage_Open_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmStorage_Open_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CdmStorage_Open_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmStorage::OpenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmStorage::Status in_status, ::mojo::PendingAssociatedRemote<CdmFile> in_cdm_file);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CdmStorage_Open_ProxyToResponder);
};

bool CdmStorage_Open_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::CdmStorage::OpenCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CdmStorage_Open_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmStorage_Open_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CdmStorage::Status p_status{};
  ::mojo::PendingAssociatedRemote<CdmFile> p_cdm_file{};
  CdmStorage_Open_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success) {
    p_cdm_file =
        input_data_view.TakeCdmFile<decltype(p_cdm_file)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmStorage::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_cdm_file));
  return true;
}

void CdmStorage_Open_ProxyToResponder::Run(
    CdmStorage::Status in_status, ::mojo::PendingAssociatedRemote<CdmFile> in_cdm_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::CdmStorage::OpenCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type CdmStorage::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_file"), in_cdm_file,
                        "<value of type ::mojo::PendingAssociatedRemote<CdmFile>>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCdmStorage_Open_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmStorage_Open_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::CdmStorage_Status>(
      in_status, &params->status);
  mojo::internal::Serialize<::media::mojom::CdmFileAssociatedPtrInfoDataView>(
      in_cdm_file, &params->cdm_file, &params.message());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::CdmStorage::OpenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmStorage::Name_);
  message.set_method_name("Open");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CdmStorageStubDispatch::Accept(
    CdmStorage* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCdmStorage_Open_Name: {
      break;
    }
  }
  return false;
}

// static
bool CdmStorageStubDispatch::AcceptWithResponder(
    CdmStorage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCdmStorage_Open_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::CdmStorage::Open",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::CdmStorage::Open");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CdmStorage_Open_Params_Data* params =
          reinterpret_cast<
              internal::CdmStorage_Open_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::String p_file_name{};
      CdmStorage_Open_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFileName(&p_file_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmStorage::Name_, 0, false);
        return false;
      }
      CdmStorage::OpenCallback callback =
          CdmStorage_Open_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Open(
std::move(p_file_name), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCdmStorageValidationInfo[] = {
    {internal::kCdmStorage_Open_Name,
     {&internal::CdmStorage_Open_Params_Data::Validate,
      &internal::CdmStorage_Open_ResponseParams_Data::Validate}},
};

bool CdmStorageRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::CdmStorage::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCdmStorageValidationInfo);
}

bool CdmStorageResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::CdmStorage::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCdmStorageValidationInfo);

}
const char CdmFile::Name_[] = "media.mojom.CdmFile";

class CdmFile_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmFile_Read_ForwardToCallback(
      CdmFile::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CdmFile::ReadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CdmFile_Read_ForwardToCallback);
};

class CdmFile_Write_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmFile_Write_ForwardToCallback(
      CdmFile::WriteCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CdmFile::WriteCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CdmFile_Write_ForwardToCallback);
};

CdmFileProxy::CdmFileProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmFileProxy::Read(
    ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::CdmFile::Read");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCdmFile_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmFile_Read_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFile::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmFile_Read_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CdmFileProxy::Write(
    const WTF::Vector<uint8_t>& in_data, WriteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::CdmFile::Write", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCdmFile_Write_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmFile_Write_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in CdmFile.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFile::Name_);
  message.set_method_name("Write");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmFile_Write_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CdmFile_Read_ProxyToResponder {
 public:
  static CdmFile::ReadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CdmFile_Read_ProxyToResponder> proxy(
        new CdmFile_Read_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CdmFile_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmFile_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CdmFile_Read_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmFile::ReadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmFile::Status in_status, const WTF::Vector<uint8_t>& in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CdmFile_Read_ProxyToResponder);
};

bool CdmFile_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::CdmFile::ReadCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CdmFile_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmFile_Read_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CdmFile::Status p_status{};
  WTF::Vector<uint8_t> p_data{};
  CdmFile_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmFile::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_data));
  return true;
}

void CdmFile_Read_ProxyToResponder::Run(
    CdmFile::Status in_status, const WTF::Vector<uint8_t>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::CdmFile::ReadCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type CdmFile::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const WTF::Vector<uint8_t>&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCdmFile_Read_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmFile_Read_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::CdmFile_Status>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data, data_fragment, &data_validate_params);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::CdmFile::ReadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFile::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CdmFile_Write_ProxyToResponder {
 public:
  static CdmFile::WriteCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CdmFile_Write_ProxyToResponder> proxy(
        new CdmFile_Write_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CdmFile_Write_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmFile_Write_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CdmFile_Write_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmFile::WriteCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CdmFile::Status in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CdmFile_Write_ProxyToResponder);
};

bool CdmFile_Write_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::CdmFile::WriteCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::CdmFile_Write_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmFile_Write_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  CdmFile::Status p_status{};
  CdmFile_Write_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmFile::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void CdmFile_Write_ProxyToResponder::Run(
    CdmFile::Status in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::CdmFile::WriteCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type CdmFile::Status>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kCdmFile_Write_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmFile_Write_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::CdmFile_Status>(
      in_status, &params->status);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::CdmFile::WriteCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmFile::Name_);
  message.set_method_name("Write");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CdmFileStubDispatch::Accept(
    CdmFile* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kCdmFile_Read_Name: {
      break;
    }
    case internal::kCdmFile_Write_Name: {
      break;
    }
  }
  return false;
}

// static
bool CdmFileStubDispatch::AcceptWithResponder(
    CdmFile* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCdmFile_Read_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::CdmFile::Read",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::CdmFile::Read");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CdmFile_Read_Params_Data* params =
          reinterpret_cast<
              internal::CdmFile_Read_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      CdmFile_Read_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmFile::Name_, 0, false);
        return false;
      }
      CdmFile::ReadCallback callback =
          CdmFile_Read_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(std::move(callback));
      return true;
    }
    case internal::kCdmFile_Write_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::CdmFile::Write",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::CdmFile::Write");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CdmFile_Write_Params_Data* params =
          reinterpret_cast<
              internal::CdmFile_Write_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<uint8_t> p_data{};
      CdmFile_Write_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmFile::Name_, 1, false);
        return false;
      }
      CdmFile::WriteCallback callback =
          CdmFile_Write_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Write(
std::move(p_data), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCdmFileValidationInfo[] = {
    {internal::kCdmFile_Read_Name,
     {&internal::CdmFile_Read_Params_Data::Validate,
      &internal::CdmFile_Read_ResponseParams_Data::Validate}},
    {internal::kCdmFile_Write_Name,
     {&internal::CdmFile_Write_Params_Data::Validate,
      &internal::CdmFile_Write_ResponseParams_Data::Validate}},
};

bool CdmFileRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::CdmFile::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCdmFileValidationInfo);
}

bool CdmFileResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::CdmFile::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCdmFileValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif