// media/mojo/mojom/cdm_storage.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/mojo/mojom/cdm_storage.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/file.mojom.h"


#ifndef MEDIA_MOJO_MOJOM_CDM_STORAGE_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_CDM_STORAGE_MOJOM_JUMBO_H_
#endif


namespace media {
namespace mojom {


void CdmStorageInterceptorForTesting::Open(const std::string& file_name, OpenCallback callback) {
  GetForwardingInterface()->Open(std::move(file_name), std::move(callback));
}
CdmStorageAsyncWaiter::CdmStorageAsyncWaiter(
    CdmStorage* proxy) : proxy_(proxy) {}

CdmStorageAsyncWaiter::~CdmStorageAsyncWaiter() = default;

void CdmStorageAsyncWaiter::Open(
    const std::string& file_name, CdmStorage::Status* out_status, ::mojo::PendingAssociatedRemote<CdmFile>* out_cdm_file) {
  base::RunLoop loop;
  proxy_->Open(std::move(file_name),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmStorage::Status* out_status
,
             ::mojo::PendingAssociatedRemote<CdmFile>* out_cdm_file
,
             CdmStorage::Status status,
             ::mojo::PendingAssociatedRemote<CdmFile> cdm_file) {*out_status = std::move(status);*out_cdm_file = std::move(cdm_file);
            loop->Quit();
          },
          &loop,
          out_status,
          out_cdm_file));
  loop.Run();
}



void CdmFileInterceptorForTesting::Read(ReadCallback callback) {
  GetForwardingInterface()->Read(std::move(callback));
}
void CdmFileInterceptorForTesting::Write(const std::vector<uint8_t>& data, WriteCallback callback) {
  GetForwardingInterface()->Write(std::move(data), std::move(callback));
}
CdmFileAsyncWaiter::CdmFileAsyncWaiter(
    CdmFile* proxy) : proxy_(proxy) {}

CdmFileAsyncWaiter::~CdmFileAsyncWaiter() = default;

void CdmFileAsyncWaiter::Read(
    CdmFile::Status* out_status, std::vector<uint8_t>* out_data) {
  base::RunLoop loop;
  proxy_->Read(
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmFile::Status* out_status
,
             std::vector<uint8_t>* out_data
,
             CdmFile::Status status,
             const std::vector<uint8_t>& data) {*out_status = std::move(status);*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_status,
          out_data));
  loop.Run();
}
void CdmFileAsyncWaiter::Write(
    const std::vector<uint8_t>& data, CdmFile::Status* out_status) {
  base::RunLoop loop;
  proxy_->Write(std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             CdmFile::Status* out_status
,
             CdmFile::Status status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}





}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif