// media/mojo/mojom/gpu_accelerated_video_decoder.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/mojo/mojom/gpu_accelerated_video_decoder.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "media/mojo/mojom/video_decoder.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"


#ifndef MEDIA_MOJO_MOJOM_GPU_ACCELERATED_VIDEO_DECODER_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_GPU_ACCELERATED_VIDEO_DECODER_MOJOM_JUMBO_H_
#endif


namespace media {
namespace mojom {


void GpuAcceleratedVideoDecoderProviderInterceptorForTesting::CreateAcceleratedVideoDecoder(const ::media::VideoDecodeAccelerator::Config& config, ::mojo::PendingAssociatedReceiver<GpuAcceleratedVideoDecoder> receiver, ::mojo::PendingAssociatedRemote<GpuAcceleratedVideoDecoderClient> client, CreateAcceleratedVideoDecoderCallback callback) {
  GetForwardingInterface()->CreateAcceleratedVideoDecoder(std::move(config), std::move(receiver), std::move(client), std::move(callback));
}
GpuAcceleratedVideoDecoderProviderAsyncWaiter::GpuAcceleratedVideoDecoderProviderAsyncWaiter(
    GpuAcceleratedVideoDecoderProvider* proxy) : proxy_(proxy) {}

GpuAcceleratedVideoDecoderProviderAsyncWaiter::~GpuAcceleratedVideoDecoderProviderAsyncWaiter() = default;

void GpuAcceleratedVideoDecoderProviderAsyncWaiter::CreateAcceleratedVideoDecoder(
    const ::media::VideoDecodeAccelerator::Config& config, ::mojo::PendingAssociatedReceiver<GpuAcceleratedVideoDecoder> receiver, ::mojo::PendingAssociatedRemote<GpuAcceleratedVideoDecoderClient> client, bool* out_success) {
  base::RunLoop loop;
  proxy_->CreateAcceleratedVideoDecoder(std::move(config),std::move(receiver),std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}



void GpuAcceleratedVideoDecoderInterceptorForTesting::Decode(::media::BitstreamBuffer buffer) {
  GetForwardingInterface()->Decode(std::move(buffer));
}
void GpuAcceleratedVideoDecoderInterceptorForTesting::AssignPictureBuffers(std::vector<PictureBufferAssignmentPtr> assignments) {
  GetForwardingInterface()->AssignPictureBuffers(std::move(assignments));
}
void GpuAcceleratedVideoDecoderInterceptorForTesting::ReusePictureBuffer(int32_t picture_buffer_id) {
  GetForwardingInterface()->ReusePictureBuffer(std::move(picture_buffer_id));
}
void GpuAcceleratedVideoDecoderInterceptorForTesting::Flush(FlushCallback callback) {
  GetForwardingInterface()->Flush(std::move(callback));
}
void GpuAcceleratedVideoDecoderInterceptorForTesting::Reset(ResetCallback callback) {
  GetForwardingInterface()->Reset(std::move(callback));
}
void GpuAcceleratedVideoDecoderInterceptorForTesting::SetOverlayInfo(const ::media::OverlayInfo& overlay_info) {
  GetForwardingInterface()->SetOverlayInfo(std::move(overlay_info));
}
GpuAcceleratedVideoDecoderAsyncWaiter::GpuAcceleratedVideoDecoderAsyncWaiter(
    GpuAcceleratedVideoDecoder* proxy) : proxy_(proxy) {}

GpuAcceleratedVideoDecoderAsyncWaiter::~GpuAcceleratedVideoDecoderAsyncWaiter() = default;

void GpuAcceleratedVideoDecoderAsyncWaiter::Flush(
    ) {
  base::RunLoop loop;
  proxy_->Flush(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void GpuAcceleratedVideoDecoderAsyncWaiter::Reset(
    ) {
  base::RunLoop loop;
  proxy_->Reset(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void GpuAcceleratedVideoDecoderClientInterceptorForTesting::OnInitializationComplete(bool success) {
  GetForwardingInterface()->OnInitializationComplete(std::move(success));
}
void GpuAcceleratedVideoDecoderClientInterceptorForTesting::OnBitstreamBufferProcessed(int32_t buffer_id) {
  GetForwardingInterface()->OnBitstreamBufferProcessed(std::move(buffer_id));
}
void GpuAcceleratedVideoDecoderClientInterceptorForTesting::OnProvidePictureBuffers(uint32_t num_frames, ::media::VideoPixelFormat format, uint32_t num_textures_per_frame, const ::gfx::Size& buffer_size, uint32_t texture_target) {
  GetForwardingInterface()->OnProvidePictureBuffers(std::move(num_frames), std::move(format), std::move(num_textures_per_frame), std::move(buffer_size), std::move(texture_target));
}
void GpuAcceleratedVideoDecoderClientInterceptorForTesting::OnPictureReady(PictureReadyParamsPtr params) {
  GetForwardingInterface()->OnPictureReady(std::move(params));
}
void GpuAcceleratedVideoDecoderClientInterceptorForTesting::OnDismissPictureBuffer(int32_t buffer_id) {
  GetForwardingInterface()->OnDismissPictureBuffer(std::move(buffer_id));
}
void GpuAcceleratedVideoDecoderClientInterceptorForTesting::OnError(uint32_t error_id) {
  GetForwardingInterface()->OnError(std::move(error_id));
}
GpuAcceleratedVideoDecoderClientAsyncWaiter::GpuAcceleratedVideoDecoderClientAsyncWaiter(
    GpuAcceleratedVideoDecoderClient* proxy) : proxy_(proxy) {}

GpuAcceleratedVideoDecoderClientAsyncWaiter::~GpuAcceleratedVideoDecoderClientAsyncWaiter() = default;






}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif