// media/mojo/mojom/media_metrics_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/media_metrics_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/media_metrics_provider.mojom-params-data.h"
#include "media/mojo/mojom/media_metrics_provider.mojom-shared-message-ids.h"

#include "media/mojo/mojom/media_metrics_provider.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_MEDIA_METRICS_PROVIDER_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_MEDIA_METRICS_PROVIDER_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char MediaMetricsProvider::Name_[] = "media.mojom.MediaMetricsProvider";

MediaMetricsProviderProxy::MediaMetricsProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaMetricsProviderProxy::Initialize(
    bool in_is_mse, MediaURLScheme in_url_scheme, ::media::mojom::MediaStreamType in_stream_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::Initialize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_mse"), in_is_mse,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_scheme"), in_url_scheme,
                        "<value of type MediaURLScheme>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_type"), in_stream_type,
                        "<value of type ::media::mojom::MediaStreamType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_Initialize_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_Initialize_Params_Data> params(
          message);
  params.Allocate();
  params->is_mse = in_is_mse;
  mojo::internal::Serialize<::media::mojom::MediaURLScheme>(
      in_url_scheme, &params->url_scheme);
  mojo::internal::Serialize<::media::mojom::MediaStreamType>(
      in_stream_type, &params->stream_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("Initialize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::OnError(
    ::media::PipelineStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::PipelineStatus>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_OnError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::PipelineStatus>(
      in_status, &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetHasPlayed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaMetricsProvider::SetHasPlayed");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetHasPlayed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetHasPlayed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHasPlayed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetHaveEnough(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaMetricsProvider::SetHaveEnough");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetHaveEnough_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetHaveEnough_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHaveEnough");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetIsEME(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaMetricsProvider::SetIsEME");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetIsEME_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetIsEME_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetIsEME");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetTimeToMetadata(
    ::base::TimeDelta in_elapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetTimeToMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elapsed"), in_elapsed,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetTimeToMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->elapsed)::BaseType> elapsed_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_elapsed, elapsed_fragment);
  params->elapsed.Set(
      elapsed_fragment.is_null() ? nullptr : elapsed_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->elapsed.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elapsed in MediaMetricsProvider.SetTimeToMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetTimeToMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetTimeToFirstFrame(
    ::base::TimeDelta in_elapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetTimeToFirstFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elapsed"), in_elapsed,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetTimeToFirstFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->elapsed)::BaseType> elapsed_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_elapsed, elapsed_fragment);
  params->elapsed.Set(
      elapsed_fragment.is_null() ? nullptr : elapsed_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->elapsed.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elapsed in MediaMetricsProvider.SetTimeToFirstFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetTimeToFirstFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetTimeToPlayReady(
    ::base::TimeDelta in_elapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetTimeToPlayReady", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elapsed"), in_elapsed,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetTimeToPlayReady_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->elapsed)::BaseType> elapsed_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_elapsed, elapsed_fragment);
  params->elapsed.Set(
      elapsed_fragment.is_null() ? nullptr : elapsed_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->elapsed.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null elapsed in MediaMetricsProvider.SetTimeToPlayReady request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetTimeToPlayReady");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetRendererType(
    ::media::RendererType in_renderer_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetRendererType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("renderer_type"), in_renderer_type,
                        "<value of type ::media::RendererType>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetRendererType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetRendererType_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::RendererType>(
      in_renderer_type, &params->renderer_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetRendererType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetKeySystem(
    const std::string& in_key_system) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetKeySystem", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_system"), in_key_system,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetKeySystem_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetKeySystem_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_system)::BaseType> key_system_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_key_system, key_system_fragment);
  params->key_system.Set(
      key_system_fragment.is_null() ? nullptr : key_system_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key_system.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_system in MediaMetricsProvider.SetKeySystem request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetKeySystem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetIsHardwareSecure(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::MediaMetricsProvider::SetIsHardwareSecure");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetIsHardwareSecure_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetIsHardwareSecure_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetIsHardwareSecure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetContainerName(
    ::media::container_names::MediaContainerName in_container_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetContainerName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("container_name"), in_container_name,
                        "<value of type ::media::container_names::MediaContainerName>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetContainerName_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetContainerName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::MediaContainerName>(
      in_container_name, &params->container_name);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetContainerName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::AcquireWatchTimeRecorder(
    ::media::mojom::PlaybackPropertiesPtr in_properties, ::mojo::PendingReceiver<::media::mojom::WatchTimeRecorder> in_recorder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::AcquireWatchTimeRecorder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), in_properties,
                        "<value of type ::media::mojom::PlaybackPropertiesPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recorder"), in_recorder,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::WatchTimeRecorder>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_AcquireWatchTimeRecorder_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType> properties_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::PlaybackPropertiesDataView>(
      in_properties, properties_fragment);
  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null properties in MediaMetricsProvider.AcquireWatchTimeRecorder request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::WatchTimeRecorderInterfaceBase>>(
      in_recorder, &params->recorder, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->recorder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid recorder in MediaMetricsProvider.AcquireWatchTimeRecorder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("AcquireWatchTimeRecorder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::AcquireVideoDecodeStatsRecorder(
    ::mojo::PendingReceiver<::media::mojom::VideoDecodeStatsRecorder> in_recorder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::AcquireVideoDecodeStatsRecorder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recorder"), in_recorder,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::VideoDecodeStatsRecorder>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::VideoDecodeStatsRecorderInterfaceBase>>(
      in_recorder, &params->recorder, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->recorder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid recorder in MediaMetricsProvider.AcquireVideoDecodeStatsRecorder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("AcquireVideoDecodeStatsRecorder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::AcquireLearningTaskController(
    const std::string& in_taskName, ::mojo::PendingReceiver<::media::learning::mojom::LearningTaskController> in_controller) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::AcquireLearningTaskController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("taskName"), in_taskName,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controller"), in_controller,
                        "<value of type ::mojo::PendingReceiver<::media::learning::mojom::LearningTaskController>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_AcquireLearningTaskController_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_AcquireLearningTaskController_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->taskName)::BaseType> taskName_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_taskName, taskName_fragment);
  params->taskName.Set(
      taskName_fragment.is_null() ? nullptr : taskName_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->taskName.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null taskName in MediaMetricsProvider.AcquireLearningTaskController request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::learning::mojom::LearningTaskControllerInterfaceBase>>(
      in_controller, &params->controller, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->controller),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid controller in MediaMetricsProvider.AcquireLearningTaskController request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("AcquireLearningTaskController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::AcquirePlaybackEventsRecorder(
    ::mojo::PendingReceiver<::media::mojom::PlaybackEventsRecorder> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::AcquirePlaybackEventsRecorder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::PlaybackEventsRecorder>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::PlaybackEventsRecorderInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in MediaMetricsProvider.AcquirePlaybackEventsRecorder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("AcquirePlaybackEventsRecorder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetHasAudio(
    ::media::AudioCodec in_codec) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetHasAudio", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("codec"), in_codec,
                        "<value of type ::media::AudioCodec>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetHasAudio_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetHasAudio_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::AudioCodec>(
      in_codec, &params->codec);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHasAudio");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetHasVideo(
    ::media::VideoCodec in_codec) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetHasVideo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("codec"), in_codec,
                        "<value of type ::media::VideoCodec>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetHasVideo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetHasVideo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::VideoCodec>(
      in_codec, &params->codec);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetHasVideo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetVideoPipelineInfo(
    const ::media::VideoPipelineInfo& in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetVideoPipelineInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type const ::media::VideoPipelineInfo&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetVideoPipelineInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoPipelineInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in MediaMetricsProvider.SetVideoPipelineInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetVideoPipelineInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaMetricsProviderProxy::SetAudioPipelineInfo(
    const ::media::AudioPipelineInfo& in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::MediaMetricsProvider::SetAudioPipelineInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type const ::media::AudioPipelineInfo&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaMetricsProvider_SetAudioPipelineInfo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::AudioPipelineInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in MediaMetricsProvider.SetAudioPipelineInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaMetricsProvider::Name_);
  message.set_method_name("SetAudioPipelineInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaMetricsProviderStubDispatch::Accept(
    MediaMetricsProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaMetricsProvider_Initialize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::Initialize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::Initialize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_Initialize_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_Initialize_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_mse{};
      MediaURLScheme p_url_scheme{};
      ::media::mojom::MediaStreamType p_stream_type{};
      MediaMetricsProvider_Initialize_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_mse = input_data_view.is_mse();
      if (success && !input_data_view.ReadUrlScheme(&p_url_scheme))
        success = false;
      if (success && !input_data_view.ReadStreamType(&p_stream_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Initialize(
std::move(p_is_mse), 
std::move(p_url_scheme), 
std::move(p_stream_type));
      return true;
    }
    case internal::kMediaMetricsProvider_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_OnError_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::PipelineStatus p_status{};
      MediaMetricsProvider_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_status));
      return true;
    }
    case internal::kMediaMetricsProvider_SetHasPlayed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetHasPlayed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetHasPlayed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHasPlayed_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHasPlayed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaMetricsProvider_SetHasPlayed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasPlayed();
      return true;
    }
    case internal::kMediaMetricsProvider_SetHaveEnough_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetHaveEnough",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetHaveEnough");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHaveEnough_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHaveEnough_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaMetricsProvider_SetHaveEnough_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHaveEnough();
      return true;
    }
    case internal::kMediaMetricsProvider_SetIsEME_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetIsEME",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetIsEME");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetIsEME_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetIsEME_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaMetricsProvider_SetIsEME_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsEME();
      return true;
    }
    case internal::kMediaMetricsProvider_SetTimeToMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetTimeToMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetTimeToMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_elapsed{};
      MediaMetricsProvider_SetTimeToMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadElapsed(&p_elapsed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTimeToMetadata(
std::move(p_elapsed));
      return true;
    }
    case internal::kMediaMetricsProvider_SetTimeToFirstFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetTimeToFirstFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetTimeToFirstFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_elapsed{};
      MediaMetricsProvider_SetTimeToFirstFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadElapsed(&p_elapsed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTimeToFirstFrame(
std::move(p_elapsed));
      return true;
    }
    case internal::kMediaMetricsProvider_SetTimeToPlayReady_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetTimeToPlayReady",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetTimeToPlayReady");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_elapsed{};
      MediaMetricsProvider_SetTimeToPlayReady_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadElapsed(&p_elapsed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTimeToPlayReady(
std::move(p_elapsed));
      return true;
    }
    case internal::kMediaMetricsProvider_SetRendererType_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetRendererType",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetRendererType");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetRendererType_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetRendererType_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::RendererType p_renderer_type{};
      MediaMetricsProvider_SetRendererType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRendererType(&p_renderer_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRendererType(
std::move(p_renderer_type));
      return true;
    }
    case internal::kMediaMetricsProvider_SetKeySystem_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetKeySystem",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetKeySystem");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetKeySystem_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetKeySystem_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_key_system{};
      MediaMetricsProvider_SetKeySystem_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeySystem(&p_key_system))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetKeySystem(
std::move(p_key_system));
      return true;
    }
    case internal::kMediaMetricsProvider_SetIsHardwareSecure_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetIsHardwareSecure",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetIsHardwareSecure");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetIsHardwareSecure_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetIsHardwareSecure_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaMetricsProvider_SetIsHardwareSecure_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsHardwareSecure();
      return true;
    }
    case internal::kMediaMetricsProvider_SetContainerName_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetContainerName",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetContainerName");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetContainerName_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetContainerName_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::container_names::MediaContainerName p_container_name{};
      MediaMetricsProvider_SetContainerName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContainerName(&p_container_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetContainerName(
std::move(p_container_name));
      return true;
    }
    case internal::kMediaMetricsProvider_AcquireWatchTimeRecorder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::AcquireWatchTimeRecorder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::AcquireWatchTimeRecorder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::PlaybackPropertiesPtr p_properties{};
      ::mojo::PendingReceiver<::media::mojom::WatchTimeRecorder> p_recorder{};
      MediaMetricsProvider_AcquireWatchTimeRecorder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (success) {
        p_recorder =
            input_data_view.TakeRecorder<decltype(p_recorder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquireWatchTimeRecorder(
std::move(p_properties), 
std::move(p_recorder));
      return true;
    }
    case internal::kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::AcquireVideoDecodeStatsRecorder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::AcquireVideoDecodeStatsRecorder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::VideoDecodeStatsRecorder> p_recorder{};
      MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_recorder =
            input_data_view.TakeRecorder<decltype(p_recorder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquireVideoDecodeStatsRecorder(
std::move(p_recorder));
      return true;
    }
    case internal::kMediaMetricsProvider_AcquireLearningTaskController_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::AcquireLearningTaskController",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::AcquireLearningTaskController");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_AcquireLearningTaskController_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_AcquireLearningTaskController_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_taskName{};
      ::mojo::PendingReceiver<::media::learning::mojom::LearningTaskController> p_controller{};
      MediaMetricsProvider_AcquireLearningTaskController_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTaskName(&p_taskName))
        success = false;
      if (success) {
        p_controller =
            input_data_view.TakeController<decltype(p_controller)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquireLearningTaskController(
std::move(p_taskName), 
std::move(p_controller));
      return true;
    }
    case internal::kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::AcquirePlaybackEventsRecorder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::AcquirePlaybackEventsRecorder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::PlaybackEventsRecorder> p_receiver{};
      MediaMetricsProvider_AcquirePlaybackEventsRecorder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcquirePlaybackEventsRecorder(
std::move(p_receiver));
      return true;
    }
    case internal::kMediaMetricsProvider_SetHasAudio_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetHasAudio",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetHasAudio");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHasAudio_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHasAudio_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::AudioCodec p_codec{};
      MediaMetricsProvider_SetHasAudio_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCodec(&p_codec))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasAudio(
std::move(p_codec));
      return true;
    }
    case internal::kMediaMetricsProvider_SetHasVideo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetHasVideo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetHasVideo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetHasVideo_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetHasVideo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoCodec p_codec{};
      MediaMetricsProvider_SetHasVideo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCodec(&p_codec))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasVideo(
std::move(p_codec));
      return true;
    }
    case internal::kMediaMetricsProvider_SetVideoPipelineInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetVideoPipelineInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetVideoPipelineInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::VideoPipelineInfo p_info{};
      MediaMetricsProvider_SetVideoPipelineInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVideoPipelineInfo(
std::move(p_info));
      return true;
    }
    case internal::kMediaMetricsProvider_SetAudioPipelineInfo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::MediaMetricsProvider::SetAudioPipelineInfo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::MediaMetricsProvider::SetAudioPipelineInfo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data* params =
          reinterpret_cast<internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::AudioPipelineInfo p_info{};
      MediaMetricsProvider_SetAudioPipelineInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaMetricsProvider::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAudioPipelineInfo(
std::move(p_info));
      return true;
    }
  }
  return false;
}

// static
bool MediaMetricsProviderStubDispatch::AcceptWithResponder(
    MediaMetricsProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaMetricsProvider_Initialize_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_OnError_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetHasPlayed_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetHaveEnough_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetIsEME_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetTimeToMetadata_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetTimeToFirstFrame_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetTimeToPlayReady_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetRendererType_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetKeySystem_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetIsHardwareSecure_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetContainerName_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_AcquireWatchTimeRecorder_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_AcquireLearningTaskController_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetHasAudio_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetHasVideo_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetVideoPipelineInfo_Name: {
      break;
    }
    case internal::kMediaMetricsProvider_SetAudioPipelineInfo_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaMetricsProviderValidationInfo[] = {
    {internal::kMediaMetricsProvider_Initialize_Name,
     {&internal::MediaMetricsProvider_Initialize_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_OnError_Name,
     {&internal::MediaMetricsProvider_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetHasPlayed_Name,
     {&internal::MediaMetricsProvider_SetHasPlayed_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetHaveEnough_Name,
     {&internal::MediaMetricsProvider_SetHaveEnough_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetIsEME_Name,
     {&internal::MediaMetricsProvider_SetIsEME_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetTimeToMetadata_Name,
     {&internal::MediaMetricsProvider_SetTimeToMetadata_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetTimeToFirstFrame_Name,
     {&internal::MediaMetricsProvider_SetTimeToFirstFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetTimeToPlayReady_Name,
     {&internal::MediaMetricsProvider_SetTimeToPlayReady_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetRendererType_Name,
     {&internal::MediaMetricsProvider_SetRendererType_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetKeySystem_Name,
     {&internal::MediaMetricsProvider_SetKeySystem_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetIsHardwareSecure_Name,
     {&internal::MediaMetricsProvider_SetIsHardwareSecure_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetContainerName_Name,
     {&internal::MediaMetricsProvider_SetContainerName_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_AcquireWatchTimeRecorder_Name,
     {&internal::MediaMetricsProvider_AcquireWatchTimeRecorder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Name,
     {&internal::MediaMetricsProvider_AcquireVideoDecodeStatsRecorder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_AcquireLearningTaskController_Name,
     {&internal::MediaMetricsProvider_AcquireLearningTaskController_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_AcquirePlaybackEventsRecorder_Name,
     {&internal::MediaMetricsProvider_AcquirePlaybackEventsRecorder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetHasAudio_Name,
     {&internal::MediaMetricsProvider_SetHasAudio_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetHasVideo_Name,
     {&internal::MediaMetricsProvider_SetHasVideo_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetVideoPipelineInfo_Name,
     {&internal::MediaMetricsProvider_SetVideoPipelineInfo_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kMediaMetricsProvider_SetAudioPipelineInfo_Name,
     {&internal::MediaMetricsProvider_SetAudioPipelineInfo_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaMetricsProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::MediaMetricsProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaMetricsProviderValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif