// media/mojo/mojom/media_player.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/media_player.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/media_player.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {


// static
bool MediaPlayer_RequestPlay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_RequestPlay_Params_Data* object = static_cast<const MediaPlayer_RequestPlay_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayer_RequestPlay_Params_Data::MediaPlayer_RequestPlay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayer_RequestPause_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_RequestPause_Params_Data* object = static_cast<const MediaPlayer_RequestPause_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayer_RequestPause_Params_Data::MediaPlayer_RequestPause_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayer_RequestSeekForward_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_RequestSeekForward_Params_Data* object = static_cast<const MediaPlayer_RequestSeekForward_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

MediaPlayer_RequestSeekForward_Params_Data::MediaPlayer_RequestSeekForward_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayer_RequestSeekBackward_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_RequestSeekBackward_Params_Data* object = static_cast<const MediaPlayer_RequestSeekBackward_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

MediaPlayer_RequestSeekBackward_Params_Data::MediaPlayer_RequestSeekBackward_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayer_RequestSeekTo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_RequestSeekTo_Params_Data* object = static_cast<const MediaPlayer_RequestSeekTo_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

MediaPlayer_RequestSeekTo_Params_Data::MediaPlayer_RequestSeekTo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayer_RequestEnterPictureInPicture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_RequestEnterPictureInPicture_Params_Data* object = static_cast<const MediaPlayer_RequestEnterPictureInPicture_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayer_RequestEnterPictureInPicture_Params_Data::MediaPlayer_RequestEnterPictureInPicture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayer_RequestExitPictureInPicture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_RequestExitPictureInPicture_Params_Data* object = static_cast<const MediaPlayer_RequestExitPictureInPicture_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayer_RequestExitPictureInPicture_Params_Data::MediaPlayer_RequestExitPictureInPicture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayer_SetVolumeMultiplier_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_SetVolumeMultiplier_Params_Data* object = static_cast<const MediaPlayer_SetVolumeMultiplier_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayer_SetVolumeMultiplier_Params_Data::MediaPlayer_SetVolumeMultiplier_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayer_SetPersistentState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_SetPersistentState_Params_Data* object = static_cast<const MediaPlayer_SetPersistentState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayer_SetPersistentState_Params_Data::MediaPlayer_SetPersistentState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayer_SetPowerExperimentState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_SetPowerExperimentState_Params_Data* object = static_cast<const MediaPlayer_SetPowerExperimentState_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayer_SetPowerExperimentState_Params_Data::MediaPlayer_SetPowerExperimentState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayer_SetAudioSinkId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_SetAudioSinkId_Params_Data* object = static_cast<const MediaPlayer_SetAudioSinkId_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sink_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sink_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->sink_id, validation_context,
                                         &sink_id_validate_params)) {
    return false;
  }

  return true;
}

MediaPlayer_SetAudioSinkId_Params_Data::MediaPlayer_SetAudioSinkId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayer_SuspendForFrameClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayer_SuspendForFrameClosed_Params_Data* object = static_cast<const MediaPlayer_SuspendForFrameClosed_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayer_SuspendForFrameClosed_Params_Data::MediaPlayer_SuspendForFrameClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnMediaPlaying_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnMediaPlaying_Params_Data* object = static_cast<const MediaPlayerObserver_OnMediaPlaying_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayerObserver_OnMediaPlaying_Params_Data::MediaPlayerObserver_OnMediaPlaying_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnMediaPaused_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnMediaPaused_Params_Data* object = static_cast<const MediaPlayerObserver_OnMediaPaused_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayerObserver_OnMediaPaused_Params_Data::MediaPlayerObserver_OnMediaPaused_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnMutedStatusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnMutedStatusChanged_Params_Data* object = static_cast<const MediaPlayerObserver_OnMutedStatusChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayerObserver_OnMutedStatusChanged_Params_Data::MediaPlayerObserver_OnMutedStatusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnMediaMetadataChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnMediaMetadataChanged_Params_Data* object = static_cast<const MediaPlayerObserver_OnMediaMetadataChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::MediaContentType_Data
        ::Validate(object->content_type, validation_context))
    return false;

  return true;
}

MediaPlayerObserver_OnMediaMetadataChanged_Params_Data::MediaPlayerObserver_OnMediaMetadataChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data* object = static_cast<const MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_position, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->media_position, validation_context))
    return false;

  return true;
}

MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data::MediaPlayerObserver_OnMediaPositionStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data* object = static_cast<const MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::FullscreenVideoStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data::MediaPlayerObserver_OnMediaEffectivelyFullscreenChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnMediaSizeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnMediaSizeChanged_Params_Data* object = static_cast<const MediaPlayerObserver_OnMediaSizeChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

MediaPlayerObserver_OnMediaSizeChanged_Params_Data::MediaPlayerObserver_OnMediaSizeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data* object = static_cast<const MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data::MediaPlayerObserver_OnPictureInPictureAvailabilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data* object = static_cast<const MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hashed_device_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams hashed_device_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->hashed_device_id, validation_context,
                                         &hashed_device_id_validate_params)) {
    return false;
  }

  return true;
}

MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data::MediaPlayerObserver_OnAudioOutputSinkChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnUseAudioServiceChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnUseAudioServiceChanged_Params_Data* object = static_cast<const MediaPlayerObserver_OnUseAudioServiceChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayerObserver_OnUseAudioServiceChanged_Params_Data::MediaPlayerObserver_OnUseAudioServiceChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data* object = static_cast<const MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data::MediaPlayerObserver_OnAudioOutputSinkChangingDisabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnBufferUnderflow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnBufferUnderflow_Params_Data* object = static_cast<const MediaPlayerObserver_OnBufferUnderflow_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayerObserver_OnBufferUnderflow_Params_Data::MediaPlayerObserver_OnBufferUnderflow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerObserver_OnSeek_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerObserver_OnSeek_Params_Data* object = static_cast<const MediaPlayerObserver_OnSeek_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

MediaPlayerObserver_OnSeek_Params_Data::MediaPlayerObserver_OnSeek_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaPlayerHost_OnMediaPlayerAdded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const MediaPlayerHost_OnMediaPlayerAdded_Params_Data* object = static_cast<const MediaPlayerHost_OnMediaPlayerAdded_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->player_remote, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->player_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaPlayerHost_OnMediaPlayerAdded_Params_Data::MediaPlayerHost_OnMediaPlayerAdded_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media
