// media/mojo/mojom/media_player.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/mojo/mojom/media_player.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/media_session/public/mojom/media_session.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"


#ifndef MEDIA_MOJO_MOJOM_MEDIA_PLAYER_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_MEDIA_PLAYER_MOJOM_JUMBO_H_
#endif


namespace media {
namespace mojom {


void MediaPlayerInterceptorForTesting::RequestPlay() {
  GetForwardingInterface()->RequestPlay();
}
void MediaPlayerInterceptorForTesting::RequestPause(bool triggered_by_user) {
  GetForwardingInterface()->RequestPause(std::move(triggered_by_user));
}
void MediaPlayerInterceptorForTesting::RequestSeekForward(::base::TimeDelta seek_time) {
  GetForwardingInterface()->RequestSeekForward(std::move(seek_time));
}
void MediaPlayerInterceptorForTesting::RequestSeekBackward(::base::TimeDelta seek_time) {
  GetForwardingInterface()->RequestSeekBackward(std::move(seek_time));
}
void MediaPlayerInterceptorForTesting::RequestSeekTo(::base::TimeDelta seek_time) {
  GetForwardingInterface()->RequestSeekTo(std::move(seek_time));
}
void MediaPlayerInterceptorForTesting::RequestEnterPictureInPicture() {
  GetForwardingInterface()->RequestEnterPictureInPicture();
}
void MediaPlayerInterceptorForTesting::RequestExitPictureInPicture() {
  GetForwardingInterface()->RequestExitPictureInPicture();
}
void MediaPlayerInterceptorForTesting::SetVolumeMultiplier(double multiplier) {
  GetForwardingInterface()->SetVolumeMultiplier(std::move(multiplier));
}
void MediaPlayerInterceptorForTesting::SetPersistentState(bool persistent) {
  GetForwardingInterface()->SetPersistentState(std::move(persistent));
}
void MediaPlayerInterceptorForTesting::SetPowerExperimentState(bool enabled) {
  GetForwardingInterface()->SetPowerExperimentState(std::move(enabled));
}
void MediaPlayerInterceptorForTesting::SetAudioSinkId(const std::string& sink_id) {
  GetForwardingInterface()->SetAudioSinkId(std::move(sink_id));
}
void MediaPlayerInterceptorForTesting::SuspendForFrameClosed() {
  GetForwardingInterface()->SuspendForFrameClosed();
}
MediaPlayerAsyncWaiter::MediaPlayerAsyncWaiter(
    MediaPlayer* proxy) : proxy_(proxy) {}

MediaPlayerAsyncWaiter::~MediaPlayerAsyncWaiter() = default;




void MediaPlayerObserverInterceptorForTesting::OnMediaPlaying() {
  GetForwardingInterface()->OnMediaPlaying();
}
void MediaPlayerObserverInterceptorForTesting::OnMediaPaused(bool stream_ended) {
  GetForwardingInterface()->OnMediaPaused(std::move(stream_ended));
}
void MediaPlayerObserverInterceptorForTesting::OnMutedStatusChanged(bool muted) {
  GetForwardingInterface()->OnMutedStatusChanged(std::move(muted));
}
void MediaPlayerObserverInterceptorForTesting::OnMediaMetadataChanged(bool has_audio, bool has_video, ::media::MediaContentType content_type) {
  GetForwardingInterface()->OnMediaMetadataChanged(std::move(has_audio), std::move(has_video), std::move(content_type));
}
void MediaPlayerObserverInterceptorForTesting::OnMediaPositionStateChanged(const ::media_session::MediaPosition& media_position) {
  GetForwardingInterface()->OnMediaPositionStateChanged(std::move(media_position));
}
void MediaPlayerObserverInterceptorForTesting::OnMediaEffectivelyFullscreenChanged(::blink::WebFullscreenVideoStatus status) {
  GetForwardingInterface()->OnMediaEffectivelyFullscreenChanged(std::move(status));
}
void MediaPlayerObserverInterceptorForTesting::OnMediaSizeChanged(const ::gfx::Size& size) {
  GetForwardingInterface()->OnMediaSizeChanged(std::move(size));
}
void MediaPlayerObserverInterceptorForTesting::OnPictureInPictureAvailabilityChanged(bool available) {
  GetForwardingInterface()->OnPictureInPictureAvailabilityChanged(std::move(available));
}
void MediaPlayerObserverInterceptorForTesting::OnAudioOutputSinkChanged(const std::string& hashed_device_id) {
  GetForwardingInterface()->OnAudioOutputSinkChanged(std::move(hashed_device_id));
}
void MediaPlayerObserverInterceptorForTesting::OnUseAudioServiceChanged(bool uses_audio_service) {
  GetForwardingInterface()->OnUseAudioServiceChanged(std::move(uses_audio_service));
}
void MediaPlayerObserverInterceptorForTesting::OnAudioOutputSinkChangingDisabled() {
  GetForwardingInterface()->OnAudioOutputSinkChangingDisabled();
}
void MediaPlayerObserverInterceptorForTesting::OnBufferUnderflow() {
  GetForwardingInterface()->OnBufferUnderflow();
}
void MediaPlayerObserverInterceptorForTesting::OnSeek() {
  GetForwardingInterface()->OnSeek();
}
MediaPlayerObserverAsyncWaiter::MediaPlayerObserverAsyncWaiter(
    MediaPlayerObserver* proxy) : proxy_(proxy) {}

MediaPlayerObserverAsyncWaiter::~MediaPlayerObserverAsyncWaiter() = default;




void MediaPlayerHostInterceptorForTesting::OnMediaPlayerAdded(::mojo::PendingAssociatedRemote<MediaPlayer> player_remote, ::mojo::PendingAssociatedReceiver<MediaPlayerObserver> observer, int32_t player_id) {
  GetForwardingInterface()->OnMediaPlayerAdded(std::move(player_remote), std::move(observer), std::move(player_id));
}
MediaPlayerHostAsyncWaiter::MediaPlayerHostAsyncWaiter(
    MediaPlayerHost* proxy) : proxy_(proxy) {}

MediaPlayerHostAsyncWaiter::~MediaPlayerHostAsyncWaiter() = default;






}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif