// media/mojo/mojom/remoting_common.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/remoting_common.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/remoting_common.mojom-params-data.h"
namespace media {
namespace mojom {

static NOINLINE const char* RemotingStopReasonToStringHelper(RemotingStopReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RemotingStopReason::ROUTE_TERMINATED:
      return "ROUTE_TERMINATED";
    case RemotingStopReason::LOCAL_PLAYBACK:
      return "LOCAL_PLAYBACK";
    case RemotingStopReason::SOURCE_GONE:
      return "SOURCE_GONE";
    case RemotingStopReason::MESSAGE_SEND_FAILED:
      return "MESSAGE_SEND_FAILED";
    case RemotingStopReason::DATA_SEND_FAILED:
      return "DATA_SEND_FAILED";
    case RemotingStopReason::UNEXPECTED_FAILURE:
      return "UNEXPECTED_FAILURE";
    case RemotingStopReason::SERVICE_GONE:
      return "SERVICE_GONE";
    case RemotingStopReason::USER_DISABLED:
      return "USER_DISABLED";
    default:
      return nullptr;
  }
}

std::string RemotingStopReasonToString(RemotingStopReason value) {
  const char *str = RemotingStopReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RemotingStopReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RemotingStopReason value) {
  return os << RemotingStopReasonToString(value);
}

static NOINLINE const char* RemotingStartFailReasonToStringHelper(RemotingStartFailReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RemotingStartFailReason::CANNOT_START_MULTIPLE:
      return "CANNOT_START_MULTIPLE";
    case RemotingStartFailReason::ROUTE_TERMINATED:
      return "ROUTE_TERMINATED";
    case RemotingStartFailReason::INVALID_ANSWER_MESSAGE:
      return "INVALID_ANSWER_MESSAGE";
    case RemotingStartFailReason::REMOTING_NOT_PERMITTED:
      return "REMOTING_NOT_PERMITTED";
    default:
      return nullptr;
  }
}

std::string RemotingStartFailReasonToString(RemotingStartFailReason value) {
  const char *str = RemotingStartFailReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RemotingStartFailReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RemotingStartFailReason value) {
  return os << RemotingStartFailReasonToString(value);
}

static NOINLINE const char* RemotingSinkFeatureToStringHelper(RemotingSinkFeature value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RemotingSinkFeature::RENDERING:
      return "RENDERING";
    case RemotingSinkFeature::CONTENT_DECRYPTION:
      return "CONTENT_DECRYPTION";
    default:
      return nullptr;
  }
}

std::string RemotingSinkFeatureToString(RemotingSinkFeature value) {
  const char *str = RemotingSinkFeatureToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RemotingSinkFeature value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RemotingSinkFeature value) {
  return os << RemotingSinkFeatureToString(value);
}

static NOINLINE const char* RemotingSinkAudioCapabilityToStringHelper(RemotingSinkAudioCapability value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RemotingSinkAudioCapability::CODEC_BASELINE_SET:
      return "CODEC_BASELINE_SET";
    case RemotingSinkAudioCapability::CODEC_AAC:
      return "CODEC_AAC";
    case RemotingSinkAudioCapability::CODEC_OPUS:
      return "CODEC_OPUS";
    default:
      return nullptr;
  }
}

std::string RemotingSinkAudioCapabilityToString(RemotingSinkAudioCapability value) {
  const char *str = RemotingSinkAudioCapabilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RemotingSinkAudioCapability value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RemotingSinkAudioCapability value) {
  return os << RemotingSinkAudioCapabilityToString(value);
}

static NOINLINE const char* RemotingSinkVideoCapabilityToStringHelper(RemotingSinkVideoCapability value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RemotingSinkVideoCapability::SUPPORT_4K:
      return "SUPPORT_4K";
    case RemotingSinkVideoCapability::CODEC_BASELINE_SET:
      return "CODEC_BASELINE_SET";
    case RemotingSinkVideoCapability::CODEC_H264:
      return "CODEC_H264";
    case RemotingSinkVideoCapability::CODEC_VP8:
      return "CODEC_VP8";
    case RemotingSinkVideoCapability::CODEC_VP9:
      return "CODEC_VP9";
    case RemotingSinkVideoCapability::CODEC_HEVC:
      return "CODEC_HEVC";
    default:
      return nullptr;
  }
}

std::string RemotingSinkVideoCapabilityToString(RemotingSinkVideoCapability value) {
  const char *str = RemotingSinkVideoCapabilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RemotingSinkVideoCapability value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RemotingSinkVideoCapability value) {
  return os << RemotingSinkVideoCapabilityToString(value);
}

namespace internal {


// static
bool RemotingSinkMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RemotingSinkMetadata_Data* object = static_cast<const RemotingSinkMetadata_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->features, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams features_validate_params(
      0, ::media::mojom::internal::RemotingSinkFeature_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->features, validation_context,
                                         &features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_capabilities, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams audio_capabilities_validate_params(
      0, ::media::mojom::internal::RemotingSinkAudioCapability_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->audio_capabilities, validation_context,
                                         &audio_capabilities_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->video_capabilities, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams video_capabilities_validate_params(
      0, ::media::mojom::internal::RemotingSinkVideoCapability_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->video_capabilities, validation_context,
                                         &video_capabilities_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->friendly_name, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams friendly_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->friendly_name, validation_context,
                                         &friendly_name_validate_params)) {
    return false;
  }

  return true;
}

RemotingSinkMetadata_Data::RemotingSinkMetadata_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::RemotingStopReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::RemotingStopReason value) {
  return std::move(context).WriteString(::media::mojom::RemotingStopReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::RemotingStartFailReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::RemotingStartFailReason value) {
  return std::move(context).WriteString(::media::mojom::RemotingStartFailReasonToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::RemotingSinkFeature>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::RemotingSinkFeature value) {
  return std::move(context).WriteString(::media::mojom::RemotingSinkFeatureToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::RemotingSinkAudioCapability>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::RemotingSinkAudioCapability value) {
  return std::move(context).WriteString(::media::mojom::RemotingSinkAudioCapabilityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::RemotingSinkVideoCapability>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::RemotingSinkVideoCapability value) {
  return std::move(context).WriteString(::media::mojom::RemotingSinkVideoCapabilityToString(value));
}

} // namespace perfetto
