// media/mojo/mojom/renderer.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "media/mojo/mojom/renderer.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "media/mojo/mojom/demuxer_stream.mojom-blink.h"
#include "media/mojo/mojom/media_types.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/site_for_cookies.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"


#ifndef MEDIA_MOJO_MOJOM_RENDERER_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_RENDERER_MOJOM_BLINK_JUMBO_H_
#endif


namespace media {
namespace mojom {
namespace blink {


void RendererInterceptorForTesting::Initialize(::mojo::PendingAssociatedRemote<RendererClient> client, absl::optional<WTF::Vector<::mojo::PendingRemote<::media::mojom::blink::DemuxerStream>>> streams, MediaUrlParamsPtr media_url_params, InitializeCallback callback) {
  GetForwardingInterface()->Initialize(std::move(client), std::move(streams), std::move(media_url_params), std::move(callback));
}
void RendererInterceptorForTesting::Flush(FlushCallback callback) {
  GetForwardingInterface()->Flush(std::move(callback));
}
void RendererInterceptorForTesting::StartPlayingFrom(::base::TimeDelta time) {
  GetForwardingInterface()->StartPlayingFrom(std::move(time));
}
void RendererInterceptorForTesting::SetPlaybackRate(double playback_rate) {
  GetForwardingInterface()->SetPlaybackRate(std::move(playback_rate));
}
void RendererInterceptorForTesting::SetVolume(float volume) {
  GetForwardingInterface()->SetVolume(std::move(volume));
}
void RendererInterceptorForTesting::SetCdm(const absl::optional<::base::UnguessableToken>& cdm_id, SetCdmCallback callback) {
  GetForwardingInterface()->SetCdm(std::move(cdm_id), std::move(callback));
}
RendererAsyncWaiter::RendererAsyncWaiter(
    Renderer* proxy) : proxy_(proxy) {}

RendererAsyncWaiter::~RendererAsyncWaiter() = default;

void RendererAsyncWaiter::Initialize(
    ::mojo::PendingAssociatedRemote<RendererClient> client, absl::optional<WTF::Vector<::mojo::PendingRemote<::media::mojom::blink::DemuxerStream>>> streams, MediaUrlParamsPtr media_url_params, bool* out_success) {
  base::RunLoop loop;
  proxy_->Initialize(std::move(client),std::move(streams),std::move(media_url_params),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}
void RendererAsyncWaiter::Flush(
    ) {
  base::RunLoop loop;
  proxy_->Flush(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void RendererAsyncWaiter::SetCdm(
    const absl::optional<::base::UnguessableToken>& cdm_id, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetCdm(std::move(cdm_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}



void RendererClientInterceptorForTesting::OnTimeUpdate(::base::TimeDelta time, ::base::TimeDelta max_time, ::base::TimeTicks capture_time) {
  GetForwardingInterface()->OnTimeUpdate(std::move(time), std::move(max_time), std::move(capture_time));
}
void RendererClientInterceptorForTesting::OnBufferingStateChange(::media::mojom::blink::BufferingState state, ::media::mojom::blink::BufferingStateChangeReason reason) {
  GetForwardingInterface()->OnBufferingStateChange(std::move(state), std::move(reason));
}
void RendererClientInterceptorForTesting::OnEnded() {
  GetForwardingInterface()->OnEnded();
}
void RendererClientInterceptorForTesting::OnError(::media::mojom::blink::StatusPtr status) {
  GetForwardingInterface()->OnError(std::move(status));
}
void RendererClientInterceptorForTesting::OnAudioConfigChange(::media::mojom::blink::AudioDecoderConfigPtr config) {
  GetForwardingInterface()->OnAudioConfigChange(std::move(config));
}
void RendererClientInterceptorForTesting::OnVideoConfigChange(::media::mojom::blink::VideoDecoderConfigPtr config) {
  GetForwardingInterface()->OnVideoConfigChange(std::move(config));
}
void RendererClientInterceptorForTesting::OnVideoNaturalSizeChange(const ::gfx::Size& size) {
  GetForwardingInterface()->OnVideoNaturalSizeChange(std::move(size));
}
void RendererClientInterceptorForTesting::OnVideoOpacityChange(bool opaque) {
  GetForwardingInterface()->OnVideoOpacityChange(std::move(opaque));
}
void RendererClientInterceptorForTesting::OnStatisticsUpdate(::media::mojom::blink::PipelineStatisticsPtr stats) {
  GetForwardingInterface()->OnStatisticsUpdate(std::move(stats));
}
void RendererClientInterceptorForTesting::OnWaiting(::media::mojom::blink::WaitingReason reason) {
  GetForwardingInterface()->OnWaiting(std::move(reason));
}
RendererClientAsyncWaiter::RendererClientAsyncWaiter(
    RendererClient* proxy) : proxy_(proxy) {}

RendererClientAsyncWaiter::~RendererClientAsyncWaiter() = default;






}  // namespace blink
}  // namespace mojom
}  // namespace media

#if defined(__clang__)
#pragma clang diagnostic pop
#endif