// media/mojo/mojom/watch_time_recorder.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/watch_time_recorder.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/watch_time_recorder.mojom-params-data.h"
#include "media/mojo/mojom/watch_time_recorder.mojom-shared-message-ids.h"

#include "media/mojo/mojom/watch_time_recorder.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_BLINK_JUMBO_H_
#define MEDIA_MOJO_MOJOM_WATCH_TIME_RECORDER_MOJOM_BLINK_JUMBO_H_
#endif
namespace media {
namespace mojom {
namespace blink {
PlaybackProperties::PlaybackProperties()
    : has_audio(),
      has_video(),
      is_background(),
      is_muted(),
      is_mse(),
      is_eme(),
      is_embedded_media_experience(),
      media_stream_type() {}

PlaybackProperties::PlaybackProperties(
    bool has_audio_in,
    bool has_video_in,
    bool is_background_in,
    bool is_muted_in,
    bool is_mse_in,
    bool is_eme_in,
    bool is_embedded_media_experience_in,
    ::media::mojom::blink::MediaStreamType media_stream_type_in)
    : has_audio(std::move(has_audio_in)),
      has_video(std::move(has_video_in)),
      is_background(std::move(is_background_in)),
      is_muted(std::move(is_muted_in)),
      is_mse(std::move(is_mse_in)),
      is_eme(std::move(is_eme_in)),
      is_embedded_media_experience(std::move(is_embedded_media_experience_in)),
      media_stream_type(std::move(media_stream_type_in)) {}

PlaybackProperties::~PlaybackProperties() = default;
size_t PlaybackProperties::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->has_audio);
  seed = mojo::internal::WTFHash(seed, this->has_video);
  seed = mojo::internal::WTFHash(seed, this->is_background);
  seed = mojo::internal::WTFHash(seed, this->is_muted);
  seed = mojo::internal::WTFHash(seed, this->is_mse);
  seed = mojo::internal::WTFHash(seed, this->is_eme);
  seed = mojo::internal::WTFHash(seed, this->is_embedded_media_experience);
  seed = mojo::internal::WTFHash(seed, this->media_stream_type);
  return seed;
}

void PlaybackProperties::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_audio"), this->has_audio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_video"), this->has_video,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_background"), this->is_background,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_muted"), this->is_muted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_mse"), this->is_mse,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_eme"), this->is_eme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_embedded_media_experience"), this->is_embedded_media_experience,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_stream_type"), this->media_stream_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::MediaStreamType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PlaybackProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SecondaryPlaybackProperties::SecondaryPlaybackProperties()
    : audio_codec(),
      video_codec(),
      audio_codec_profile(),
      video_codec_profile(),
      audio_decoder(),
      video_decoder(),
      audio_encryption_scheme(),
      video_encryption_scheme(),
      natural_size() {}

SecondaryPlaybackProperties::SecondaryPlaybackProperties(
    ::media::mojom::blink::AudioCodec audio_codec_in,
    ::media::mojom::blink::VideoCodec video_codec_in,
    ::media::mojom::blink::AudioCodecProfile audio_codec_profile_in,
    ::media::mojom::blink::VideoCodecProfile video_codec_profile_in,
    ::media::mojom::blink::AudioDecoderType audio_decoder_in,
    ::media::mojom::blink::VideoDecoderType video_decoder_in,
    ::media::mojom::blink::EncryptionScheme audio_encryption_scheme_in,
    ::media::mojom::blink::EncryptionScheme video_encryption_scheme_in,
    const ::gfx::Size& natural_size_in)
    : audio_codec(std::move(audio_codec_in)),
      video_codec(std::move(video_codec_in)),
      audio_codec_profile(std::move(audio_codec_profile_in)),
      video_codec_profile(std::move(video_codec_profile_in)),
      audio_decoder(std::move(audio_decoder_in)),
      video_decoder(std::move(video_decoder_in)),
      audio_encryption_scheme(std::move(audio_encryption_scheme_in)),
      video_encryption_scheme(std::move(video_encryption_scheme_in)),
      natural_size(std::move(natural_size_in)) {}

SecondaryPlaybackProperties::~SecondaryPlaybackProperties() = default;

void SecondaryPlaybackProperties::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_codec"), this->audio_codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::AudioCodec>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_codec"), this->video_codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::VideoCodec>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_codec_profile"), this->audio_codec_profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::AudioCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_codec_profile"), this->video_codec_profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_decoder"), this->audio_decoder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::AudioDecoderType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_decoder"), this->video_decoder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::VideoDecoderType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_encryption_scheme"), this->audio_encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_encryption_scheme"), this->video_encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "natural_size"), this->natural_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SecondaryPlaybackProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char WatchTimeRecorder::Name_[] = "media.mojom.WatchTimeRecorder";

WatchTimeRecorderProxy::WatchTimeRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WatchTimeRecorderProxy::RecordWatchTime(
    ::media::mojom::blink::WatchTimeKey in_key, ::base::TimeDelta in_watch_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::RecordWatchTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type ::media::mojom::blink::WatchTimeKey>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("watch_time"), in_watch_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_RecordWatchTime_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_RecordWatchTime_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::WatchTimeKey>(
      in_key, &params->key);
  mojo::internal::MessageFragment<
      typename decltype(params->watch_time)::BaseType> watch_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_watch_time, watch_time_fragment);
  params->watch_time.Set(
      watch_time_fragment.is_null() ? nullptr : watch_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->watch_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null watch_time in WatchTimeRecorder.RecordWatchTime request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("RecordWatchTime");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::FinalizeWatchTime(
    const WTF::Vector<::media::mojom::blink::WatchTimeKey>& in_watch_time_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::FinalizeWatchTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("watch_time_keys"), in_watch_time_keys,
                        "<value of type const WTF::Vector<::media::mojom::blink::WatchTimeKey>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_FinalizeWatchTime_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->watch_time_keys)::BaseType>
      watch_time_keys_fragment(params.message());
  const mojo::internal::ContainerValidateParams watch_time_keys_validate_params(
      0, ::media::mojom::internal::WatchTimeKey_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::WatchTimeKey>>(
      in_watch_time_keys, watch_time_keys_fragment, &watch_time_keys_validate_params);
  params->watch_time_keys.Set(
      watch_time_keys_fragment.is_null() ? nullptr : watch_time_keys_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->watch_time_keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null watch_time_keys in WatchTimeRecorder.FinalizeWatchTime request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("FinalizeWatchTime");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::OnError(
    ::media::mojom::blink::PipelineStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::mojom::blink::PipelineStatus>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_OnError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::PipelineStatus>(
      in_status, &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::UpdateSecondaryProperties(
    SecondaryPlaybackPropertiesPtr in_secondary_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::UpdateSecondaryProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secondary_properties"), in_secondary_properties,
                        "<value of type SecondaryPlaybackPropertiesPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_UpdateSecondaryProperties_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->secondary_properties)::BaseType> secondary_properties_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::SecondaryPlaybackPropertiesDataView>(
      in_secondary_properties, secondary_properties_fragment);
  params->secondary_properties.Set(
      secondary_properties_fragment.is_null() ? nullptr : secondary_properties_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->secondary_properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null secondary_properties in WatchTimeRecorder.UpdateSecondaryProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateSecondaryProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::SetAutoplayInitiated(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::SetAutoplayInitiated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_SetAutoplayInitiated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data> params(
          message);
  params.Allocate();
  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("SetAutoplayInitiated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::OnDurationChanged(
    ::base::TimeDelta in_duration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::OnDurationChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration"), in_duration,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_OnDurationChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_OnDurationChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->duration)::BaseType> duration_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_duration, duration_fragment);
  params->duration.Set(
      duration_fragment.is_null() ? nullptr : duration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->duration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duration in WatchTimeRecorder.OnDurationChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("OnDurationChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::UpdateVideoDecodeStats(
    uint32_t in_frames_decoded, uint32_t in_frames_dropped) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::UpdateVideoDecodeStats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frames_decoded"), in_frames_decoded,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frames_dropped"), in_frames_dropped,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_UpdateVideoDecodeStats_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data> params(
          message);
  params.Allocate();
  params->frames_decoded = in_frames_decoded;
  params->frames_dropped = in_frames_dropped;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateVideoDecodeStats");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::UpdateUnderflowCount(
    int32_t in_total_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::UpdateUnderflowCount", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_count"), in_total_count,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_UpdateUnderflowCount_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data> params(
          message);
  params.Allocate();
  params->total_count = in_total_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateUnderflowCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::UpdateUnderflowDuration(
    int32_t in_total_completed_count, ::base::TimeDelta in_total_duration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::UpdateUnderflowDuration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_completed_count"), in_total_completed_count,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_duration"), in_total_duration,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_UpdateUnderflowDuration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data> params(
          message);
  params.Allocate();
  params->total_completed_count = in_total_completed_count;
  mojo::internal::MessageFragment<
      typename decltype(params->total_duration)::BaseType> total_duration_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_total_duration, total_duration_fragment);
  params->total_duration.Set(
      total_duration_fragment.is_null() ? nullptr : total_duration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->total_duration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null total_duration in WatchTimeRecorder.UpdateUnderflowDuration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("UpdateUnderflowDuration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WatchTimeRecorderProxy::OnCurrentTimestampChanged(
    ::base::TimeDelta in_last_timestamp) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::WatchTimeRecorder::OnCurrentTimestampChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("last_timestamp"), in_last_timestamp,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWatchTimeRecorder_OnCurrentTimestampChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->last_timestamp)::BaseType> last_timestamp_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_last_timestamp, last_timestamp_fragment);
  params->last_timestamp.Set(
      last_timestamp_fragment.is_null() ? nullptr : last_timestamp_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->last_timestamp.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_timestamp in WatchTimeRecorder.OnCurrentTimestampChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WatchTimeRecorder::Name_);
  message.set_method_name("OnCurrentTimestampChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WatchTimeRecorderStubDispatch::Accept(
    WatchTimeRecorder* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWatchTimeRecorder_RecordWatchTime_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::RecordWatchTime",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::RecordWatchTime");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_RecordWatchTime_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_RecordWatchTime_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::WatchTimeKey p_key{};
      ::base::TimeDelta p_watch_time{};
      WatchTimeRecorder_RecordWatchTime_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadWatchTime(&p_watch_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordWatchTime(
std::move(p_key), 
std::move(p_watch_time));
      return true;
    }
    case internal::kWatchTimeRecorder_FinalizeWatchTime_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::FinalizeWatchTime",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::FinalizeWatchTime");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::media::mojom::blink::WatchTimeKey> p_watch_time_keys{};
      WatchTimeRecorder_FinalizeWatchTime_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWatchTimeKeys(&p_watch_time_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FinalizeWatchTime(
std::move(p_watch_time_keys));
      return true;
    }
    case internal::kWatchTimeRecorder_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_OnError_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media::mojom::blink::PipelineStatus p_status{};
      WatchTimeRecorder_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_status));
      return true;
    }
    case internal::kWatchTimeRecorder_UpdateSecondaryProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::UpdateSecondaryProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::UpdateSecondaryProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SecondaryPlaybackPropertiesPtr p_secondary_properties{};
      WatchTimeRecorder_UpdateSecondaryProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSecondaryProperties(&p_secondary_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSecondaryProperties(
std::move(p_secondary_properties));
      return true;
    }
    case internal::kWatchTimeRecorder_SetAutoplayInitiated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::SetAutoplayInitiated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::SetAutoplayInitiated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_value{};
      WatchTimeRecorder_SetAutoplayInitiated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAutoplayInitiated(
std::move(p_value));
      return true;
    }
    case internal::kWatchTimeRecorder_OnDurationChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::OnDurationChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::OnDurationChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_OnDurationChanged_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_OnDurationChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_duration{};
      WatchTimeRecorder_OnDurationChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDuration(&p_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDurationChanged(
std::move(p_duration));
      return true;
    }
    case internal::kWatchTimeRecorder_UpdateVideoDecodeStats_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::UpdateVideoDecodeStats",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::UpdateVideoDecodeStats");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_frames_decoded{};
      uint32_t p_frames_dropped{};
      WatchTimeRecorder_UpdateVideoDecodeStats_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frames_decoded = input_data_view.frames_decoded();
      if (success)
        p_frames_dropped = input_data_view.frames_dropped();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateVideoDecodeStats(
std::move(p_frames_decoded), 
std::move(p_frames_dropped));
      return true;
    }
    case internal::kWatchTimeRecorder_UpdateUnderflowCount_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::UpdateUnderflowCount",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::UpdateUnderflowCount");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_total_count{};
      WatchTimeRecorder_UpdateUnderflowCount_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_total_count = input_data_view.total_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUnderflowCount(
std::move(p_total_count));
      return true;
    }
    case internal::kWatchTimeRecorder_UpdateUnderflowDuration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::UpdateUnderflowDuration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::UpdateUnderflowDuration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_total_completed_count{};
      ::base::TimeDelta p_total_duration{};
      WatchTimeRecorder_UpdateUnderflowDuration_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_total_completed_count = input_data_view.total_completed_count();
      if (success && !input_data_view.ReadTotalDuration(&p_total_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUnderflowDuration(
std::move(p_total_completed_count), 
std::move(p_total_duration));
      return true;
    }
    case internal::kWatchTimeRecorder_OnCurrentTimestampChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::WatchTimeRecorder::OnCurrentTimestampChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::WatchTimeRecorder::OnCurrentTimestampChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data* params =
          reinterpret_cast<internal::WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_last_timestamp{};
      WatchTimeRecorder_OnCurrentTimestampChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLastTimestamp(&p_last_timestamp))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WatchTimeRecorder::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCurrentTimestampChanged(
std::move(p_last_timestamp));
      return true;
    }
  }
  return false;
}

// static
bool WatchTimeRecorderStubDispatch::AcceptWithResponder(
    WatchTimeRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWatchTimeRecorder_RecordWatchTime_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_FinalizeWatchTime_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_OnError_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_UpdateSecondaryProperties_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_SetAutoplayInitiated_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_OnDurationChanged_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_UpdateVideoDecodeStats_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_UpdateUnderflowCount_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_UpdateUnderflowDuration_Name: {
      break;
    }
    case internal::kWatchTimeRecorder_OnCurrentTimestampChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWatchTimeRecorderValidationInfo[] = {
    {internal::kWatchTimeRecorder_RecordWatchTime_Name,
     {&internal::WatchTimeRecorder_RecordWatchTime_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_FinalizeWatchTime_Name,
     {&internal::WatchTimeRecorder_FinalizeWatchTime_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_OnError_Name,
     {&internal::WatchTimeRecorder_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_UpdateSecondaryProperties_Name,
     {&internal::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_SetAutoplayInitiated_Name,
     {&internal::WatchTimeRecorder_SetAutoplayInitiated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_OnDurationChanged_Name,
     {&internal::WatchTimeRecorder_OnDurationChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_UpdateVideoDecodeStats_Name,
     {&internal::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_UpdateUnderflowCount_Name,
     {&internal::WatchTimeRecorder_UpdateUnderflowCount_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_UpdateUnderflowDuration_Name,
     {&internal::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWatchTimeRecorder_OnCurrentTimestampChanged_Name,
     {&internal::WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WatchTimeRecorderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::WatchTimeRecorder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWatchTimeRecorderValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace media

namespace mojo {


// static
bool StructTraits<::media::mojom::blink::PlaybackProperties::DataView, ::media::mojom::blink::PlaybackPropertiesPtr>::Read(
    ::media::mojom::blink::PlaybackProperties::DataView input,
    ::media::mojom::blink::PlaybackPropertiesPtr* output) {
  bool success = true;
  ::media::mojom::blink::PlaybackPropertiesPtr result(::media::mojom::blink::PlaybackProperties::New());
  
      if (success)
        result->has_audio = input.has_audio();
      if (success)
        result->has_video = input.has_video();
      if (success)
        result->is_background = input.is_background();
      if (success)
        result->is_muted = input.is_muted();
      if (success)
        result->is_mse = input.is_mse();
      if (success)
        result->is_eme = input.is_eme();
      if (success)
        result->is_embedded_media_experience = input.is_embedded_media_experience();
      if (success && !input.ReadMediaStreamType(&result->media_stream_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::SecondaryPlaybackProperties::DataView, ::media::mojom::blink::SecondaryPlaybackPropertiesPtr>::Read(
    ::media::mojom::blink::SecondaryPlaybackProperties::DataView input,
    ::media::mojom::blink::SecondaryPlaybackPropertiesPtr* output) {
  bool success = true;
  ::media::mojom::blink::SecondaryPlaybackPropertiesPtr result(::media::mojom::blink::SecondaryPlaybackProperties::New());
  
      if (success && !input.ReadAudioCodec(&result->audio_codec))
        success = false;
      if (success && !input.ReadVideoCodec(&result->video_codec))
        success = false;
      if (success && !input.ReadAudioCodecProfile(&result->audio_codec_profile))
        success = false;
      if (success && !input.ReadVideoCodecProfile(&result->video_codec_profile))
        success = false;
      if (success && !input.ReadAudioDecoder(&result->audio_decoder))
        success = false;
      if (success && !input.ReadVideoDecoder(&result->video_decoder))
        success = false;
      if (success && !input.ReadAudioEncryptionScheme(&result->audio_encryption_scheme))
        success = false;
      if (success && !input.ReadVideoEncryptionScheme(&result->video_encryption_scheme))
        success = false;
      if (success && !input.ReadNaturalSize(&result->natural_size))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif