// media/mojo/mojom/watch_time_recorder.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/watch_time_recorder.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/watch_time_recorder.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {


// static
bool PlaybackProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const PlaybackProperties_Data* object = static_cast<const PlaybackProperties_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::MediaStreamType_Data
        ::Validate(object->media_stream_type, validation_context))
    return false;

  return true;
}

PlaybackProperties_Data::PlaybackProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SecondaryPlaybackProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SecondaryPlaybackProperties_Data* object = static_cast<const SecondaryPlaybackProperties_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::AudioCodec_Data
        ::Validate(object->audio_codec, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCodec_Data
        ::Validate(object->video_codec, validation_context))
    return false;


  if (!::media::mojom::internal::AudioCodecProfile_Data
        ::Validate(object->audio_codec_profile, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->video_codec_profile, validation_context))
    return false;


  if (!::media::mojom::internal::AudioDecoderType_Data
        ::Validate(object->audio_decoder, validation_context))
    return false;


  if (!::media::mojom::internal::VideoDecoderType_Data
        ::Validate(object->video_decoder, validation_context))
    return false;


  if (!::media::mojom::internal::EncryptionScheme_Data
        ::Validate(object->audio_encryption_scheme, validation_context))
    return false;


  if (!::media::mojom::internal::EncryptionScheme_Data
        ::Validate(object->video_encryption_scheme, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->natural_size, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->natural_size, validation_context))
    return false;

  return true;
}

SecondaryPlaybackProperties_Data::SecondaryPlaybackProperties_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchTimeRecorder_RecordWatchTime_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WatchTimeRecorder_RecordWatchTime_Params_Data* object = static_cast<const WatchTimeRecorder_RecordWatchTime_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::WatchTimeKey_Data
        ::Validate(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->watch_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->watch_time, validation_context))
    return false;

  return true;
}

WatchTimeRecorder_RecordWatchTime_Params_Data::WatchTimeRecorder_RecordWatchTime_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchTimeRecorder_FinalizeWatchTime_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WatchTimeRecorder_FinalizeWatchTime_Params_Data* object = static_cast<const WatchTimeRecorder_FinalizeWatchTime_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->watch_time_keys, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams watch_time_keys_validate_params(
      0, ::media::mojom::internal::WatchTimeKey_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->watch_time_keys, validation_context,
                                         &watch_time_keys_validate_params)) {
    return false;
  }

  return true;
}

WatchTimeRecorder_FinalizeWatchTime_Params_Data::WatchTimeRecorder_FinalizeWatchTime_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchTimeRecorder_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WatchTimeRecorder_OnError_Params_Data* object = static_cast<const WatchTimeRecorder_OnError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::media::mojom::internal::PipelineStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

WatchTimeRecorder_OnError_Params_Data::WatchTimeRecorder_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchTimeRecorder_UpdateSecondaryProperties_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WatchTimeRecorder_UpdateSecondaryProperties_Params_Data* object = static_cast<const WatchTimeRecorder_UpdateSecondaryProperties_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->secondary_properties, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->secondary_properties, validation_context))
    return false;

  return true;
}

WatchTimeRecorder_UpdateSecondaryProperties_Params_Data::WatchTimeRecorder_UpdateSecondaryProperties_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchTimeRecorder_SetAutoplayInitiated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WatchTimeRecorder_SetAutoplayInitiated_Params_Data* object = static_cast<const WatchTimeRecorder_SetAutoplayInitiated_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WatchTimeRecorder_SetAutoplayInitiated_Params_Data::WatchTimeRecorder_SetAutoplayInitiated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchTimeRecorder_OnDurationChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WatchTimeRecorder_OnDurationChanged_Params_Data* object = static_cast<const WatchTimeRecorder_OnDurationChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  return true;
}

WatchTimeRecorder_OnDurationChanged_Params_Data::WatchTimeRecorder_OnDurationChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data* object = static_cast<const WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data::WatchTimeRecorder_UpdateVideoDecodeStats_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchTimeRecorder_UpdateUnderflowCount_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WatchTimeRecorder_UpdateUnderflowCount_Params_Data* object = static_cast<const WatchTimeRecorder_UpdateUnderflowCount_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WatchTimeRecorder_UpdateUnderflowCount_Params_Data::WatchTimeRecorder_UpdateUnderflowCount_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchTimeRecorder_UpdateUnderflowDuration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WatchTimeRecorder_UpdateUnderflowDuration_Params_Data* object = static_cast<const WatchTimeRecorder_UpdateUnderflowDuration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->total_duration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->total_duration, validation_context))
    return false;

  return true;
}

WatchTimeRecorder_UpdateUnderflowDuration_Params_Data::WatchTimeRecorder_UpdateUnderflowDuration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data* object = static_cast<const WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_timestamp, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_timestamp, validation_context))
    return false;

  return true;
}

WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data::WatchTimeRecorder_OnCurrentTimestampChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media
