// mojo/public/interfaces/bindings/native_struct.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "mojo/public/interfaces/bindings/native_struct.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/interfaces/bindings/native_struct.mojom-params-data.h"
namespace mojo {
namespace native {

static NOINLINE const char* SerializedHandleTypeToStringHelper(SerializedHandleType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SerializedHandleType::MOJO_HANDLE:
      return "MOJO_HANDLE";
    case SerializedHandleType::PLATFORM_FILE:
      return "PLATFORM_FILE";
    case SerializedHandleType::WIN_HANDLE:
      return "WIN_HANDLE";
    case SerializedHandleType::MACH_PORT:
      return "MACH_PORT";
    case SerializedHandleType::FUCHSIA_HANDLE:
      return "FUCHSIA_HANDLE";
    default:
      return nullptr;
  }
}

std::string SerializedHandleTypeToString(SerializedHandleType value) {
  const char *str = SerializedHandleTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SerializedHandleType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SerializedHandleType value) {
  return os << SerializedHandleTypeToString(value);
}

namespace internal {


// static
bool SerializedHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SerializedHandle_Data* object = static_cast<const SerializedHandle_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->the_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->the_handle,
                                                 validation_context)) {
    return false;
  }


  if (!::mojo::native::internal::SerializedHandleType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

SerializedHandle_Data::SerializedHandle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeStruct_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NativeStruct_Data* object = static_cast<const NativeStruct_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams handles_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->handles, validation_context,
                                         &handles_validate_params)) {
    return false;
  }

  return true;
}

NativeStruct_Data::NativeStruct_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace native
}  // namespace mojo

namespace perfetto {

// static
void TraceFormatTraits<::mojo::native::SerializedHandleType>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojo::native::SerializedHandleType value) {
  return std::move(context).WriteString(::mojo::native::SerializedHandleTypeToString(value));
}

} // namespace perfetto
