// mojo/public/mojom/base/values.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "mojo/public/mojom/base/values.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/mojom/base/values.mojom-params-data.h"
namespace mojo_base {
namespace mojom {

namespace internal {
// static
bool Value_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const Value_Data* object = static_cast<const Value_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case Value_Tag::NULL_VALUE: {

      return true;
    }
    case Value_Tag::BOOL_VALUE: {

      return true;
    }
    case Value_Tag::INT_VALUE: {

      return true;
    }
    case Value_Tag::DOUBLE_VALUE: {

      return true;
    }
    case Value_Tag::STRING_VALUE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_string_value, 5, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams string_value_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_string_value, validation_context,
                                             &string_value_validate_params)) {
        return false;
      }
      return true;
    }
    case Value_Tag::BINARY_VALUE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_binary_value, 6, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams binary_value_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_binary_value, validation_context,
                                             &binary_value_validate_params)) {
        return false;
      }
      return true;
    }
    case Value_Tag::DICTIONARY_VALUE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_dictionary_value, 7, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_dictionary_value, validation_context))
        return false;
      return true;
    }
    case Value_Tag::LIST_VALUE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_list_value, 8, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_list_value, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in Value");
      return false;
    }
  }
}


// static
bool DictionaryValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DictionaryValue_Data* object = static_cast<const DictionaryValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->storage, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams storage_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->storage, validation_context,
                                         &storage_validate_params)) {
    return false;
  }

  return true;
}

DictionaryValue_Data::DictionaryValue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ListValue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ListValue_Data* object = static_cast<const ListValue_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->storage, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams storage_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->storage, validation_context,
                                         &storage_validate_params)) {
    return false;
  }

  return true;
}

ListValue_Data::ListValue_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace mojo_base
