// pdf/mojom/pdf.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "pdf/mojom/pdf.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "pdf/mojom/pdf.mojom-params-data.h"
#include "pdf/mojom/pdf.mojom-shared-message-ids.h"

#include "pdf/mojom/pdf.mojom-import-headers.h"


#ifndef PDF_MOJOM_PDF_MOJOM_JUMBO_H_
#define PDF_MOJOM_PDF_MOJOM_JUMBO_H_
#endif
namespace pdf {
namespace mojom {
const char PdfListener::Name_[] = "pdf.mojom.PdfListener";

PdfListenerProxy::PdfListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PdfListenerProxy::SetCaretPosition(
    const ::gfx::PointF& in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "pdf::mojom::PdfListener::SetCaretPosition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type const ::gfx::PointF&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPdfListener_SetCaretPosition_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_SetCaretPosition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->position)::BaseType> position_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_position, position_fragment);
  params->position.Set(
      position_fragment.is_null() ? nullptr : position_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->position.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null position in PdfListener.SetCaretPosition request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("SetCaretPosition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PdfListenerProxy::MoveRangeSelectionExtent(
    const ::gfx::PointF& in_extent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "pdf::mojom::PdfListener::MoveRangeSelectionExtent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extent"), in_extent,
                        "<value of type const ::gfx::PointF&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPdfListener_MoveRangeSelectionExtent_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_MoveRangeSelectionExtent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extent)::BaseType> extent_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_extent, extent_fragment);
  params->extent.Set(
      extent_fragment.is_null() ? nullptr : extent_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extent in PdfListener.MoveRangeSelectionExtent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("MoveRangeSelectionExtent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PdfListenerProxy::SetSelectionBounds(
    const ::gfx::PointF& in_base, const ::gfx::PointF& in_extent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "pdf::mojom::PdfListener::SetSelectionBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("base"), in_base,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extent"), in_extent,
                        "<value of type const ::gfx::PointF&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPdfListener_SetSelectionBounds_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfListener_SetSelectionBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->base)::BaseType> base_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_base, base_fragment);
  params->base.Set(
      base_fragment.is_null() ? nullptr : base_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->base.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null base in PdfListener.SetSelectionBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->extent)::BaseType> extent_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_extent, extent_fragment);
  params->extent.Set(
      extent_fragment.is_null() ? nullptr : extent_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extent in PdfListener.SetSelectionBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfListener::Name_);
  message.set_method_name("SetSelectionBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PdfListenerStubDispatch::Accept(
    PdfListener* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPdfListener_SetCaretPosition_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)pdf::mojom::PdfListener::SetCaretPosition",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)pdf::mojom::PdfListener::SetCaretPosition");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PdfListener_SetCaretPosition_Params_Data* params =
          reinterpret_cast<internal::PdfListener_SetCaretPosition_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::PointF p_position{};
      PdfListener_SetCaretPosition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCaretPosition(
std::move(p_position));
      return true;
    }
    case internal::kPdfListener_MoveRangeSelectionExtent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)pdf::mojom::PdfListener::MoveRangeSelectionExtent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)pdf::mojom::PdfListener::MoveRangeSelectionExtent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PdfListener_MoveRangeSelectionExtent_Params_Data* params =
          reinterpret_cast<internal::PdfListener_MoveRangeSelectionExtent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::PointF p_extent{};
      PdfListener_MoveRangeSelectionExtent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtent(&p_extent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfListener::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveRangeSelectionExtent(
std::move(p_extent));
      return true;
    }
    case internal::kPdfListener_SetSelectionBounds_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)pdf::mojom::PdfListener::SetSelectionBounds",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)pdf::mojom::PdfListener::SetSelectionBounds");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PdfListener_SetSelectionBounds_Params_Data* params =
          reinterpret_cast<internal::PdfListener_SetSelectionBounds_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::PointF p_base{};
      ::gfx::PointF p_extent{};
      PdfListener_SetSelectionBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBase(&p_base))
        success = false;
      if (success && !input_data_view.ReadExtent(&p_extent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfListener::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSelectionBounds(
std::move(p_base), 
std::move(p_extent));
      return true;
    }
  }
  return false;
}

// static
bool PdfListenerStubDispatch::AcceptWithResponder(
    PdfListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPdfListener_SetCaretPosition_Name: {
      break;
    }
    case internal::kPdfListener_MoveRangeSelectionExtent_Name: {
      break;
    }
    case internal::kPdfListener_SetSelectionBounds_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPdfListenerValidationInfo[] = {
    {internal::kPdfListener_SetCaretPosition_Name,
     {&internal::PdfListener_SetCaretPosition_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPdfListener_MoveRangeSelectionExtent_Name,
     {&internal::PdfListener_MoveRangeSelectionExtent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPdfListener_SetSelectionBounds_Name,
     {&internal::PdfListener_SetSelectionBounds_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PdfListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::pdf::mojom::PdfListener::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPdfListenerValidationInfo);
}

const char PdfService::Name_[] = "pdf.mojom.PdfService";

PdfServiceProxy::PdfServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PdfServiceProxy::SetListener(
    ::mojo::PendingRemote<PdfListener> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "pdf::mojom::PdfService::SetListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<PdfListener>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPdfService_SetListener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfService_SetListener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::pdf::mojom::PdfListenerInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in PdfService.SetListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfService::Name_);
  message.set_method_name("SetListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PdfServiceProxy::UpdateContentRestrictions(
    int32_t in_restrictions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "pdf::mojom::PdfService::UpdateContentRestrictions", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("restrictions"), in_restrictions,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPdfService_UpdateContentRestrictions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfService_UpdateContentRestrictions_Params_Data> params(
          message);
  params.Allocate();
  params->restrictions = in_restrictions;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfService::Name_);
  message.set_method_name("UpdateContentRestrictions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PdfServiceProxy::HasUnsupportedFeature(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "pdf::mojom::PdfService::HasUnsupportedFeature");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPdfService_HasUnsupportedFeature_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfService_HasUnsupportedFeature_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfService::Name_);
  message.set_method_name("HasUnsupportedFeature");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PdfServiceProxy::SaveUrlAs(
    const ::GURL& in_url, ::network::mojom::ReferrerPolicy in_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "pdf::mojom::PdfService::SaveUrlAs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy"), in_policy,
                        "<value of type ::network::mojom::ReferrerPolicy>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPdfService_SaveUrlAs_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfService_SaveUrlAs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PdfService.SaveUrlAs request");
  mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
      in_policy, &params->policy);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfService::Name_);
  message.set_method_name("SaveUrlAs");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PdfServiceProxy::SelectionChanged(
    const ::gfx::PointF& in_left, int32_t in_left_height, const ::gfx::PointF& in_right, int32_t in_right_height) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "pdf::mojom::PdfService::SelectionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("left"), in_left,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("left_height"), in_left_height,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("right"), in_right,
                        "<value of type const ::gfx::PointF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("right_height"), in_right_height,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPdfService_SelectionChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfService_SelectionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->left)::BaseType> left_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_left, left_fragment);
  params->left.Set(
      left_fragment.is_null() ? nullptr : left_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->left.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null left in PdfService.SelectionChanged request");
  params->left_height = in_left_height;
  mojo::internal::MessageFragment<
      typename decltype(params->right)::BaseType> right_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_right, right_fragment);
  params->right.Set(
      right_fragment.is_null() ? nullptr : right_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->right.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null right in PdfService.SelectionChanged request");
  params->right_height = in_right_height;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfService::Name_);
  message.set_method_name("SelectionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PdfServiceProxy::SetPluginCanSave(
    bool in_can_save) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "pdf::mojom::PdfService::SetPluginCanSave", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_save"), in_can_save,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kPdfService_SetPluginCanSave_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::pdf::mojom::internal::PdfService_SetPluginCanSave_Params_Data> params(
          message);
  params.Allocate();
  params->can_save = in_can_save;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfService::Name_);
  message.set_method_name("SetPluginCanSave");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PdfServiceStubDispatch::Accept(
    PdfService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kPdfService_SetListener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)pdf::mojom::PdfService::SetListener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)pdf::mojom::PdfService::SetListener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PdfService_SetListener_Params_Data* params =
          reinterpret_cast<internal::PdfService_SetListener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<PdfListener> p_client{};
      PdfService_SetListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetListener(
std::move(p_client));
      return true;
    }
    case internal::kPdfService_UpdateContentRestrictions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)pdf::mojom::PdfService::UpdateContentRestrictions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)pdf::mojom::PdfService::UpdateContentRestrictions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PdfService_UpdateContentRestrictions_Params_Data* params =
          reinterpret_cast<internal::PdfService_UpdateContentRestrictions_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_restrictions{};
      PdfService_UpdateContentRestrictions_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_restrictions = input_data_view.restrictions();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateContentRestrictions(
std::move(p_restrictions));
      return true;
    }
    case internal::kPdfService_HasUnsupportedFeature_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)pdf::mojom::PdfService::HasUnsupportedFeature",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)pdf::mojom::PdfService::HasUnsupportedFeature");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PdfService_HasUnsupportedFeature_Params_Data* params =
          reinterpret_cast<internal::PdfService_HasUnsupportedFeature_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PdfService_HasUnsupportedFeature_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasUnsupportedFeature();
      return true;
    }
    case internal::kPdfService_SaveUrlAs_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)pdf::mojom::PdfService::SaveUrlAs",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)pdf::mojom::PdfService::SaveUrlAs");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PdfService_SaveUrlAs_Params_Data* params =
          reinterpret_cast<internal::PdfService_SaveUrlAs_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::network::mojom::ReferrerPolicy p_policy{};
      PdfService_SaveUrlAs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadPolicy(&p_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveUrlAs(
std::move(p_url), 
std::move(p_policy));
      return true;
    }
    case internal::kPdfService_SelectionChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)pdf::mojom::PdfService::SelectionChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)pdf::mojom::PdfService::SelectionChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PdfService_SelectionChanged_Params_Data* params =
          reinterpret_cast<internal::PdfService_SelectionChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::PointF p_left{};
      int32_t p_left_height{};
      ::gfx::PointF p_right{};
      int32_t p_right_height{};
      PdfService_SelectionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLeft(&p_left))
        success = false;
      if (success)
        p_left_height = input_data_view.left_height();
      if (success && !input_data_view.ReadRight(&p_right))
        success = false;
      if (success)
        p_right_height = input_data_view.right_height();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectionChanged(
std::move(p_left), 
std::move(p_left_height), 
std::move(p_right), 
std::move(p_right_height));
      return true;
    }
    case internal::kPdfService_SetPluginCanSave_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)pdf::mojom::PdfService::SetPluginCanSave",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)pdf::mojom::PdfService::SetPluginCanSave");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PdfService_SetPluginCanSave_Params_Data* params =
          reinterpret_cast<internal::PdfService_SetPluginCanSave_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_can_save{};
      PdfService_SetPluginCanSave_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_can_save = input_data_view.can_save();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPluginCanSave(
std::move(p_can_save));
      return true;
    }
  }
  return false;
}

// static
bool PdfServiceStubDispatch::AcceptWithResponder(
    PdfService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPdfService_SetListener_Name: {
      break;
    }
    case internal::kPdfService_UpdateContentRestrictions_Name: {
      break;
    }
    case internal::kPdfService_HasUnsupportedFeature_Name: {
      break;
    }
    case internal::kPdfService_SaveUrlAs_Name: {
      break;
    }
    case internal::kPdfService_SelectionChanged_Name: {
      break;
    }
    case internal::kPdfService_SetPluginCanSave_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPdfServiceValidationInfo[] = {
    {internal::kPdfService_SetListener_Name,
     {&internal::PdfService_SetListener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPdfService_UpdateContentRestrictions_Name,
     {&internal::PdfService_UpdateContentRestrictions_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPdfService_HasUnsupportedFeature_Name,
     {&internal::PdfService_HasUnsupportedFeature_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPdfService_SaveUrlAs_Name,
     {&internal::PdfService_SaveUrlAs_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPdfService_SelectionChanged_Name,
     {&internal::PdfService_SelectionChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPdfService_SetPluginCanSave_Name,
     {&internal::PdfService_SetPluginCanSave_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PdfServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::pdf::mojom::PdfService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPdfServiceValidationInfo);
}

}  // namespace mojom
}  // namespace pdf

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif