// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   qtwebengine/common/extensions/api/tabs.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "qtwebengine/common/extensions/api/tabs.h"

#include <memory>
#include <ostream>
#include <string>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace tabs {
//
// Properties
//

const int TAB_ID_NONE = -1;

//
// Types
//

Tab::Tab()
: id(0),
index(0),
window_id(0),
selected(false),
highlighted(false),
active(false),
pinned(false),
incognito(false) {}

Tab::~Tab() = default;
Tab::Tab(Tab&& rhs) = default;
Tab& Tab::operator=(Tab&& rhs) = default;
// static
bool Tab::Populate(
    const base::Value& value, Tab* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* id_value = dict->FindKey("id");
  if (!id_value) {
    return false;
  }
  {
    auto temp = id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->id = temp.value();
  }

  const base::Value* index_value = dict->FindKey("index");
  if (!index_value) {
    return false;
  }
  {
    auto temp = index_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->index = temp.value();
  }

  const base::Value* window_id_value = dict->FindKey("windowId");
  if (!window_id_value) {
    return false;
  }
  {
    auto temp = window_id_value->GetIfInt();
    if (!temp.has_value()) {
      return false;
    }
    out->window_id = temp.value();
  }

  const base::Value* selected_value = dict->FindKey("selected");
  if (!selected_value) {
    return false;
  }
  {
    auto temp = selected_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->selected = temp.value();
  }

  const base::Value* highlighted_value = dict->FindKey("highlighted");
  if (!highlighted_value) {
    return false;
  }
  {
    auto temp = highlighted_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->highlighted = temp.value();
  }

  const base::Value* active_value = dict->FindKey("active");
  if (!active_value) {
    return false;
  }
  {
    auto temp = active_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->active = temp.value();
  }

  const base::Value* pinned_value = dict->FindKey("pinned");
  if (!pinned_value) {
    return false;
  }
  {
    auto temp = pinned_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->pinned = temp.value();
  }

  const base::Value* url_value = dict->FindKey("url");
  if (!url_value) {
    return false;
  }
  {
    auto* temp = url_value->GetIfString();
    if (!temp) {
      return false;
    }
    out->url = *temp;
  }

  const base::Value* title_value = dict->FindKey("title");
  if (title_value) {
    {
      auto* temp = title_value->GetIfString();
      if (!temp) {
        out->title.reset();
        return false;
      }
      out->title = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* fav_icon_url_value = dict->FindKey("favIconUrl");
  if (fav_icon_url_value) {
    {
      auto* temp = fav_icon_url_value->GetIfString();
      if (!temp) {
        out->fav_icon_url.reset();
        return false;
      }
      out->fav_icon_url = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* status_value = dict->FindKey("status");
  if (status_value) {
    {
      auto* temp = status_value->GetIfString();
      if (!temp) {
        out->status.reset();
        return false;
      }
      out->status = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* incognito_value = dict->FindKey("incognito");
  if (!incognito_value) {
    return false;
  }
  {
    auto temp = incognito_value->GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out->incognito = temp.value();
  }

  return true;
}

// static
std::unique_ptr<Tab> Tab::FromValue(const base::Value& value) {
  auto out = std::make_unique<Tab>();
  bool result = Populate(value, out.get());
  if (!result)
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Tab::ToValue() const {
  auto to_value_result =
      std::make_unique<base::DictionaryValue>();

  to_value_result->SetWithoutPathExpansion("id", std::make_unique<base::Value>(this->id));

  to_value_result->SetWithoutPathExpansion("index", std::make_unique<base::Value>(this->index));

  to_value_result->SetWithoutPathExpansion("windowId", std::make_unique<base::Value>(this->window_id));

  to_value_result->SetWithoutPathExpansion("selected", std::make_unique<base::Value>(this->selected));

  to_value_result->SetWithoutPathExpansion("highlighted", std::make_unique<base::Value>(this->highlighted));

  to_value_result->SetWithoutPathExpansion("active", std::make_unique<base::Value>(this->active));

  to_value_result->SetWithoutPathExpansion("pinned", std::make_unique<base::Value>(this->pinned));

  to_value_result->SetWithoutPathExpansion("url", std::make_unique<base::Value>(this->url));

  if (this->title.get()) {
    to_value_result->SetWithoutPathExpansion("title", std::make_unique<base::Value>(*this->title));

  }
  if (this->fav_icon_url.get()) {
    to_value_result->SetWithoutPathExpansion("favIconUrl", std::make_unique<base::Value>(*this->fav_icon_url));

  }
  if (this->status.get()) {
    to_value_result->SetWithoutPathExpansion("status", std::make_unique<base::Value>(*this->status));

  }
  to_value_result->SetWithoutPathExpansion("incognito", std::make_unique<base::Value>(this->incognito));


  return to_value_result;
}



//
// Functions
//

namespace Update {

Params::UpdateProperties::UpdateProperties()
 {}

Params::UpdateProperties::~UpdateProperties() = default;
Params::UpdateProperties::UpdateProperties(UpdateProperties&& rhs) = default;
Params::UpdateProperties& Params::UpdateProperties::operator=(UpdateProperties&& rhs) = default;
// static
bool Params::UpdateProperties::Populate(
    const base::Value& value, UpdateProperties* out) {
  if (!value.is_dict()) {
    return false;
  }
  const auto* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* url_value = dict->FindKey("url");
  if (url_value) {
    {
      auto* temp = url_value->GetIfString();
      if (!temp) {
        out->url.reset();
        return false;
      }
      out->url = std::make_unique<std::string>(*temp);
    }
  }

  const base::Value* active_value = dict->FindKey("active");
  if (active_value) {
    {
      auto temp = active_value->GetIfBool();
      if (!temp.has_value()) {
        out->active.reset();
        return false;
      }
      out->active = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* highlighted_value = dict->FindKey("highlighted");
  if (highlighted_value) {
    {
      auto temp = highlighted_value->GetIfBool();
      if (!temp.has_value()) {
        out->highlighted.reset();
        return false;
      }
      out->highlighted = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* selected_value = dict->FindKey("selected");
  if (selected_value) {
    {
      auto temp = selected_value->GetIfBool();
      if (!temp.has_value()) {
        out->selected.reset();
        return false;
      }
      out->selected = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* pinned_value = dict->FindKey("pinned");
  if (pinned_value) {
    {
      auto temp = pinned_value->GetIfBool();
      if (!temp.has_value()) {
        out->pinned.reset();
        return false;
      }
      out->pinned = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* muted_value = dict->FindKey("muted");
  if (muted_value) {
    {
      auto temp = muted_value->GetIfBool();
      if (!temp.has_value()) {
        out->muted.reset();
        return false;
      }
      out->muted = std::make_unique<bool>(temp.value());
    }
  }

  const base::Value* opener_tab_id_value = dict->FindKey("openerTabId");
  if (opener_tab_id_value) {
    {
      auto temp = opener_tab_id_value->GetIfInt();
      if (!temp.has_value()) {
        out->opener_tab_id.reset();
        return false;
      }
      out->opener_tab_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* auto_discardable_value = dict->FindKey("autoDiscardable");
  if (auto_discardable_value) {
    {
      auto temp = auto_discardable_value->GetIfBool();
      if (!temp.has_value()) {
        out->auto_discardable.reset();
        return false;
      }
      out->auto_discardable = std::make_unique<bool>(temp.value());
    }
  }

  return true;
}


Params::Params() = default;
Params::~Params() = default;

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() < 1 || args.GetSize() > 2) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* tab_id_value = nullptr;
  if (args.Get(0, &tab_id_value) &&
      !tab_id_value->is_none()) {
    {
      auto temp = tab_id_value->GetIfInt();
      if (!temp.has_value()) {
        params->tab_id.reset();
        return std::unique_ptr<Params>();
      }
      params->tab_id = std::make_unique<int>(temp.value());
    }
  }

  const base::Value* update_properties_value = nullptr;
  if (args.Get(1, &update_properties_value) &&
      !update_properties_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = nullptr;
      if (!update_properties_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!UpdateProperties::Populate(*dictionary, &params->update_properties)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::vector<base::Value> Results::Create(const Tab& tab) {
  std::vector<base::Value> create_results;
  create_results.reserve(1);
  create_results.push_back(base::Value::FromUniquePtrValue((tab).ToValue()));

  return create_results;
}
}  // namespace Update

}  // namespace tabs
}  // namespace api
}  // namespace extensions

