// qtwebengine/userscript/userscript.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/userscript/userscript.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "qtwebengine/userscript/userscript.mojom-params-data.h"
#include "qtwebengine/userscript/userscript.mojom-shared-message-ids.h"

#include "qtwebengine/userscript/userscript.mojom-import-headers.h"


#ifndef QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_JUMBO_H_
#define QTWEBENGINE_USERSCRIPT_USERSCRIPT_MOJOM_JUMBO_H_
#endif
namespace qtwebengine {
namespace mojom {
UserScriptData::UserScriptData()
    : source(),
      url(),
      injectionPoint(0U),
      injectForSubframes(false),
      worldId(1U),
      scriptId(0ULL),
      globs(),
      excludeGlobs(),
      urlPatterns() {}

UserScriptData::UserScriptData(
    const std::string& source_in,
    const ::GURL& url_in,
    uint8_t injectionPoint_in,
    bool injectForSubframes_in,
    uint8_t worldId_in,
    uint64_t scriptId_in,
    std::vector<std::string> globs_in,
    std::vector<std::string> excludeGlobs_in,
    std::vector<std::string> urlPatterns_in)
    : source(std::move(source_in)),
      url(std::move(url_in)),
      injectionPoint(std::move(injectionPoint_in)),
      injectForSubframes(std::move(injectForSubframes_in)),
      worldId(std::move(worldId_in)),
      scriptId(std::move(scriptId_in)),
      globs(std::move(globs_in)),
      excludeGlobs(std::move(excludeGlobs_in)),
      urlPatterns(std::move(urlPatterns_in)) {}

UserScriptData::~UserScriptData() = default;

void UserScriptData::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "injectionPoint"), this->injectionPoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "injectForSubframes"), this->injectForSubframes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "worldId"), this->worldId,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scriptId"), this->scriptId,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "globs"), this->globs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "excludeGlobs"), this->excludeGlobs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "urlPatterns"), this->urlPatterns,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UserScriptData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char UserResourceControllerRenderFrame::Name_[] = "qtwebengine.mojom.UserResourceControllerRenderFrame";

UserResourceControllerRenderFrameProxy::UserResourceControllerRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UserResourceControllerRenderFrameProxy::AddScript(
    const QtWebEngineCore::UserScriptData& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "qtwebengine::mojom::UserResourceControllerRenderFrame::AddScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const QtWebEngineCore::UserScriptData&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUserResourceControllerRenderFrame_AddScript_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceControllerRenderFrame_AddScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::qtwebengine::mojom::UserScriptDataDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in UserResourceControllerRenderFrame.AddScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceControllerRenderFrame::Name_);
  message.set_method_name("AddScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void UserResourceControllerRenderFrameProxy::RemoveScript(
    const QtWebEngineCore::UserScriptData& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "qtwebengine::mojom::UserResourceControllerRenderFrame::RemoveScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const QtWebEngineCore::UserScriptData&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUserResourceControllerRenderFrame_RemoveScript_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceControllerRenderFrame_RemoveScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::qtwebengine::mojom::UserScriptDataDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in UserResourceControllerRenderFrame.RemoveScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceControllerRenderFrame::Name_);
  message.set_method_name("RemoveScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void UserResourceControllerRenderFrameProxy::ClearScripts(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "qtwebengine::mojom::UserResourceControllerRenderFrame::ClearScripts");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUserResourceControllerRenderFrame_ClearScripts_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceControllerRenderFrame_ClearScripts_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceControllerRenderFrame::Name_);
  message.set_method_name("ClearScripts");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool UserResourceControllerRenderFrameStubDispatch::Accept(
    UserResourceControllerRenderFrame* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kUserResourceControllerRenderFrame_AddScript_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebengine::mojom::UserResourceControllerRenderFrame::AddScript",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebengine::mojom::UserResourceControllerRenderFrame::AddScript");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UserResourceControllerRenderFrame_AddScript_Params_Data* params =
          reinterpret_cast<internal::UserResourceControllerRenderFrame_AddScript_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      QtWebEngineCore::UserScriptData p_data{};
      UserResourceControllerRenderFrame_AddScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceControllerRenderFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddScript(
std::move(p_data));
      return true;
    }
    case internal::kUserResourceControllerRenderFrame_RemoveScript_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebengine::mojom::UserResourceControllerRenderFrame::RemoveScript",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebengine::mojom::UserResourceControllerRenderFrame::RemoveScript");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UserResourceControllerRenderFrame_RemoveScript_Params_Data* params =
          reinterpret_cast<internal::UserResourceControllerRenderFrame_RemoveScript_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      QtWebEngineCore::UserScriptData p_data{};
      UserResourceControllerRenderFrame_RemoveScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceControllerRenderFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveScript(
std::move(p_data));
      return true;
    }
    case internal::kUserResourceControllerRenderFrame_ClearScripts_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebengine::mojom::UserResourceControllerRenderFrame::ClearScripts",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebengine::mojom::UserResourceControllerRenderFrame::ClearScripts");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UserResourceControllerRenderFrame_ClearScripts_Params_Data* params =
          reinterpret_cast<internal::UserResourceControllerRenderFrame_ClearScripts_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      UserResourceControllerRenderFrame_ClearScripts_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceControllerRenderFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearScripts();
      return true;
    }
  }
  return false;
}

// static
bool UserResourceControllerRenderFrameStubDispatch::AcceptWithResponder(
    UserResourceControllerRenderFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kUserResourceControllerRenderFrame_AddScript_Name: {
      break;
    }
    case internal::kUserResourceControllerRenderFrame_RemoveScript_Name: {
      break;
    }
    case internal::kUserResourceControllerRenderFrame_ClearScripts_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUserResourceControllerRenderFrameValidationInfo[] = {
    {internal::kUserResourceControllerRenderFrame_AddScript_Name,
     {&internal::UserResourceControllerRenderFrame_AddScript_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kUserResourceControllerRenderFrame_RemoveScript_Name,
     {&internal::UserResourceControllerRenderFrame_RemoveScript_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kUserResourceControllerRenderFrame_ClearScripts_Name,
     {&internal::UserResourceControllerRenderFrame_ClearScripts_Params_Data::Validate,
      nullptr /* no response */}},
};

bool UserResourceControllerRenderFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebengine::mojom::UserResourceControllerRenderFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUserResourceControllerRenderFrameValidationInfo);
}

const char UserResourceController::Name_[] = "qtwebengine.mojom.UserResourceController";

UserResourceControllerProxy::UserResourceControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UserResourceControllerProxy::AddScript(
    const QtWebEngineCore::UserScriptData& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "qtwebengine::mojom::UserResourceController::AddScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const QtWebEngineCore::UserScriptData&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUserResourceController_AddScript_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceController_AddScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::qtwebengine::mojom::UserScriptDataDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in UserResourceController.AddScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceController::Name_);
  message.set_method_name("AddScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void UserResourceControllerProxy::RemoveScript(
    const QtWebEngineCore::UserScriptData& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "qtwebengine::mojom::UserResourceController::RemoveScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const QtWebEngineCore::UserScriptData&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUserResourceController_RemoveScript_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceController_RemoveScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::qtwebengine::mojom::UserScriptDataDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in UserResourceController.RemoveScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceController::Name_);
  message.set_method_name("RemoveScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void UserResourceControllerProxy::ClearScripts(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "qtwebengine::mojom::UserResourceController::ClearScripts");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUserResourceController_ClearScripts_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceController_ClearScripts_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceController::Name_);
  message.set_method_name("ClearScripts");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool UserResourceControllerStubDispatch::Accept(
    UserResourceController* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kUserResourceController_AddScript_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebengine::mojom::UserResourceController::AddScript",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebengine::mojom::UserResourceController::AddScript");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UserResourceController_AddScript_Params_Data* params =
          reinterpret_cast<internal::UserResourceController_AddScript_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      QtWebEngineCore::UserScriptData p_data{};
      UserResourceController_AddScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddScript(
std::move(p_data));
      return true;
    }
    case internal::kUserResourceController_RemoveScript_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebengine::mojom::UserResourceController::RemoveScript",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebengine::mojom::UserResourceController::RemoveScript");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UserResourceController_RemoveScript_Params_Data* params =
          reinterpret_cast<internal::UserResourceController_RemoveScript_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      QtWebEngineCore::UserScriptData p_data{};
      UserResourceController_RemoveScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceController::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveScript(
std::move(p_data));
      return true;
    }
    case internal::kUserResourceController_ClearScripts_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)qtwebengine::mojom::UserResourceController::ClearScripts",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)qtwebengine::mojom::UserResourceController::ClearScripts");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UserResourceController_ClearScripts_Params_Data* params =
          reinterpret_cast<internal::UserResourceController_ClearScripts_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      UserResourceController_ClearScripts_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceController::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearScripts();
      return true;
    }
  }
  return false;
}

// static
bool UserResourceControllerStubDispatch::AcceptWithResponder(
    UserResourceController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kUserResourceController_AddScript_Name: {
      break;
    }
    case internal::kUserResourceController_RemoveScript_Name: {
      break;
    }
    case internal::kUserResourceController_ClearScripts_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUserResourceControllerValidationInfo[] = {
    {internal::kUserResourceController_AddScript_Name,
     {&internal::UserResourceController_AddScript_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kUserResourceController_RemoveScript_Name,
     {&internal::UserResourceController_RemoveScript_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kUserResourceController_ClearScripts_Name,
     {&internal::UserResourceController_ClearScripts_Params_Data::Validate,
      nullptr /* no response */}},
};

bool UserResourceControllerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebengine::mojom::UserResourceController::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUserResourceControllerValidationInfo);
}

}  // namespace mojom
}  // namespace qtwebengine

namespace mojo {


// static
bool StructTraits<::qtwebengine::mojom::UserScriptData::DataView, ::qtwebengine::mojom::UserScriptDataPtr>::Read(
    ::qtwebengine::mojom::UserScriptData::DataView input,
    ::qtwebengine::mojom::UserScriptDataPtr* output) {
  bool success = true;
  ::qtwebengine::mojom::UserScriptDataPtr result(::qtwebengine::mojom::UserScriptData::New());
  
      if (success && !input.ReadSource(&result->source))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->injectionPoint = input.injectionPoint();
      if (success)
        result->injectForSubframes = input.injectForSubframes();
      if (success)
        result->worldId = input.worldId();
      if (success)
        result->scriptId = input.scriptId();
      if (success && !input.ReadGlobs(&result->globs))
        success = false;
      if (success && !input.ReadExcludeGlobs(&result->excludeGlobs))
        success = false;
      if (success && !input.ReadUrlPatterns(&result->urlPatterns))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif