// services/audio/public/mojom/audio_device_description.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/audio/public/mojom/audio_device_description.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/audio/public/mojom/audio_device_description.mojom-params-data.h"
#include "services/audio/public/mojom/audio_device_description.mojom-shared-message-ids.h"

#include "services/audio/public/mojom/audio_device_description.mojom-import-headers.h"


#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_AUDIO_DEVICE_DESCRIPTION_MOJOM_JUMBO_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_AUDIO_DEVICE_DESCRIPTION_MOJOM_JUMBO_H_
#endif
namespace audio {
namespace mojom {
AudioDeviceDescription::AudioDeviceDescription()
    : device_name(),
      unique_id(),
      group_id() {}

AudioDeviceDescription::AudioDeviceDescription(
    const std::string& device_name_in,
    const std::string& unique_id_in,
    const std::string& group_id_in)
    : device_name(std::move(device_name_in)),
      unique_id(std::move(unique_id_in)),
      group_id(std::move(group_id_in)) {}

AudioDeviceDescription::~AudioDeviceDescription() = default;

void AudioDeviceDescription::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_name"), this->device_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unique_id"), this->unique_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioDeviceDescription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace audio

namespace mojo {


// static
bool StructTraits<::audio::mojom::AudioDeviceDescription::DataView, ::audio::mojom::AudioDeviceDescriptionPtr>::Read(
    ::audio::mojom::AudioDeviceDescription::DataView input,
    ::audio::mojom::AudioDeviceDescriptionPtr* output) {
  bool success = true;
  ::audio::mojom::AudioDeviceDescriptionPtr result(::audio::mojom::AudioDeviceDescription::New());
  
      if (success && !input.ReadDeviceName(&result->device_name))
        success = false;
      if (success && !input.ReadUniqueId(&result->unique_id))
        success = false;
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif