// services/audio/public/mojom/debug_recording.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/audio/public/mojom/debug_recording.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/audio/public/mojom/debug_recording.mojom-params-data.h"
#include "services/audio/public/mojom/debug_recording.mojom-shared-message-ids.h"

#include "services/audio/public/mojom/debug_recording.mojom-import-headers.h"


#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_DEBUG_RECORDING_MOJOM_JUMBO_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_DEBUG_RECORDING_MOJOM_JUMBO_H_
#endif
namespace audio {
namespace mojom {
const char DebugRecordingFileProvider::Name_[] = "audio.mojom.DebugRecordingFileProvider";

class DebugRecordingFileProvider_CreateWavFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DebugRecordingFileProvider_CreateWavFile_ForwardToCallback(
      DebugRecordingFileProvider::CreateWavFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  DebugRecordingFileProvider::CreateWavFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(DebugRecordingFileProvider_CreateWavFile_ForwardToCallback);
};

DebugRecordingFileProviderProxy::DebugRecordingFileProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DebugRecordingFileProviderProxy::CreateWavFile(
    ::media::AudioDebugRecordingStreamType in_stream_type, uint32_t in_id, CreateWavFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "audio::mojom::DebugRecordingFileProvider::CreateWavFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_type"), in_stream_type,
                        "<value of type ::media::AudioDebugRecordingStreamType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDebugRecordingFileProvider_CreateWavFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::DebugRecordingFileProvider_CreateWavFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::audio::mojom::DebugRecordingStreamType>(
      in_stream_type, &params->stream_type);
  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DebugRecordingFileProvider::Name_);
  message.set_method_name("CreateWavFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DebugRecordingFileProvider_CreateWavFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class DebugRecordingFileProvider_CreateWavFile_ProxyToResponder {
 public:
  static DebugRecordingFileProvider::CreateWavFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<DebugRecordingFileProvider_CreateWavFile_ProxyToResponder> proxy(
        new DebugRecordingFileProvider_CreateWavFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&DebugRecordingFileProvider_CreateWavFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DebugRecordingFileProvider_CreateWavFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  DebugRecordingFileProvider_CreateWavFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DebugRecordingFileProvider::CreateWavFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_file);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(DebugRecordingFileProvider_CreateWavFile_ProxyToResponder);
};

bool DebugRecordingFileProvider_CreateWavFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "audio::mojom::DebugRecordingFileProvider::CreateWavFileCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::DebugRecordingFileProvider_CreateWavFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DebugRecordingFileProvider_CreateWavFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::base::File p_file{};
  DebugRecordingFileProvider_CreateWavFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DebugRecordingFileProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_file));
  return true;
}

void DebugRecordingFileProvider_CreateWavFile_ProxyToResponder::Run(
    ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)audio::mojom::DebugRecordingFileProvider::CreateWavFileCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDebugRecordingFileProvider_CreateWavFile_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::DebugRecordingFileProvider_CreateWavFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)audio::mojom::DebugRecordingFileProvider::CreateWavFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DebugRecordingFileProvider::Name_);
  message.set_method_name("CreateWavFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DebugRecordingFileProviderStubDispatch::Accept(
    DebugRecordingFileProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDebugRecordingFileProvider_CreateWavFile_Name: {
      break;
    }
  }
  return false;
}

// static
bool DebugRecordingFileProviderStubDispatch::AcceptWithResponder(
    DebugRecordingFileProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDebugRecordingFileProvider_CreateWavFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)audio::mojom::DebugRecordingFileProvider::CreateWavFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)audio::mojom::DebugRecordingFileProvider::CreateWavFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::DebugRecordingFileProvider_CreateWavFile_Params_Data* params =
          reinterpret_cast<
              internal::DebugRecordingFileProvider_CreateWavFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::media::AudioDebugRecordingStreamType p_stream_type{};
      uint32_t p_id{};
      DebugRecordingFileProvider_CreateWavFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStreamType(&p_stream_type))
        success = false;
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DebugRecordingFileProvider::Name_, 0, false);
        return false;
      }
      DebugRecordingFileProvider::CreateWavFileCallback callback =
          DebugRecordingFileProvider_CreateWavFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWavFile(
std::move(p_stream_type), 
std::move(p_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDebugRecordingFileProviderValidationInfo[] = {
    {internal::kDebugRecordingFileProvider_CreateWavFile_Name,
     {&internal::DebugRecordingFileProvider_CreateWavFile_Params_Data::Validate,
      &internal::DebugRecordingFileProvider_CreateWavFile_ResponseParams_Data::Validate}},
};

bool DebugRecordingFileProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::audio::mojom::DebugRecordingFileProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDebugRecordingFileProviderValidationInfo);
}

bool DebugRecordingFileProviderResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::audio::mojom::DebugRecordingFileProvider::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDebugRecordingFileProviderValidationInfo);

}
const char DebugRecording::Name_[] = "audio.mojom.DebugRecording";

DebugRecordingProxy::DebugRecordingProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DebugRecordingProxy::Enable(
    ::mojo::PendingRemote<DebugRecordingFileProvider> in_file_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "audio::mojom::DebugRecording::Enable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_provider"), in_file_provider,
                        "<value of type ::mojo::PendingRemote<DebugRecordingFileProvider>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDebugRecording_Enable_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::DebugRecording_Enable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::audio::mojom::DebugRecordingFileProviderInterfaceBase>>(
      in_file_provider, &params->file_provider, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->file_provider),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid file_provider in DebugRecording.Enable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DebugRecording::Name_);
  message.set_method_name("Enable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DebugRecordingStubDispatch::Accept(
    DebugRecording* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDebugRecording_Enable_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)audio::mojom::DebugRecording::Enable",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)audio::mojom::DebugRecording::Enable");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DebugRecording_Enable_Params_Data* params =
          reinterpret_cast<internal::DebugRecording_Enable_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<DebugRecordingFileProvider> p_file_provider{};
      DebugRecording_Enable_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_file_provider =
            input_data_view.TakeFileProvider<decltype(p_file_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DebugRecording::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Enable(
std::move(p_file_provider));
      return true;
    }
  }
  return false;
}

// static
bool DebugRecordingStubDispatch::AcceptWithResponder(
    DebugRecording* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDebugRecording_Enable_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDebugRecordingValidationInfo[] = {
    {internal::kDebugRecording_Enable_Name,
     {&internal::DebugRecording_Enable_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DebugRecordingRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::audio::mojom::DebugRecording::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDebugRecordingValidationInfo);
}

}  // namespace mojom
}  // namespace audio

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif