// services/data_decoder/public/mojom/image_decoder.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/data_decoder/public/mojom/image_decoder.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/data_decoder/public/mojom/image_decoder.mojom-params-data.h"
namespace data_decoder {
namespace mojom {

static NOINLINE const char* ImageCodecToStringHelper(ImageCodec value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ImageCodec::kDefault:
      return "kDefault";
    case ImageCodec::kPng:
      return "kPng";
    default:
      return nullptr;
  }
}

std::string ImageCodecToString(ImageCodec value) {
  const char *str = ImageCodecToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ImageCodec value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ImageCodec value) {
  return os << ImageCodecToString(value);
}

namespace internal {


// static
bool AnimationFrame_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const AnimationFrame_Data* object = static_cast<const AnimationFrame_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bitmap, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bitmap, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  return true;
}

AnimationFrame_Data::AnimationFrame_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageDecoder_DecodeImage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ImageDecoder_DecodeImage_Params_Data* object = static_cast<const ImageDecoder_DecodeImage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->encoded_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->encoded_data, validation_context))
    return false;


  if (!::data_decoder::mojom::internal::ImageCodec_Data
        ::Validate(object->codec, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->desired_image_frame_size, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->desired_image_frame_size, validation_context))
    return false;

  return true;
}

ImageDecoder_DecodeImage_Params_Data::ImageDecoder_DecodeImage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageDecoder_DecodeImage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ImageDecoder_DecodeImage_ResponseParams_Data* object = static_cast<const ImageDecoder_DecodeImage_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->decoded_image, validation_context))
    return false;

  return true;
}

ImageDecoder_DecodeImage_ResponseParams_Data::ImageDecoder_DecodeImage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageDecoder_DecodeAnimation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ImageDecoder_DecodeAnimation_Params_Data* object = static_cast<const ImageDecoder_DecodeAnimation_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->encoded_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->encoded_data, validation_context))
    return false;

  return true;
}

ImageDecoder_DecodeAnimation_Params_Data::ImageDecoder_DecodeAnimation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageDecoder_DecodeAnimation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ImageDecoder_DecodeAnimation_ResponseParams_Data* object = static_cast<const ImageDecoder_DecodeAnimation_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->decoded_image, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams decoded_image_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->decoded_image, validation_context,
                                         &decoded_image_validate_params)) {
    return false;
  }

  return true;
}

ImageDecoder_DecodeAnimation_ResponseParams_Data::ImageDecoder_DecodeAnimation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace data_decoder

namespace perfetto {

// static
void TraceFormatTraits<::data_decoder::mojom::ImageCodec>::WriteIntoTrace(
   perfetto::TracedValue context, ::data_decoder::mojom::ImageCodec value) {
  return std::move(context).WriteString(::data_decoder::mojom::ImageCodecToString(value));
}

} // namespace perfetto
