// services/device/public/mojom/battery_monitor.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/battery_monitor.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/battery_monitor.mojom-params-data.h"
#include "services/device/public/mojom/battery_monitor.mojom-shared-message-ids.h"

#include "services/device/public/mojom/battery_monitor.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_BATTERY_MONITOR_MOJOM_BLINK_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_BATTERY_MONITOR_MOJOM_BLINK_JUMBO_H_
#endif
namespace device {
namespace mojom {
namespace blink {
const char BatteryMonitor::Name_[] = "device.mojom.BatteryMonitor";

class BatteryMonitor_QueryNextStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BatteryMonitor_QueryNextStatus_ForwardToCallback(
      BatteryMonitor::QueryNextStatusCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  BatteryMonitor::QueryNextStatusCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(BatteryMonitor_QueryNextStatus_ForwardToCallback);
};

BatteryMonitorProxy::BatteryMonitorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BatteryMonitorProxy::QueryNextStatus(
    QueryNextStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::BatteryMonitor::QueryNextStatus");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBatteryMonitor_QueryNextStatus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::BatteryMonitor_QueryNextStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BatteryMonitor::Name_);
  message.set_method_name("QueryNextStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BatteryMonitor_QueryNextStatus_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class BatteryMonitor_QueryNextStatus_ProxyToResponder {
 public:
  static BatteryMonitor::QueryNextStatusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<BatteryMonitor_QueryNextStatus_ProxyToResponder> proxy(
        new BatteryMonitor_QueryNextStatus_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&BatteryMonitor_QueryNextStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BatteryMonitor_QueryNextStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  BatteryMonitor_QueryNextStatus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BatteryMonitor::QueryNextStatusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::blink::BatteryStatusPtr in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(BatteryMonitor_QueryNextStatus_ProxyToResponder);
};

bool BatteryMonitor_QueryNextStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::BatteryMonitor::QueryNextStatusCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::BatteryMonitor_QueryNextStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BatteryMonitor_QueryNextStatus_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::device::mojom::blink::BatteryStatusPtr p_status{};
  BatteryMonitor_QueryNextStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BatteryMonitor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void BatteryMonitor_QueryNextStatus_ProxyToResponder::Run(
    ::device::mojom::blink::BatteryStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::BatteryMonitor::QueryNextStatusCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::device::mojom::blink::BatteryStatusPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBatteryMonitor_QueryNextStatus_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::BatteryMonitor_QueryNextStatus_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::BatteryStatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::BatteryMonitor::QueryNextStatusCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BatteryMonitor::Name_);
  message.set_method_name("QueryNextStatus");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BatteryMonitorStubDispatch::Accept(
    BatteryMonitor* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBatteryMonitor_QueryNextStatus_Name: {
      break;
    }
  }
  return false;
}

// static
bool BatteryMonitorStubDispatch::AcceptWithResponder(
    BatteryMonitor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBatteryMonitor_QueryNextStatus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::BatteryMonitor::QueryNextStatus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::BatteryMonitor::QueryNextStatus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::BatteryMonitor_QueryNextStatus_Params_Data* params =
          reinterpret_cast<
              internal::BatteryMonitor_QueryNextStatus_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      BatteryMonitor_QueryNextStatus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BatteryMonitor::Name_, 0, false);
        return false;
      }
      BatteryMonitor::QueryNextStatusCallback callback =
          BatteryMonitor_QueryNextStatus_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryNextStatus(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBatteryMonitorValidationInfo[] = {
    {internal::kBatteryMonitor_QueryNextStatus_Name,
     {&internal::BatteryMonitor_QueryNextStatus_Params_Data::Validate,
      &internal::BatteryMonitor_QueryNextStatus_ResponseParams_Data::Validate}},
};

bool BatteryMonitorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::BatteryMonitor::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBatteryMonitorValidationInfo);
}

bool BatteryMonitorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::BatteryMonitor::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kBatteryMonitorValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif