// services/device/public/mojom/device_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/device_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/device_service.mojom-params-data.h"
#include "services/device/public/mojom/device_service.mojom-shared-message-ids.h"

#include "services/device/public/mojom/device_service.mojom-import-headers.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_DEVICE_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_DEVICE_SERVICE_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
const char DeviceService::Name_[] = "device.mojom.DeviceService";

DeviceServiceProxy::DeviceServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceServiceProxy::BindFingerprint(
    ::mojo::PendingReceiver<::device::mojom::Fingerprint> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindFingerprint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::Fingerprint>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindFingerprint_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindFingerprint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::FingerprintInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindFingerprint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindFingerprint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindGeolocationConfig(
    ::mojo::PendingReceiver<::device::mojom::GeolocationConfig> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindGeolocationConfig", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::GeolocationConfig>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindGeolocationConfig_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindGeolocationConfig_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::GeolocationConfigInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindGeolocationConfig request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindGeolocationConfig");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindGeolocationContext(
    ::mojo::PendingReceiver<::device::mojom::GeolocationContext> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindGeolocationContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::GeolocationContext>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindGeolocationContext_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindGeolocationContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::GeolocationContextInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindGeolocationContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindGeolocationContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindGeolocationControl(
    ::mojo::PendingReceiver<::device::mojom::GeolocationControl> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindGeolocationControl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::GeolocationControl>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindGeolocationControl_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindGeolocationControl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::GeolocationControlInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindGeolocationControl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindGeolocationControl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindInputDeviceManager(
    ::mojo::PendingReceiver<::device::mojom::InputDeviceManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindInputDeviceManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::InputDeviceManager>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindInputDeviceManager_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindInputDeviceManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::InputDeviceManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindInputDeviceManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindInputDeviceManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindBatteryMonitor(
    ::mojo::PendingReceiver<::device::mojom::BatteryMonitor> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindBatteryMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::BatteryMonitor>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindBatteryMonitor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindBatteryMonitor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::BatteryMonitorInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindBatteryMonitor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindBatteryMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindVibrationManager(
    ::mojo::PendingReceiver<::device::mojom::VibrationManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindVibrationManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::VibrationManager>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindVibrationManager_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindVibrationManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::VibrationManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindVibrationManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindVibrationManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindHidManager(
    ::mojo::PendingReceiver<::device::mojom::HidManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindHidManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::HidManager>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindHidManager_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindHidManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::HidManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindHidManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindHidManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindPowerMonitor(
    ::mojo::PendingReceiver<::device::mojom::PowerMonitor> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindPowerMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::PowerMonitor>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindPowerMonitor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindPowerMonitor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::PowerMonitorInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindPowerMonitor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindPowerMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindPublicIpAddressGeolocationProvider(
    ::mojo::PendingReceiver<::device::mojom::PublicIpAddressGeolocationProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindPublicIpAddressGeolocationProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::PublicIpAddressGeolocationProvider>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindPublicIpAddressGeolocationProvider_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindPublicIpAddressGeolocationProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::PublicIpAddressGeolocationProviderInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindPublicIpAddressGeolocationProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindPublicIpAddressGeolocationProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindScreenOrientationListener(
    ::mojo::PendingReceiver<::device::mojom::ScreenOrientationListener> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindScreenOrientationListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::ScreenOrientationListener>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindScreenOrientationListener_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindScreenOrientationListener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::ScreenOrientationListenerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindScreenOrientationListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindScreenOrientationListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindSensorProvider(
    ::mojo::PendingReceiver<::device::mojom::SensorProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindSensorProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::SensorProvider>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindSensorProvider_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindSensorProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::SensorProviderInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindSensorProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindSensorProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindSerialPortManager(
    ::mojo::PendingReceiver<::device::mojom::SerialPortManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindSerialPortManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::SerialPortManager>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindSerialPortManager_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindSerialPortManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::SerialPortManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindSerialPortManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindSerialPortManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindTimeZoneMonitor(
    ::mojo::PendingReceiver<::device::mojom::TimeZoneMonitor> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindTimeZoneMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::TimeZoneMonitor>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindTimeZoneMonitor_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindTimeZoneMonitor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::TimeZoneMonitorInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindTimeZoneMonitor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindTimeZoneMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindWakeLockProvider(
    ::mojo::PendingReceiver<::device::mojom::WakeLockProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindWakeLockProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::WakeLockProvider>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindWakeLockProvider_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindWakeLockProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::WakeLockProviderInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindWakeLockProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindWakeLockProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindUsbDeviceManager(
    ::mojo::PendingReceiver<::device::mojom::UsbDeviceManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindUsbDeviceManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::UsbDeviceManager>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindUsbDeviceManager_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindUsbDeviceManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::UsbDeviceManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindUsbDeviceManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindUsbDeviceManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void DeviceServiceProxy::BindUsbDeviceManagerTest(
    ::mojo::PendingReceiver<::device::mojom::UsbDeviceManagerTest> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::DeviceService::BindUsbDeviceManagerTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::UsbDeviceManagerTest>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kDeviceService_BindUsbDeviceManagerTest_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindUsbDeviceManagerTest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::UsbDeviceManagerTestInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindUsbDeviceManagerTest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindUsbDeviceManagerTest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool DeviceServiceStubDispatch::Accept(
    DeviceService* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kDeviceService_BindFingerprint_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindFingerprint",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindFingerprint");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindFingerprint_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindFingerprint_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::Fingerprint> p_receiver{};
      DeviceService_BindFingerprint_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindFingerprint(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindGeolocationConfig_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindGeolocationConfig",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindGeolocationConfig");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindGeolocationConfig_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindGeolocationConfig_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::GeolocationConfig> p_receiver{};
      DeviceService_BindGeolocationConfig_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindGeolocationConfig(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindGeolocationContext_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindGeolocationContext",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindGeolocationContext");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindGeolocationContext_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindGeolocationContext_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::GeolocationContext> p_receiver{};
      DeviceService_BindGeolocationContext_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindGeolocationContext(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindGeolocationControl_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindGeolocationControl",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindGeolocationControl");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindGeolocationControl_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindGeolocationControl_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::GeolocationControl> p_receiver{};
      DeviceService_BindGeolocationControl_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindGeolocationControl(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindInputDeviceManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindInputDeviceManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindInputDeviceManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindInputDeviceManager_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindInputDeviceManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::InputDeviceManager> p_receiver{};
      DeviceService_BindInputDeviceManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindInputDeviceManager(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindBatteryMonitor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindBatteryMonitor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindBatteryMonitor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindBatteryMonitor_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindBatteryMonitor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::BatteryMonitor> p_receiver{};
      DeviceService_BindBatteryMonitor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindBatteryMonitor(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindVibrationManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindVibrationManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindVibrationManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindVibrationManager_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindVibrationManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::VibrationManager> p_receiver{};
      DeviceService_BindVibrationManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindVibrationManager(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindHidManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindHidManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindHidManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindHidManager_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindHidManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::HidManager> p_receiver{};
      DeviceService_BindHidManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindHidManager(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindPowerMonitor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindPowerMonitor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindPowerMonitor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindPowerMonitor_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindPowerMonitor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::PowerMonitor> p_receiver{};
      DeviceService_BindPowerMonitor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindPowerMonitor(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindPublicIpAddressGeolocationProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindPublicIpAddressGeolocationProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindPublicIpAddressGeolocationProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindPublicIpAddressGeolocationProvider_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindPublicIpAddressGeolocationProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::PublicIpAddressGeolocationProvider> p_receiver{};
      DeviceService_BindPublicIpAddressGeolocationProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindPublicIpAddressGeolocationProvider(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindScreenOrientationListener_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindScreenOrientationListener",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindScreenOrientationListener");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindScreenOrientationListener_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindScreenOrientationListener_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::ScreenOrientationListener> p_receiver{};
      DeviceService_BindScreenOrientationListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindScreenOrientationListener(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindSensorProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindSensorProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindSensorProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindSensorProvider_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindSensorProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::SensorProvider> p_receiver{};
      DeviceService_BindSensorProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSensorProvider(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindSerialPortManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindSerialPortManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindSerialPortManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindSerialPortManager_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindSerialPortManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::SerialPortManager> p_receiver{};
      DeviceService_BindSerialPortManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSerialPortManager(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindTimeZoneMonitor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindTimeZoneMonitor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindTimeZoneMonitor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindTimeZoneMonitor_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindTimeZoneMonitor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::TimeZoneMonitor> p_receiver{};
      DeviceService_BindTimeZoneMonitor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTimeZoneMonitor(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindWakeLockProvider_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindWakeLockProvider",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindWakeLockProvider");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindWakeLockProvider_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindWakeLockProvider_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::WakeLockProvider> p_receiver{};
      DeviceService_BindWakeLockProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWakeLockProvider(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindUsbDeviceManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindUsbDeviceManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindUsbDeviceManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindUsbDeviceManager_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindUsbDeviceManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::UsbDeviceManager> p_receiver{};
      DeviceService_BindUsbDeviceManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindUsbDeviceManager(
std::move(p_receiver));
      return true;
    }
    case internal::kDeviceService_BindUsbDeviceManagerTest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::DeviceService::BindUsbDeviceManagerTest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::DeviceService::BindUsbDeviceManagerTest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::DeviceService_BindUsbDeviceManagerTest_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindUsbDeviceManagerTest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::UsbDeviceManagerTest> p_receiver{};
      DeviceService_BindUsbDeviceManagerTest_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindUsbDeviceManagerTest(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool DeviceServiceStubDispatch::AcceptWithResponder(
    DeviceService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kDeviceService_BindFingerprint_Name: {
      break;
    }
    case internal::kDeviceService_BindGeolocationConfig_Name: {
      break;
    }
    case internal::kDeviceService_BindGeolocationContext_Name: {
      break;
    }
    case internal::kDeviceService_BindGeolocationControl_Name: {
      break;
    }
    case internal::kDeviceService_BindInputDeviceManager_Name: {
      break;
    }
    case internal::kDeviceService_BindBatteryMonitor_Name: {
      break;
    }
    case internal::kDeviceService_BindVibrationManager_Name: {
      break;
    }
    case internal::kDeviceService_BindHidManager_Name: {
      break;
    }
    case internal::kDeviceService_BindPowerMonitor_Name: {
      break;
    }
    case internal::kDeviceService_BindPublicIpAddressGeolocationProvider_Name: {
      break;
    }
    case internal::kDeviceService_BindScreenOrientationListener_Name: {
      break;
    }
    case internal::kDeviceService_BindSensorProvider_Name: {
      break;
    }
    case internal::kDeviceService_BindSerialPortManager_Name: {
      break;
    }
    case internal::kDeviceService_BindTimeZoneMonitor_Name: {
      break;
    }
    case internal::kDeviceService_BindWakeLockProvider_Name: {
      break;
    }
    case internal::kDeviceService_BindUsbDeviceManager_Name: {
      break;
    }
    case internal::kDeviceService_BindUsbDeviceManagerTest_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDeviceServiceValidationInfo[] = {
    {internal::kDeviceService_BindFingerprint_Name,
     {&internal::DeviceService_BindFingerprint_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindGeolocationConfig_Name,
     {&internal::DeviceService_BindGeolocationConfig_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindGeolocationContext_Name,
     {&internal::DeviceService_BindGeolocationContext_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindGeolocationControl_Name,
     {&internal::DeviceService_BindGeolocationControl_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindInputDeviceManager_Name,
     {&internal::DeviceService_BindInputDeviceManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindBatteryMonitor_Name,
     {&internal::DeviceService_BindBatteryMonitor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindVibrationManager_Name,
     {&internal::DeviceService_BindVibrationManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindHidManager_Name,
     {&internal::DeviceService_BindHidManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindPowerMonitor_Name,
     {&internal::DeviceService_BindPowerMonitor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindPublicIpAddressGeolocationProvider_Name,
     {&internal::DeviceService_BindPublicIpAddressGeolocationProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindScreenOrientationListener_Name,
     {&internal::DeviceService_BindScreenOrientationListener_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindSensorProvider_Name,
     {&internal::DeviceService_BindSensorProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindSerialPortManager_Name,
     {&internal::DeviceService_BindSerialPortManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindTimeZoneMonitor_Name,
     {&internal::DeviceService_BindTimeZoneMonitor_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindWakeLockProvider_Name,
     {&internal::DeviceService_BindWakeLockProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindUsbDeviceManager_Name,
     {&internal::DeviceService_BindUsbDeviceManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kDeviceService_BindUsbDeviceManagerTest_Name,
     {&internal::DeviceService_BindUsbDeviceManagerTest_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DeviceServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::DeviceService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDeviceServiceValidationInfo);
}

}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif