// services/device/public/mojom/input_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/input_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/input_service.mojom-params-data.h"
namespace device {
namespace mojom {

static NOINLINE const char* InputDeviceSubsystemToStringHelper(InputDeviceSubsystem value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InputDeviceSubsystem::SUBSYSTEM_HID:
      return "SUBSYSTEM_HID";
    case InputDeviceSubsystem::SUBSYSTEM_INPUT:
      return "SUBSYSTEM_INPUT";
    case InputDeviceSubsystem::SUBSYSTEM_UNKNOWN:
      return "SUBSYSTEM_UNKNOWN";
    default:
      return nullptr;
  }
}

std::string InputDeviceSubsystemToString(InputDeviceSubsystem value) {
  const char *str = InputDeviceSubsystemToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InputDeviceSubsystem value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InputDeviceSubsystem value) {
  return os << InputDeviceSubsystemToString(value);
}

static NOINLINE const char* InputDeviceTypeToStringHelper(InputDeviceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InputDeviceType::TYPE_BLUETOOTH:
      return "TYPE_BLUETOOTH";
    case InputDeviceType::TYPE_USB:
      return "TYPE_USB";
    case InputDeviceType::TYPE_SERIO:
      return "TYPE_SERIO";
    case InputDeviceType::TYPE_UNKNOWN:
      return "TYPE_UNKNOWN";
    default:
      return nullptr;
  }
}

std::string InputDeviceTypeToString(InputDeviceType value) {
  const char *str = InputDeviceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InputDeviceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InputDeviceType value) {
  return os << InputDeviceTypeToString(value);
}

namespace internal {


// static
bool InputDeviceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputDeviceInfo_Data* object = static_cast<const InputDeviceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }


  if (!::device::mojom::internal::InputDeviceSubsystem_Data
        ::Validate(object->subsystem, validation_context))
    return false;


  if (!::device::mojom::internal::InputDeviceType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

InputDeviceInfo_Data::InputDeviceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputDeviceManagerClient_InputDeviceAdded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputDeviceManagerClient_InputDeviceAdded_Params_Data* object = static_cast<const InputDeviceManagerClient_InputDeviceAdded_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_info, validation_context))
    return false;

  return true;
}

InputDeviceManagerClient_InputDeviceAdded_Params_Data::InputDeviceManagerClient_InputDeviceAdded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputDeviceManagerClient_InputDeviceRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputDeviceManagerClient_InputDeviceRemoved_Params_Data* object = static_cast<const InputDeviceManagerClient_InputDeviceRemoved_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

InputDeviceManagerClient_InputDeviceRemoved_Params_Data::InputDeviceManagerClient_InputDeviceRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputDeviceManager_GetDevicesAndSetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputDeviceManager_GetDevicesAndSetClient_Params_Data* object = static_cast<const InputDeviceManager_GetDevicesAndSetClient_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

InputDeviceManager_GetDevicesAndSetClient_Params_Data::InputDeviceManager_GetDevicesAndSetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputDeviceManager_GetDevicesAndSetClient_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputDeviceManager_GetDevicesAndSetClient_ResponseParams_Data* object = static_cast<const InputDeviceManager_GetDevicesAndSetClient_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devices, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devices_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devices, validation_context,
                                         &devices_validate_params)) {
    return false;
  }

  return true;
}

InputDeviceManager_GetDevicesAndSetClient_ResponseParams_Data::InputDeviceManager_GetDevicesAndSetClient_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputDeviceManager_GetDevices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputDeviceManager_GetDevices_Params_Data* object = static_cast<const InputDeviceManager_GetDevices_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

InputDeviceManager_GetDevices_Params_Data::InputDeviceManager_GetDevices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InputDeviceManager_GetDevices_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InputDeviceManager_GetDevices_ResponseParams_Data* object = static_cast<const InputDeviceManager_GetDevices_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devices, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams devices_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devices, validation_context,
                                         &devices_validate_params)) {
    return false;
  }

  return true;
}

InputDeviceManager_GetDevices_ResponseParams_Data::InputDeviceManager_GetDevices_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::InputDeviceSubsystem>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::InputDeviceSubsystem value) {
  return std::move(context).WriteString(::device::mojom::InputDeviceSubsystemToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::InputDeviceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::InputDeviceType value) {
  return std::move(context).WriteString(::device::mojom::InputDeviceTypeToString(value));
}

} // namespace perfetto
