// services/device/public/mojom/screen_orientation.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/screen_orientation.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/screen_orientation.mojom-params-data.h"
#include "services/device/public/mojom/screen_orientation.mojom-shared-message-ids.h"

#include "services/device/public/mojom/screen_orientation.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SCREEN_ORIENTATION_MOJOM_BLINK_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SCREEN_ORIENTATION_MOJOM_BLINK_JUMBO_H_
#endif
namespace device {
namespace mojom {
namespace blink {
const char ScreenOrientation::Name_[] = "device.mojom.ScreenOrientation";

class ScreenOrientation_LockOrientation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ScreenOrientation_LockOrientation_ForwardToCallback(
      ScreenOrientation::LockOrientationCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ScreenOrientation::LockOrientationCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ScreenOrientation_LockOrientation_ForwardToCallback);
};

ScreenOrientationProxy::ScreenOrientationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ScreenOrientationProxy::LockOrientation(
    ::device::mojom::blink::ScreenOrientationLockType in_orientation, LockOrientationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::ScreenOrientation::LockOrientation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("orientation"), in_orientation,
                        "<value of type ::device::mojom::blink::ScreenOrientationLockType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kScreenOrientation_LockOrientation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ScreenOrientation_LockOrientation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::ScreenOrientationLockType>(
      in_orientation, &params->orientation);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenOrientation::Name_);
  message.set_method_name("LockOrientation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ScreenOrientation_LockOrientation_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ScreenOrientationProxy::UnlockOrientation(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::ScreenOrientation::UnlockOrientation");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kScreenOrientation_UnlockOrientation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ScreenOrientation_UnlockOrientation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenOrientation::Name_);
  message.set_method_name("UnlockOrientation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class ScreenOrientation_LockOrientation_ProxyToResponder {
 public:
  static ScreenOrientation::LockOrientationCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ScreenOrientation_LockOrientation_ProxyToResponder> proxy(
        new ScreenOrientation_LockOrientation_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ScreenOrientation_LockOrientation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ScreenOrientation_LockOrientation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ScreenOrientation_LockOrientation_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ScreenOrientation::LockOrientationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::blink::ScreenOrientationLockResult in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ScreenOrientation_LockOrientation_ProxyToResponder);
};

bool ScreenOrientation_LockOrientation_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::ScreenOrientation::LockOrientationCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ScreenOrientation_LockOrientation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ScreenOrientation_LockOrientation_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::device::mojom::blink::ScreenOrientationLockResult p_result{};
  ScreenOrientation_LockOrientation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ScreenOrientation::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ScreenOrientation_LockOrientation_ProxyToResponder::Run(
    ::device::mojom::blink::ScreenOrientationLockResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::ScreenOrientation::LockOrientationCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::device::mojom::blink::ScreenOrientationLockResult>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kScreenOrientation_LockOrientation_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ScreenOrientation_LockOrientation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::ScreenOrientationLockResult>(
      in_result, &params->result);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::ScreenOrientation::LockOrientationCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenOrientation::Name_);
  message.set_method_name("LockOrientation");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ScreenOrientationStubDispatch::Accept(
    ScreenOrientation* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kScreenOrientation_LockOrientation_Name: {
      break;
    }
    case internal::kScreenOrientation_UnlockOrientation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::ScreenOrientation::UnlockOrientation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::ScreenOrientation::UnlockOrientation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ScreenOrientation_UnlockOrientation_Params_Data* params =
          reinterpret_cast<internal::ScreenOrientation_UnlockOrientation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ScreenOrientation_UnlockOrientation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenOrientation::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnlockOrientation();
      return true;
    }
  }
  return false;
}

// static
bool ScreenOrientationStubDispatch::AcceptWithResponder(
    ScreenOrientation* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kScreenOrientation_LockOrientation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::ScreenOrientation::LockOrientation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::ScreenOrientation::LockOrientation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ScreenOrientation_LockOrientation_Params_Data* params =
          reinterpret_cast<
              internal::ScreenOrientation_LockOrientation_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::device::mojom::blink::ScreenOrientationLockType p_orientation{};
      ScreenOrientation_LockOrientation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrientation(&p_orientation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenOrientation::Name_, 0, false);
        return false;
      }
      ScreenOrientation::LockOrientationCallback callback =
          ScreenOrientation_LockOrientation_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LockOrientation(
std::move(p_orientation), std::move(callback));
      return true;
    }
    case internal::kScreenOrientation_UnlockOrientation_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kScreenOrientationValidationInfo[] = {
    {internal::kScreenOrientation_LockOrientation_Name,
     {&internal::ScreenOrientation_LockOrientation_Params_Data::Validate,
      &internal::ScreenOrientation_LockOrientation_ResponseParams_Data::Validate}},
    {internal::kScreenOrientation_UnlockOrientation_Name,
     {&internal::ScreenOrientation_UnlockOrientation_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ScreenOrientationRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::ScreenOrientation::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kScreenOrientationValidationInfo);
}

bool ScreenOrientationResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::ScreenOrientation::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kScreenOrientationValidationInfo);

}
const char ScreenOrientationListener::Name_[] = "device.mojom.ScreenOrientationListener";

class ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback(
      ScreenOrientationListener::IsAutoRotateEnabledByUserCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ScreenOrientationListener::IsAutoRotateEnabledByUserCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback);
};

ScreenOrientationListenerProxy::ScreenOrientationListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ScreenOrientationListenerProxy::IsAutoRotateEnabledByUser(
    IsAutoRotateEnabledByUserCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::ScreenOrientationListener::IsAutoRotateEnabledByUser");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kScreenOrientationListener_IsAutoRotateEnabledByUser_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenOrientationListener::Name_);
  message.set_method_name("IsAutoRotateEnabledByUser");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder {
 public:
  static ScreenOrientationListener::IsAutoRotateEnabledByUserCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder> proxy(
        new ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ScreenOrientationListener::IsAutoRotateEnabledByUserCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_enabled);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder);
};

bool ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::ScreenOrientationListener::IsAutoRotateEnabledByUserCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_enabled{};
  ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ScreenOrientationListener::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_enabled));
  return true;
}

void ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder::Run(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::ScreenOrientationListener::IsAutoRotateEnabledByUserCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kScreenOrientationListener_IsAutoRotateEnabledByUser_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::ScreenOrientationListener::IsAutoRotateEnabledByUserCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenOrientationListener::Name_);
  message.set_method_name("IsAutoRotateEnabledByUser");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ScreenOrientationListenerStubDispatch::Accept(
    ScreenOrientationListener* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kScreenOrientationListener_IsAutoRotateEnabledByUser_Name: {
      break;
    }
  }
  return false;
}

// static
bool ScreenOrientationListenerStubDispatch::AcceptWithResponder(
    ScreenOrientationListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kScreenOrientationListener_IsAutoRotateEnabledByUser_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::ScreenOrientationListener::IsAutoRotateEnabledByUser",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::ScreenOrientationListener::IsAutoRotateEnabledByUser");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_Params_Data* params =
          reinterpret_cast<
              internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenOrientationListener::Name_, 0, false);
        return false;
      }
      ScreenOrientationListener::IsAutoRotateEnabledByUserCallback callback =
          ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsAutoRotateEnabledByUser(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kScreenOrientationListenerValidationInfo[] = {
    {internal::kScreenOrientationListener_IsAutoRotateEnabledByUser_Name,
     {&internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_Params_Data::Validate,
      &internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams_Data::Validate}},
};

bool ScreenOrientationListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::ScreenOrientationListener::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kScreenOrientationListenerValidationInfo);
}

bool ScreenOrientationListenerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::ScreenOrientationListener::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kScreenOrientationListenerValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif