// services/device/public/mojom/screen_orientation.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/device/public/mojom/screen_orientation.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "services/device/public/mojom/screen_orientation_lock_types.mojom.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SCREEN_ORIENTATION_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SCREEN_ORIENTATION_MOJOM_JUMBO_H_
#endif


namespace device {
namespace mojom {


void ScreenOrientationInterceptorForTesting::LockOrientation(::device::mojom::ScreenOrientationLockType orientation, LockOrientationCallback callback) {
  GetForwardingInterface()->LockOrientation(std::move(orientation), std::move(callback));
}
void ScreenOrientationInterceptorForTesting::UnlockOrientation() {
  GetForwardingInterface()->UnlockOrientation();
}
ScreenOrientationAsyncWaiter::ScreenOrientationAsyncWaiter(
    ScreenOrientation* proxy) : proxy_(proxy) {}

ScreenOrientationAsyncWaiter::~ScreenOrientationAsyncWaiter() = default;

void ScreenOrientationAsyncWaiter::LockOrientation(
    ::device::mojom::ScreenOrientationLockType orientation, ::device::mojom::ScreenOrientationLockResult* out_result) {
  base::RunLoop loop;
  proxy_->LockOrientation(std::move(orientation),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::device::mojom::ScreenOrientationLockResult* out_result
,
             ::device::mojom::ScreenOrientationLockResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}



void ScreenOrientationListenerInterceptorForTesting::IsAutoRotateEnabledByUser(IsAutoRotateEnabledByUserCallback callback) {
  GetForwardingInterface()->IsAutoRotateEnabledByUser(std::move(callback));
}
ScreenOrientationListenerAsyncWaiter::ScreenOrientationListenerAsyncWaiter(
    ScreenOrientationListener* proxy) : proxy_(proxy) {}

ScreenOrientationListenerAsyncWaiter::~ScreenOrientationListenerAsyncWaiter() = default;

void ScreenOrientationListenerAsyncWaiter::IsAutoRotateEnabledByUser(
    bool* out_enabled) {
  base::RunLoop loop;
  proxy_->IsAutoRotateEnabledByUser(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_enabled
,
             bool enabled) {*out_enabled = std::move(enabled);
            loop->Quit();
          },
          &loop,
          out_enabled));
  loop.Run();
}





}  // namespace mojom
}  // namespace device

#if defined(__clang__)
#pragma clang diagnostic pop
#endif