// services/device/public/mojom/sensor.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/sensor.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/sensor.mojom-params-data.h"
namespace device {
namespace mojom {

static NOINLINE const char* SensorTypeToStringHelper(SensorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SensorType::AMBIENT_LIGHT:
      return "AMBIENT_LIGHT";
    case SensorType::PROXIMITY:
      return "PROXIMITY";
    case SensorType::ACCELEROMETER:
      return "ACCELEROMETER";
    case SensorType::LINEAR_ACCELERATION:
      return "LINEAR_ACCELERATION";
    case SensorType::GRAVITY:
      return "GRAVITY";
    case SensorType::GYROSCOPE:
      return "GYROSCOPE";
    case SensorType::MAGNETOMETER:
      return "MAGNETOMETER";
    case SensorType::PRESSURE:
      return "PRESSURE";
    case SensorType::ABSOLUTE_ORIENTATION_EULER_ANGLES:
      return "ABSOLUTE_ORIENTATION_EULER_ANGLES";
    case SensorType::ABSOLUTE_ORIENTATION_QUATERNION:
      return "ABSOLUTE_ORIENTATION_QUATERNION";
    case SensorType::RELATIVE_ORIENTATION_EULER_ANGLES:
      return "RELATIVE_ORIENTATION_EULER_ANGLES";
    case SensorType::RELATIVE_ORIENTATION_QUATERNION:
      return "RELATIVE_ORIENTATION_QUATERNION";
    default:
      return nullptr;
  }
}

std::string SensorTypeToString(SensorType value) {
  const char *str = SensorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SensorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SensorType value) {
  return os << SensorTypeToString(value);
}

static NOINLINE const char* ReportingModeToStringHelper(ReportingMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ReportingMode::ON_CHANGE:
      return "ON_CHANGE";
    case ReportingMode::CONTINUOUS:
      return "CONTINUOUS";
    default:
      return nullptr;
  }
}

std::string ReportingModeToString(ReportingMode value) {
  const char *str = ReportingModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ReportingMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ReportingMode value) {
  return os << ReportingModeToString(value);
}

namespace internal {


// static
bool SensorConfiguration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SensorConfiguration_Data* object = static_cast<const SensorConfiguration_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SensorConfiguration_Data::SensorConfiguration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_GetDefaultConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_GetDefaultConfiguration_Params_Data* object = static_cast<const Sensor_GetDefaultConfiguration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Sensor_GetDefaultConfiguration_Params_Data::Sensor_GetDefaultConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_GetDefaultConfiguration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_GetDefaultConfiguration_ResponseParams_Data* object = static_cast<const Sensor_GetDefaultConfiguration_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configuration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->configuration, validation_context))
    return false;

  return true;
}

Sensor_GetDefaultConfiguration_ResponseParams_Data::Sensor_GetDefaultConfiguration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_AddConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_AddConfiguration_Params_Data* object = static_cast<const Sensor_AddConfiguration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configuration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->configuration, validation_context))
    return false;

  return true;
}

Sensor_AddConfiguration_Params_Data::Sensor_AddConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_AddConfiguration_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_AddConfiguration_ResponseParams_Data* object = static_cast<const Sensor_AddConfiguration_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Sensor_AddConfiguration_ResponseParams_Data::Sensor_AddConfiguration_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_RemoveConfiguration_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_RemoveConfiguration_Params_Data* object = static_cast<const Sensor_RemoveConfiguration_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configuration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->configuration, validation_context))
    return false;

  return true;
}

Sensor_RemoveConfiguration_Params_Data::Sensor_RemoveConfiguration_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_Suspend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_Suspend_Params_Data* object = static_cast<const Sensor_Suspend_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Sensor_Suspend_Params_Data::Sensor_Suspend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_Resume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_Resume_Params_Data* object = static_cast<const Sensor_Resume_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Sensor_Resume_Params_Data::Sensor_Resume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Sensor_ConfigureReadingChangeNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Sensor_ConfigureReadingChangeNotifications_Params_Data* object = static_cast<const Sensor_ConfigureReadingChangeNotifications_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

Sensor_ConfigureReadingChangeNotifications_Params_Data::Sensor_ConfigureReadingChangeNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorClient_RaiseError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SensorClient_RaiseError_Params_Data* object = static_cast<const SensorClient_RaiseError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SensorClient_RaiseError_Params_Data::SensorClient_RaiseError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorClient_SensorReadingChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SensorClient_SensorReadingChanged_Params_Data* object = static_cast<const SensorClient_SensorReadingChanged_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SensorClient_SensorReadingChanged_Params_Data::SensorClient_SensorReadingChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SensorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SensorType value) {
  return std::move(context).WriteString(::device::mojom::SensorTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::ReportingMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::ReportingMode value) {
  return std::move(context).WriteString(::device::mojom::ReportingModeToString(value));
}

} // namespace perfetto
