// services/device/public/mojom/usb_manager_client.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/usb_manager_client.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/usb_manager_client.mojom-params-data.h"
#include "services/device/public/mojom/usb_manager_client.mojom-shared-message-ids.h"

#include "services/device/public/mojom/usb_manager_client.mojom-import-headers.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_CLIENT_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_CLIENT_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
const char UsbDeviceManagerClient::Name_[] = "device.mojom.UsbDeviceManagerClient";

UsbDeviceManagerClientProxy::UsbDeviceManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UsbDeviceManagerClientProxy::OnDeviceAdded(
    ::device::mojom::UsbDeviceInfoPtr in_device_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::UsbDeviceManagerClient::OnDeviceAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type ::device::mojom::UsbDeviceInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUsbDeviceManagerClient_OnDeviceAdded_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerClient_OnDeviceAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::UsbDeviceInfoDataView>(
      in_device_info, device_info_fragment);
  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_info in UsbDeviceManagerClient.OnDeviceAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerClient::Name_);
  message.set_method_name("OnDeviceAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void UsbDeviceManagerClientProxy::OnDeviceRemoved(
    ::device::mojom::UsbDeviceInfoPtr in_device_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::UsbDeviceManagerClient::OnDeviceRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type ::device::mojom::UsbDeviceInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUsbDeviceManagerClient_OnDeviceRemoved_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerClient_OnDeviceRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::UsbDeviceInfoDataView>(
      in_device_info, device_info_fragment);
  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->device_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_info in UsbDeviceManagerClient.OnDeviceRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerClient::Name_);
  message.set_method_name("OnDeviceRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool UsbDeviceManagerClientStubDispatch::Accept(
    UsbDeviceManagerClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kUsbDeviceManagerClient_OnDeviceAdded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::UsbDeviceManagerClient::OnDeviceAdded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::UsbDeviceManagerClient::OnDeviceAdded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UsbDeviceManagerClient_OnDeviceAdded_Params_Data* params =
          reinterpret_cast<internal::UsbDeviceManagerClient_OnDeviceAdded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::device::mojom::UsbDeviceInfoPtr p_device_info{};
      UsbDeviceManagerClient_OnDeviceAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceAdded(
std::move(p_device_info));
      return true;
    }
    case internal::kUsbDeviceManagerClient_OnDeviceRemoved_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::UsbDeviceManagerClient::OnDeviceRemoved",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::UsbDeviceManagerClient::OnDeviceRemoved");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UsbDeviceManagerClient_OnDeviceRemoved_Params_Data* params =
          reinterpret_cast<internal::UsbDeviceManagerClient_OnDeviceRemoved_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::device::mojom::UsbDeviceInfoPtr p_device_info{};
      UsbDeviceManagerClient_OnDeviceRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManagerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceRemoved(
std::move(p_device_info));
      return true;
    }
  }
  return false;
}

// static
bool UsbDeviceManagerClientStubDispatch::AcceptWithResponder(
    UsbDeviceManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kUsbDeviceManagerClient_OnDeviceAdded_Name: {
      break;
    }
    case internal::kUsbDeviceManagerClient_OnDeviceRemoved_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kUsbDeviceManagerClientValidationInfo[] = {
    {&internal::UsbDeviceManagerClient_OnDeviceAdded_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::UsbDeviceManagerClient_OnDeviceRemoved_Params_Data::Validate,
     nullptr /* no response */},
};

bool UsbDeviceManagerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::UsbDeviceManagerClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kUsbDeviceManagerClientValidationInfo);
}

}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif