// services/device/public/mojom/usb_manager_test.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/device/public/mojom/usb_manager_test.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "url/mojom/url.mojom.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_TEST_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_TEST_MOJOM_JUMBO_H_
#endif


namespace device {
namespace mojom {


void UsbDeviceManagerTestInterceptorForTesting::AddDeviceForTesting(const std::string& name, const std::string& serial_number, const std::string& landing_page, AddDeviceForTestingCallback callback) {
  GetForwardingInterface()->AddDeviceForTesting(std::move(name), std::move(serial_number), std::move(landing_page), std::move(callback));
}
void UsbDeviceManagerTestInterceptorForTesting::RemoveDeviceForTesting(const std::string& guid, RemoveDeviceForTestingCallback callback) {
  GetForwardingInterface()->RemoveDeviceForTesting(std::move(guid), std::move(callback));
}
void UsbDeviceManagerTestInterceptorForTesting::GetTestDevices(GetTestDevicesCallback callback) {
  GetForwardingInterface()->GetTestDevices(std::move(callback));
}
UsbDeviceManagerTestAsyncWaiter::UsbDeviceManagerTestAsyncWaiter(
    UsbDeviceManagerTest* proxy) : proxy_(proxy) {}

UsbDeviceManagerTestAsyncWaiter::~UsbDeviceManagerTestAsyncWaiter() = default;

void UsbDeviceManagerTestAsyncWaiter::AddDeviceForTesting(
    const std::string& name, const std::string& serial_number, const std::string& landing_page, bool* out_success, std::string* out_message) {
  base::RunLoop loop;
  proxy_->AddDeviceForTesting(std::move(name),std::move(serial_number),std::move(landing_page),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::string* out_message
,
             bool success,
             const std::string& message) {*out_success = std::move(success);*out_message = std::move(message);
            loop->Quit();
          },
          &loop,
          out_success,
          out_message));
  loop.Run();
}
void UsbDeviceManagerTestAsyncWaiter::RemoveDeviceForTesting(
    const std::string& guid) {
  base::RunLoop loop;
  proxy_->RemoveDeviceForTesting(std::move(guid),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}
void UsbDeviceManagerTestAsyncWaiter::GetTestDevices(
    std::vector<TestDeviceInfoPtr>* out_devices) {
  base::RunLoop loop;
  proxy_->GetTestDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<TestDeviceInfoPtr>* out_devices
,
             std::vector<TestDeviceInfoPtr> devices) {*out_devices = std::move(devices);
            loop->Quit();
          },
          &loop,
          out_devices));
  loop.Run();
}





}  // namespace mojom
}  // namespace device

#if defined(__clang__)
#pragma clang diagnostic pop
#endif