// services/device/public/mojom/wake_lock.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/wake_lock.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/wake_lock.mojom-params-data.h"
#include "services/device/public/mojom/wake_lock.mojom-shared-message-ids.h"

#include "services/device/public/mojom/wake_lock.mojom-import-headers.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_WAKE_LOCK_MOJOM_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_WAKE_LOCK_MOJOM_JUMBO_H_
#endif
namespace device {
namespace mojom {
const char WakeLock::Name_[] = "device.mojom.WakeLock";

class WakeLock_ChangeType_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WakeLock_ChangeType_ForwardToCallback(
      WakeLock::ChangeTypeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WakeLock::ChangeTypeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WakeLock_ChangeType_ForwardToCallback);
};

class WakeLock_HasWakeLockForTests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WakeLock_HasWakeLockForTests_ForwardToCallback(
      WakeLock::HasWakeLockForTestsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WakeLock::HasWakeLockForTestsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WakeLock_HasWakeLockForTests_ForwardToCallback);
};

WakeLockProxy::WakeLockProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WakeLockProxy::RequestWakeLock(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::WakeLock::RequestWakeLock");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWakeLock_RequestWakeLock_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLock_RequestWakeLock_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLock::Name_);
  message.set_method_name("RequestWakeLock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WakeLockProxy::CancelWakeLock(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::WakeLock::CancelWakeLock");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWakeLock_CancelWakeLock_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLock_CancelWakeLock_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLock::Name_);
  message.set_method_name("CancelWakeLock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WakeLockProxy::AddClient(
    ::mojo::PendingReceiver<WakeLock> in_wake_lock) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::WakeLock::AddClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wake_lock"), in_wake_lock,
                        "<value of type ::mojo::PendingReceiver<WakeLock>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWakeLock_AddClient_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLock_AddClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::WakeLockInterfaceBase>>(
      in_wake_lock, &params->wake_lock, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->wake_lock),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid wake_lock in WakeLock.AddClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLock::Name_);
  message.set_method_name("AddClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WakeLockProxy::ChangeType(
    WakeLockType in_type, ChangeTypeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::WakeLock::ChangeType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type WakeLockType>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWakeLock_ChangeType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLock_ChangeType_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::WakeLockType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLock::Name_);
  message.set_method_name("ChangeType");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WakeLock_ChangeType_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WakeLockProxy::HasWakeLockForTests(
    HasWakeLockForTestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::WakeLock::HasWakeLockForTests");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWakeLock_HasWakeLockForTests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLock_HasWakeLockForTests_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLock::Name_);
  message.set_method_name("HasWakeLockForTests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WakeLock_HasWakeLockForTests_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class WakeLock_ChangeType_ProxyToResponder {
 public:
  static WakeLock::ChangeTypeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WakeLock_ChangeType_ProxyToResponder> proxy(
        new WakeLock_ChangeType_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WakeLock_ChangeType_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WakeLock_ChangeType_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WakeLock_ChangeType_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WakeLock::ChangeTypeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WakeLock_ChangeType_ProxyToResponder);
};

bool WakeLock_ChangeType_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::WakeLock::ChangeTypeCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WakeLock_ChangeType_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WakeLock_ChangeType_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  WakeLock_ChangeType_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WakeLock::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void WakeLock_ChangeType_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::WakeLock::ChangeTypeCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWakeLock_ChangeType_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLock_ChangeType_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::WakeLock::ChangeTypeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLock::Name_);
  message.set_method_name("ChangeType");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WakeLock_HasWakeLockForTests_ProxyToResponder {
 public:
  static WakeLock::HasWakeLockForTestsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WakeLock_HasWakeLockForTests_ProxyToResponder> proxy(
        new WakeLock_HasWakeLockForTests_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WakeLock_HasWakeLockForTests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WakeLock_HasWakeLockForTests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WakeLock_HasWakeLockForTests_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WakeLock::HasWakeLockForTestsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WakeLock_HasWakeLockForTests_ProxyToResponder);
};

bool WakeLock_HasWakeLockForTests_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::WakeLock::HasWakeLockForTestsCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WakeLock_HasWakeLockForTests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WakeLock_HasWakeLockForTests_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  WakeLock_HasWakeLockForTests_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WakeLock::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void WakeLock_HasWakeLockForTests_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::WakeLock::HasWakeLockForTestsCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWakeLock_HasWakeLockForTests_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLock_HasWakeLockForTests_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::WakeLock::HasWakeLockForTestsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLock::Name_);
  message.set_method_name("HasWakeLockForTests");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WakeLockStubDispatch::Accept(
    WakeLock* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWakeLock_RequestWakeLock_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::WakeLock::RequestWakeLock",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::WakeLock::RequestWakeLock");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WakeLock_RequestWakeLock_Params_Data* params =
          reinterpret_cast<internal::WakeLock_RequestWakeLock_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WakeLock_RequestWakeLock_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLock::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestWakeLock();
      return true;
    }
    case internal::kWakeLock_CancelWakeLock_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::WakeLock::CancelWakeLock",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::WakeLock::CancelWakeLock");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WakeLock_CancelWakeLock_Params_Data* params =
          reinterpret_cast<internal::WakeLock_CancelWakeLock_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WakeLock_CancelWakeLock_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLock::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelWakeLock();
      return true;
    }
    case internal::kWakeLock_AddClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::WakeLock::AddClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::WakeLock::AddClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WakeLock_AddClient_Params_Data* params =
          reinterpret_cast<internal::WakeLock_AddClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<WakeLock> p_wake_lock{};
      WakeLock_AddClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_wake_lock =
            input_data_view.TakeWakeLock<decltype(p_wake_lock)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLock::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddClient(
std::move(p_wake_lock));
      return true;
    }
    case internal::kWakeLock_ChangeType_Name: {
      break;
    }
    case internal::kWakeLock_HasWakeLockForTests_Name: {
      break;
    }
  }
  return false;
}

// static
bool WakeLockStubDispatch::AcceptWithResponder(
    WakeLock* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWakeLock_RequestWakeLock_Name: {
      break;
    }
    case internal::kWakeLock_CancelWakeLock_Name: {
      break;
    }
    case internal::kWakeLock_AddClient_Name: {
      break;
    }
    case internal::kWakeLock_ChangeType_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::WakeLock::ChangeType",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::WakeLock::ChangeType");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WakeLock_ChangeType_Params_Data* params =
          reinterpret_cast<
              internal::WakeLock_ChangeType_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WakeLockType p_type{};
      WakeLock_ChangeType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLock::Name_, 3, false);
        return false;
      }
      WakeLock::ChangeTypeCallback callback =
          WakeLock_ChangeType_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangeType(
std::move(p_type), std::move(callback));
      return true;
    }
    case internal::kWakeLock_HasWakeLockForTests_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::WakeLock::HasWakeLockForTests",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::WakeLock::HasWakeLockForTests");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WakeLock_HasWakeLockForTests_Params_Data* params =
          reinterpret_cast<
              internal::WakeLock_HasWakeLockForTests_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WakeLock_HasWakeLockForTests_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLock::Name_, 4, false);
        return false;
      }
      WakeLock::HasWakeLockForTestsCallback callback =
          WakeLock_HasWakeLockForTests_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasWakeLockForTests(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWakeLockValidationInfo[] = {
    {internal::kWakeLock_RequestWakeLock_Name,
     {&internal::WakeLock_RequestWakeLock_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWakeLock_CancelWakeLock_Name,
     {&internal::WakeLock_CancelWakeLock_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWakeLock_AddClient_Name,
     {&internal::WakeLock_AddClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWakeLock_ChangeType_Name,
     {&internal::WakeLock_ChangeType_Params_Data::Validate,
      &internal::WakeLock_ChangeType_ResponseParams_Data::Validate}},
    {internal::kWakeLock_HasWakeLockForTests_Name,
     {&internal::WakeLock_HasWakeLockForTests_Params_Data::Validate,
      &internal::WakeLock_HasWakeLockForTests_ResponseParams_Data::Validate}},
};

bool WakeLockRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::WakeLock::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWakeLockValidationInfo);
}

bool WakeLockResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::WakeLock::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kWakeLockValidationInfo);

}
}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif