// services/image_annotation/public/mojom/image_annotation.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/image_annotation/public/mojom/image_annotation.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/image_annotation/public/mojom/image_annotation.mojom-params-data.h"
namespace image_annotation {
namespace mojom {

static NOINLINE const char* AnnotateImageErrorToStringHelper(AnnotateImageError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AnnotateImageError::kCanceled:
      return "kCanceled";
    case AnnotateImageError::kFailure:
      return "kFailure";
    case AnnotateImageError::kAdult:
      return "kAdult";
    default:
      return nullptr;
  }
}

std::string AnnotateImageErrorToString(AnnotateImageError value) {
  const char *str = AnnotateImageErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AnnotateImageError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AnnotateImageError value) {
  return os << AnnotateImageErrorToString(value);
}

static NOINLINE const char* AnnotationTypeToStringHelper(AnnotationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AnnotationType::kOcr:
      return "kOcr";
    case AnnotationType::kLabel:
      return "kLabel";
    case AnnotationType::kCaption:
      return "kCaption";
    default:
      return nullptr;
  }
}

std::string AnnotationTypeToString(AnnotationType value) {
  const char *str = AnnotationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AnnotationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AnnotationType value) {
  return os << AnnotationTypeToString(value);
}

namespace internal {
// static
bool AnnotateImageResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AnnotateImageResult_Data* object = static_cast<const AnnotateImageResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AnnotateImageResult_Tag::ERROR_CODE: {


      if (!::image_annotation::mojom::internal::AnnotateImageError_Data
            ::Validate(object->data.f_error_code, validation_context))
        return false;
      return true;
    }
    case AnnotateImageResult_Tag::ANNOTATIONS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_annotations, 2, validation_context)) {
        return false;
      }
      const mojo::internal::ContainerValidateParams annotations_validate_params(
          0, false, nullptr);
      if (!mojo::internal::ValidateContainer(object->data.f_annotations, validation_context,
                                             &annotations_validate_params)) {
        return false;
      }
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AnnotateImageResult");
      return false;
    }
  }
}


// static
bool Annotation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Annotation_Data* object = static_cast<const Annotation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::image_annotation::mojom::internal::AnnotationType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

Annotation_Data::Annotation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageProcessor_GetJpgImageData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ImageProcessor_GetJpgImageData_Params_Data* object = static_cast<const ImageProcessor_GetJpgImageData_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

ImageProcessor_GetJpgImageData_Params_Data::ImageProcessor_GetJpgImageData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageProcessor_GetJpgImageData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ImageProcessor_GetJpgImageData_ResponseParams_Data* object = static_cast<const ImageProcessor_GetJpgImageData_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams bytes_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->bytes, validation_context,
                                         &bytes_validate_params)) {
    return false;
  }

  return true;
}

ImageProcessor_GetJpgImageData_ResponseParams_Data::ImageProcessor_GetJpgImageData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Annotator_AnnotateImage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Annotator_AnnotateImage_Params_Data* object = static_cast<const Annotator_AnnotateImage_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_id, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams source_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->source_id, validation_context,
                                         &source_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description_language_tag, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams description_language_tag_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->description_language_tag, validation_context,
                                         &description_language_tag_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->image_processor, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->image_processor,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Annotator_AnnotateImage_Params_Data::Annotator_AnnotateImage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Annotator_AnnotateImage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Annotator_AnnotateImage_ResponseParams_Data* object = static_cast<const Annotator_AnnotateImage_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

Annotator_AnnotateImage_ResponseParams_Data::Annotator_AnnotateImage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageAnnotationService_BindAnnotator_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ImageAnnotationService_BindAnnotator_Params_Data* object = static_cast<const ImageAnnotationService_BindAnnotator_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ImageAnnotationService_BindAnnotator_Params_Data::ImageAnnotationService_BindAnnotator_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace image_annotation

namespace perfetto {

// static
void TraceFormatTraits<::image_annotation::mojom::AnnotateImageError>::WriteIntoTrace(
   perfetto::TracedValue context, ::image_annotation::mojom::AnnotateImageError value) {
  return std::move(context).WriteString(::image_annotation::mojom::AnnotateImageErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::image_annotation::mojom::AnnotationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::image_annotation::mojom::AnnotationType value) {
  return std::move(context).WriteString(::image_annotation::mojom::AnnotationTypeToString(value));
}

} // namespace perfetto
