// services/media_session/public/mojom/media_controller.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/media_session/public/mojom/media_controller.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/media_session/public/mojom/media_controller.mojom-params-data.h"
#include "services/media_session/public/mojom/media_controller.mojom-shared-message-ids.h"

#include "services/media_session/public/mojom/media_controller.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_BLINK_JUMBO_H_
#endif
namespace media_session {
namespace mojom {
namespace blink {
const char MediaControllerManager::Name_[] = "media_session.mojom.MediaControllerManager";
constexpr base::Token MediaControllerManager::Uuid_;

MediaControllerManagerProxy::MediaControllerManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaControllerManagerProxy::CreateMediaControllerForSession(
    ::mojo::PendingReceiver<MediaController> in_receiver, const ::base::UnguessableToken& in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaControllerManager::CreateMediaControllerForSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<MediaController>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaControllerManager_CreateMediaControllerForSession_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_session::mojom::MediaControllerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in MediaControllerManager.CreateMediaControllerForSession request");
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_request_id, request_id_fragment);
  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_id in MediaControllerManager.CreateMediaControllerForSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerManager::Name_);
  message.set_method_name("CreateMediaControllerForSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerManagerProxy::CreateActiveMediaController(
    ::mojo::PendingReceiver<MediaController> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaControllerManager::CreateActiveMediaController", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<MediaController>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaControllerManager_CreateActiveMediaController_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerManager_CreateActiveMediaController_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media_session::mojom::MediaControllerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in MediaControllerManager.CreateActiveMediaController request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerManager::Name_);
  message.set_method_name("CreateActiveMediaController");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerManagerProxy::SuspendAllSessions(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaControllerManager::SuspendAllSessions");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaControllerManager_SuspendAllSessions_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerManager_SuspendAllSessions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerManager::Name_);
  message.set_method_name("SuspendAllSessions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaControllerManagerStubDispatch::Accept(
    MediaControllerManager* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaControllerManager_CreateMediaControllerForSession_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaControllerManager::CreateMediaControllerForSession",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaControllerManager::CreateMediaControllerForSession");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data* params =
          reinterpret_cast<internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<MediaController> p_receiver{};
      ::base::UnguessableToken p_request_id{};
      MediaControllerManager_CreateMediaControllerForSession_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateMediaControllerForSession(
std::move(p_receiver), 
std::move(p_request_id));
      return true;
    }
    case internal::kMediaControllerManager_CreateActiveMediaController_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaControllerManager::CreateActiveMediaController",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaControllerManager::CreateActiveMediaController");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaControllerManager_CreateActiveMediaController_Params_Data* params =
          reinterpret_cast<internal::MediaControllerManager_CreateActiveMediaController_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<MediaController> p_receiver{};
      MediaControllerManager_CreateActiveMediaController_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateActiveMediaController(
std::move(p_receiver));
      return true;
    }
    case internal::kMediaControllerManager_SuspendAllSessions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaControllerManager::SuspendAllSessions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaControllerManager::SuspendAllSessions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaControllerManager_SuspendAllSessions_Params_Data* params =
          reinterpret_cast<internal::MediaControllerManager_SuspendAllSessions_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaControllerManager_SuspendAllSessions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuspendAllSessions();
      return true;
    }
  }
  return false;
}

// static
bool MediaControllerManagerStubDispatch::AcceptWithResponder(
    MediaControllerManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaControllerManager_CreateMediaControllerForSession_Name: {
      break;
    }
    case internal::kMediaControllerManager_CreateActiveMediaController_Name: {
      break;
    }
    case internal::kMediaControllerManager_SuspendAllSessions_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaControllerManagerValidationInfo[] = {
    {&internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaControllerManager_CreateActiveMediaController_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaControllerManager_SuspendAllSessions_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaControllerManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::blink::MediaControllerManager::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaControllerManagerValidationInfo);
}

const char MediaController::Name_[] = "media_session.mojom.MediaController";

MediaControllerProxy::MediaControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaControllerProxy::Suspend(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::Suspend");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_Suspend_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_Suspend_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Suspend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::Resume(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::Resume");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_Resume_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_Resume_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::Stop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::Stop");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_Stop_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::ToggleSuspendResume(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::ToggleSuspendResume");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_ToggleSuspendResume_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ToggleSuspendResume_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ToggleSuspendResume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::AddObserver(
    ::mojo::PendingRemote<MediaControllerObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaController::AddObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<MediaControllerObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_AddObserver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_AddObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaControllerObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in MediaController.AddObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("AddObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::PreviousTrack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::PreviousTrack");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_PreviousTrack_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_PreviousTrack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("PreviousTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::NextTrack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::NextTrack");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_NextTrack_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_NextTrack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("NextTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::Seek(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaController::Seek", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_Seek_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_Seek_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_seek_time, seek_time_fragment);
  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->seek_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seek_time in MediaController.Seek request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Seek");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::ObserveImages(
    ::media_session::mojom::blink::MediaSessionImageType in_type, int32_t in_minimum_size_px, int32_t in_desired_size_px, ::mojo::PendingRemote<MediaControllerImageObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaController::ObserveImages", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::media_session::mojom::blink::MediaSessionImageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("minimum_size_px"), in_minimum_size_px,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("desired_size_px"), in_desired_size_px,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<MediaControllerImageObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_ObserveImages_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ObserveImages_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media_session::mojom::MediaSessionImageType>(
      in_type, &params->type);
  params->minimum_size_px = in_minimum_size_px;
  params->desired_size_px = in_desired_size_px;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaControllerImageObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in MediaController.ObserveImages request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ObserveImages");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::SeekTo(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaController::SeekTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_SeekTo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_SeekTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_seek_time, seek_time_fragment);
  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->seek_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seek_time in MediaController.SeekTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("SeekTo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::ScrubTo(
    ::base::TimeDelta in_seek_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaController::ScrubTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seek_time"), in_seek_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_ScrubTo_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ScrubTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seek_time)::BaseType> seek_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_seek_time, seek_time_fragment);
  params->seek_time.Set(
      seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->seek_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null seek_time in MediaController.ScrubTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ScrubTo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::EnterPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::EnterPictureInPicture");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_EnterPictureInPicture_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_EnterPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("EnterPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::ExitPictureInPicture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::ExitPictureInPicture");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_ExitPictureInPicture_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ExitPictureInPicture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ExitPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::SetAudioSinkId(
    const WTF::String& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaController::SetAudioSinkId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_SetAudioSinkId_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_SetAudioSinkId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("SetAudioSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::ToggleMicrophone(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::ToggleMicrophone");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_ToggleMicrophone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ToggleMicrophone_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ToggleMicrophone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::ToggleCamera(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::ToggleCamera");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_ToggleCamera_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_ToggleCamera_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("ToggleCamera");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::HangUp(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::HangUp");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_HangUp_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_HangUp_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("HangUp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerProxy::Raise(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media_session::mojom::MediaController::Raise");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaController_Raise_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaController_Raise_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Raise");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaControllerStubDispatch::Accept(
    MediaController* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaController_Suspend_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::Suspend",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::Suspend");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_Suspend_Params_Data* params =
          reinterpret_cast<internal::MediaController_Suspend_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_Suspend_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Suspend();
      return true;
    }
    case internal::kMediaController_Resume_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::Resume",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::Resume");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_Resume_Params_Data* params =
          reinterpret_cast<internal::MediaController_Resume_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_Resume_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume();
      return true;
    }
    case internal::kMediaController_Stop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::Stop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::Stop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_Stop_Params_Data* params =
          reinterpret_cast<internal::MediaController_Stop_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop();
      return true;
    }
    case internal::kMediaController_ToggleSuspendResume_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::ToggleSuspendResume",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::ToggleSuspendResume");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_ToggleSuspendResume_Params_Data* params =
          reinterpret_cast<internal::MediaController_ToggleSuspendResume_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_ToggleSuspendResume_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleSuspendResume();
      return true;
    }
    case internal::kMediaController_AddObserver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::AddObserver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::AddObserver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_AddObserver_Params_Data* params =
          reinterpret_cast<internal::MediaController_AddObserver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<MediaControllerObserver> p_observer{};
      MediaController_AddObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddObserver(
std::move(p_observer));
      return true;
    }
    case internal::kMediaController_PreviousTrack_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::PreviousTrack",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::PreviousTrack");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_PreviousTrack_Params_Data* params =
          reinterpret_cast<internal::MediaController_PreviousTrack_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_PreviousTrack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreviousTrack();
      return true;
    }
    case internal::kMediaController_NextTrack_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::NextTrack",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::NextTrack");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_NextTrack_Params_Data* params =
          reinterpret_cast<internal::MediaController_NextTrack_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_NextTrack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NextTrack();
      return true;
    }
    case internal::kMediaController_Seek_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::Seek",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::Seek");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_Seek_Params_Data* params =
          reinterpret_cast<internal::MediaController_Seek_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaController_Seek_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Seek(
std::move(p_seek_time));
      return true;
    }
    case internal::kMediaController_ObserveImages_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::ObserveImages",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::ObserveImages");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_ObserveImages_Params_Data* params =
          reinterpret_cast<internal::MediaController_ObserveImages_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::blink::MediaSessionImageType p_type{};
      int32_t p_minimum_size_px{};
      int32_t p_desired_size_px{};
      ::mojo::PendingRemote<MediaControllerImageObserver> p_observer{};
      MediaController_ObserveImages_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success)
        p_minimum_size_px = input_data_view.minimum_size_px();
      if (success)
        p_desired_size_px = input_data_view.desired_size_px();
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ObserveImages(
std::move(p_type), 
std::move(p_minimum_size_px), 
std::move(p_desired_size_px), 
std::move(p_observer));
      return true;
    }
    case internal::kMediaController_SeekTo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::SeekTo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::SeekTo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_SeekTo_Params_Data* params =
          reinterpret_cast<internal::MediaController_SeekTo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaController_SeekTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SeekTo(
std::move(p_seek_time));
      return true;
    }
    case internal::kMediaController_ScrubTo_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::ScrubTo",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::ScrubTo");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_ScrubTo_Params_Data* params =
          reinterpret_cast<internal::MediaController_ScrubTo_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_seek_time{};
      MediaController_ScrubTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeekTime(&p_seek_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrubTo(
std::move(p_seek_time));
      return true;
    }
    case internal::kMediaController_EnterPictureInPicture_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::EnterPictureInPicture",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::EnterPictureInPicture");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_EnterPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaController_EnterPictureInPicture_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_EnterPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnterPictureInPicture();
      return true;
    }
    case internal::kMediaController_ExitPictureInPicture_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::ExitPictureInPicture",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::ExitPictureInPicture");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_ExitPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::MediaController_ExitPictureInPicture_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_ExitPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitPictureInPicture();
      return true;
    }
    case internal::kMediaController_SetAudioSinkId_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::SetAudioSinkId",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::SetAudioSinkId");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_SetAudioSinkId_Params_Data* params =
          reinterpret_cast<internal::MediaController_SetAudioSinkId_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::String p_id{};
      MediaController_SetAudioSinkId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAudioSinkId(
std::move(p_id));
      return true;
    }
    case internal::kMediaController_ToggleMicrophone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::ToggleMicrophone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::ToggleMicrophone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_ToggleMicrophone_Params_Data* params =
          reinterpret_cast<internal::MediaController_ToggleMicrophone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_ToggleMicrophone_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleMicrophone();
      return true;
    }
    case internal::kMediaController_ToggleCamera_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::ToggleCamera",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::ToggleCamera");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_ToggleCamera_Params_Data* params =
          reinterpret_cast<internal::MediaController_ToggleCamera_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_ToggleCamera_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ToggleCamera();
      return true;
    }
    case internal::kMediaController_HangUp_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::HangUp",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::HangUp");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_HangUp_Params_Data* params =
          reinterpret_cast<internal::MediaController_HangUp_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_HangUp_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HangUp();
      return true;
    }
    case internal::kMediaController_Raise_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaController::Raise",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaController::Raise");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaController_Raise_Params_Data* params =
          reinterpret_cast<internal::MediaController_Raise_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaController_Raise_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Raise();
      return true;
    }
  }
  return false;
}

// static
bool MediaControllerStubDispatch::AcceptWithResponder(
    MediaController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaController_Suspend_Name: {
      break;
    }
    case internal::kMediaController_Resume_Name: {
      break;
    }
    case internal::kMediaController_Stop_Name: {
      break;
    }
    case internal::kMediaController_ToggleSuspendResume_Name: {
      break;
    }
    case internal::kMediaController_AddObserver_Name: {
      break;
    }
    case internal::kMediaController_PreviousTrack_Name: {
      break;
    }
    case internal::kMediaController_NextTrack_Name: {
      break;
    }
    case internal::kMediaController_Seek_Name: {
      break;
    }
    case internal::kMediaController_ObserveImages_Name: {
      break;
    }
    case internal::kMediaController_SeekTo_Name: {
      break;
    }
    case internal::kMediaController_ScrubTo_Name: {
      break;
    }
    case internal::kMediaController_EnterPictureInPicture_Name: {
      break;
    }
    case internal::kMediaController_ExitPictureInPicture_Name: {
      break;
    }
    case internal::kMediaController_SetAudioSinkId_Name: {
      break;
    }
    case internal::kMediaController_ToggleMicrophone_Name: {
      break;
    }
    case internal::kMediaController_ToggleCamera_Name: {
      break;
    }
    case internal::kMediaController_HangUp_Name: {
      break;
    }
    case internal::kMediaController_Raise_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaControllerValidationInfo[] = {
    {&internal::MediaController_Suspend_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_Resume_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_Stop_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_ToggleSuspendResume_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_AddObserver_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_PreviousTrack_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_NextTrack_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_Seek_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_ObserveImages_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_SeekTo_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_ScrubTo_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_EnterPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_ExitPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_SetAudioSinkId_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_ToggleMicrophone_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_ToggleCamera_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_HangUp_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaController_Raise_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaControllerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::blink::MediaController::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaControllerValidationInfo);
}

const char MediaControllerObserver::Name_[] = "media_session.mojom.MediaControllerObserver";

MediaControllerObserverProxy::MediaControllerObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaControllerObserverProxy::MediaSessionInfoChanged(
    ::media_session::mojom::blink::MediaSessionInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaControllerObserver::MediaSessionInfoChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ::media_session::mojom::blink::MediaSessionInfoPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaControllerObserver_MediaSessionInfoChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerObserver::Name_);
  message.set_method_name("MediaSessionInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerObserverProxy::MediaSessionMetadataChanged(
    ::media_session::mojom::blink::MediaMetadataPtr in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaControllerObserver::MediaSessionMetadataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type ::media_session::mojom::blink::MediaMetadataPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaControllerObserver_MediaSessionMetadataChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaMetadataDataView>(
      in_metadata, metadata_fragment);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerObserver::Name_);
  message.set_method_name("MediaSessionMetadataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerObserverProxy::MediaSessionActionsChanged(
    const WTF::Vector<::media_session::mojom::blink::MediaSessionAction>& in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaControllerObserver::MediaSessionActionsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type const WTF::Vector<::media_session::mojom::blink::MediaSessionAction>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaControllerObserver_MediaSessionActionsChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->action)::BaseType>
      action_fragment(params.message());
  const mojo::internal::ContainerValidateParams action_validate_params(
      0, ::media_session::mojom::internal::MediaSessionAction_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>>(
      in_action, action_fragment, &action_validate_params);
  params->action.Set(
      action_fragment.is_null() ? nullptr : action_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->action.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null action in MediaControllerObserver.MediaSessionActionsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerObserver::Name_);
  message.set_method_name("MediaSessionActionsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerObserverProxy::MediaSessionChanged(
    const absl::optional<::base::UnguessableToken>& in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaControllerObserver::MediaSessionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type const absl::optional<::base::UnguessableToken>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaControllerObserver_MediaSessionChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerObserver_MediaSessionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_id)::BaseType> request_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_request_id, request_id_fragment);
  params->request_id.Set(
      request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerObserver::Name_);
  message.set_method_name("MediaSessionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaControllerObserverProxy::MediaSessionPositionChanged(
    ::media_session::mojom::blink::MediaPositionPtr in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaControllerObserver::MediaSessionPositionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type ::media_session::mojom::blink::MediaPositionPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaControllerObserver_MediaSessionPositionChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->position)::BaseType> position_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaPositionDataView>(
      in_position, position_fragment);
  params->position.Set(
      position_fragment.is_null() ? nullptr : position_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerObserver::Name_);
  message.set_method_name("MediaSessionPositionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaControllerObserverStubDispatch::Accept(
    MediaControllerObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaControllerObserver_MediaSessionInfoChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaControllerObserver::MediaSessionInfoChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaControllerObserver::MediaSessionInfoChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::blink::MediaSessionInfoPtr p_info{};
      MediaControllerObserver_MediaSessionInfoChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionInfoChanged(
std::move(p_info));
      return true;
    }
    case internal::kMediaControllerObserver_MediaSessionMetadataChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaControllerObserver::MediaSessionMetadataChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaControllerObserver::MediaSessionMetadataChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::blink::MediaMetadataPtr p_metadata{};
      MediaControllerObserver_MediaSessionMetadataChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionMetadataChanged(
std::move(p_metadata));
      return true;
    }
    case internal::kMediaControllerObserver_MediaSessionActionsChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaControllerObserver::MediaSessionActionsChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaControllerObserver::MediaSessionActionsChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::media_session::mojom::blink::MediaSessionAction> p_action{};
      MediaControllerObserver_MediaSessionActionsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionActionsChanged(
std::move(p_action));
      return true;
    }
    case internal::kMediaControllerObserver_MediaSessionChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaControllerObserver::MediaSessionChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaControllerObserver::MediaSessionChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaControllerObserver_MediaSessionChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerObserver_MediaSessionChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      absl::optional<::base::UnguessableToken> p_request_id{};
      MediaControllerObserver_MediaSessionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestId(&p_request_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionChanged(
std::move(p_request_id));
      return true;
    }
    case internal::kMediaControllerObserver_MediaSessionPositionChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaControllerObserver::MediaSessionPositionChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaControllerObserver::MediaSessionPositionChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::blink::MediaPositionPtr p_position{};
      MediaControllerObserver_MediaSessionPositionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaSessionPositionChanged(
std::move(p_position));
      return true;
    }
  }
  return false;
}

// static
bool MediaControllerObserverStubDispatch::AcceptWithResponder(
    MediaControllerObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaControllerObserver_MediaSessionInfoChanged_Name: {
      break;
    }
    case internal::kMediaControllerObserver_MediaSessionMetadataChanged_Name: {
      break;
    }
    case internal::kMediaControllerObserver_MediaSessionActionsChanged_Name: {
      break;
    }
    case internal::kMediaControllerObserver_MediaSessionChanged_Name: {
      break;
    }
    case internal::kMediaControllerObserver_MediaSessionPositionChanged_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaControllerObserverValidationInfo[] = {
    {&internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaControllerObserver_MediaSessionChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaControllerObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::blink::MediaControllerObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaControllerObserverValidationInfo);
}

const char MediaControllerImageObserver::Name_[] = "media_session.mojom.MediaControllerImageObserver";

MediaControllerImageObserverProxy::MediaControllerImageObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaControllerImageObserverProxy::MediaControllerImageChanged(
    ::media_session::mojom::blink::MediaSessionImageType in_type, ::media_session::mojom::blink::MediaImageBitmapPtr in_bitmap) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media_session::mojom::MediaControllerImageObserver::MediaControllerImageChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::media_session::mojom::blink::MediaSessionImageType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmap"), in_bitmap,
                        "<value of type ::media_session::mojom::blink::MediaImageBitmapPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kMediaControllerImageObserver_MediaControllerImageChanged_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::media_session::mojom::internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media_session::mojom::MediaSessionImageType>(
      in_type, &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->bitmap)::BaseType> bitmap_fragment(
          params.message());
  mojo::internal::Serialize<::media_session::mojom::MediaImageBitmapDataView>(
      in_bitmap, bitmap_fragment);
  params->bitmap.Set(
      bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaControllerImageObserver::Name_);
  message.set_method_name("MediaControllerImageChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaControllerImageObserverStubDispatch::Accept(
    MediaControllerImageObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kMediaControllerImageObserver_MediaControllerImageChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media_session::mojom::MediaControllerImageObserver::MediaControllerImageChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media_session::mojom::MediaControllerImageObserver::MediaControllerImageChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data* params =
          reinterpret_cast<internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::blink::MediaSessionImageType p_type{};
      ::media_session::mojom::blink::MediaImageBitmapPtr p_bitmap{};
      MediaControllerImageObserver_MediaControllerImageChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadBitmap(&p_bitmap))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaControllerImageObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaControllerImageChanged(
std::move(p_type), 
std::move(p_bitmap));
      return true;
    }
  }
  return false;
}

// static
bool MediaControllerImageObserverStubDispatch::AcceptWithResponder(
    MediaControllerImageObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaControllerImageObserver_MediaControllerImageChanged_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaControllerImageObserverValidationInfo[] = {
    {&internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaControllerImageObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media_session::mojom::blink::MediaControllerImageObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaControllerImageObserverValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace media_session

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif