// services/metrics/public/mojom/ukm_interface.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/metrics/public/mojom/ukm_interface.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/metrics/public/mojom/ukm_interface.mojom-params-data.h"
#include "services/metrics/public/mojom/ukm_interface.mojom-shared-message-ids.h"

#include "services/metrics/public/mojom/ukm_interface.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_BLINK_JUMBO_H_
#define SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_BLINK_JUMBO_H_
#endif
namespace ukm {
namespace mojom {
namespace blink {
UkmEntry::UkmEntry()
    : source_id(),
      event_hash(),
      metrics() {}

UkmEntry::UkmEntry(
    int64_t source_id_in,
    uint64_t event_hash_in,
    const WTF::HashMap<uint64_t, int64_t>& metrics_in)
    : source_id(std::move(source_id_in)),
      event_hash(std::move(event_hash_in)),
      metrics(std::move(metrics_in)) {}

UkmEntry::~UkmEntry() = default;

void UkmEntry::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_hash"), this->event_hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metrics"), this->metrics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::HashMap<uint64_t, int64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UkmEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char UkmRecorderInterface::Name_[] = "ukm.mojom.UkmRecorderInterface";

UkmRecorderInterfaceProxy::UkmRecorderInterfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UkmRecorderInterfaceProxy::AddEntry(
    UkmEntryPtr in_entry) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ukm::mojom::UkmRecorderInterface::AddEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entry"), in_entry,
                        "<value of type UkmEntryPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUkmRecorderInterface_AddEntry_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ukm::mojom::internal::UkmRecorderInterface_AddEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entry)::BaseType> entry_fragment(
          params.message());
  mojo::internal::Serialize<::ukm::mojom::UkmEntryDataView>(
      in_entry, entry_fragment);
  params->entry.Set(
      entry_fragment.is_null() ? nullptr : entry_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entry.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entry in UkmRecorderInterface.AddEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UkmRecorderInterface::Name_);
  message.set_method_name("AddEntry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void UkmRecorderInterfaceProxy::UpdateSourceURL(
    int64_t in_source_id, const WTF::String& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "ukm::mojom::UkmRecorderInterface::UpdateSourceURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kUkmRecorderInterface_UpdateSourceURL_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::ukm::mojom::internal::UkmRecorderInterface_UpdateSourceURL_Params_Data> params(
          message);
  params.Allocate();
  params->source_id = in_source_id;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in UkmRecorderInterface.UpdateSourceURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UkmRecorderInterface::Name_);
  message.set_method_name("UpdateSourceURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool UkmRecorderInterfaceStubDispatch::Accept(
    UkmRecorderInterface* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kUkmRecorderInterface_AddEntry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ukm::mojom::UkmRecorderInterface::AddEntry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ukm::mojom::UkmRecorderInterface::AddEntry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UkmRecorderInterface_AddEntry_Params_Data* params =
          reinterpret_cast<internal::UkmRecorderInterface_AddEntry_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      UkmEntryPtr p_entry{};
      UkmRecorderInterface_AddEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEntry(&p_entry))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UkmRecorderInterface::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddEntry(
std::move(p_entry));
      return true;
    }
    case internal::kUkmRecorderInterface_UpdateSourceURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)ukm::mojom::UkmRecorderInterface::UpdateSourceURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)ukm::mojom::UkmRecorderInterface::UpdateSourceURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::UkmRecorderInterface_UpdateSourceURL_Params_Data* params =
          reinterpret_cast<internal::UkmRecorderInterface_UpdateSourceURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int64_t p_source_id{};
      WTF::String p_url{};
      UkmRecorderInterface_UpdateSourceURL_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_source_id = input_data_view.source_id();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UkmRecorderInterface::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSourceURL(
std::move(p_source_id), 
std::move(p_url));
      return true;
    }
  }
  return false;
}

// static
bool UkmRecorderInterfaceStubDispatch::AcceptWithResponder(
    UkmRecorderInterface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kUkmRecorderInterface_AddEntry_Name: {
      break;
    }
    case internal::kUkmRecorderInterface_UpdateSourceURL_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUkmRecorderInterfaceValidationInfo[] = {
    {internal::kUkmRecorderInterface_AddEntry_Name,
     {&internal::UkmRecorderInterface_AddEntry_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kUkmRecorderInterface_UpdateSourceURL_Name,
     {&internal::UkmRecorderInterface_UpdateSourceURL_Params_Data::Validate,
      nullptr /* no response */}},
};

bool UkmRecorderInterfaceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::ukm::mojom::blink::UkmRecorderInterface::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUkmRecorderInterfaceValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace ukm

namespace mojo {


// static
bool StructTraits<::ukm::mojom::blink::UkmEntry::DataView, ::ukm::mojom::blink::UkmEntryPtr>::Read(
    ::ukm::mojom::blink::UkmEntry::DataView input,
    ::ukm::mojom::blink::UkmEntryPtr* output) {
  bool success = true;
  ::ukm::mojom::blink::UkmEntryPtr result(::ukm::mojom::blink::UkmEntry::New());
  
      if (success)
        result->source_id = input.source_id();
      if (success)
        result->event_hash = input.event_hash();
      if (success && !input.ReadMetrics(&result->metrics))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif