// services/network/public/mojom/accept_ch_frame_observer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/accept_ch_frame_observer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/accept_ch_frame_observer.mojom-params-data.h"
#include "services/network/public/mojom/accept_ch_frame_observer.mojom-shared-message-ids.h"

#include "services/network/public/mojom/accept_ch_frame_observer.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ACCEPT_CH_FRAME_OBSERVER_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ACCEPT_CH_FRAME_OBSERVER_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
const char AcceptCHFrameObserver::Name_[] = "network.mojom.AcceptCHFrameObserver";

class AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback(
      AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback);
};

AcceptCHFrameObserverProxy::AcceptCHFrameObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AcceptCHFrameObserverProxy::OnAcceptCHFrameReceived(
    const ::blink::KURL& in_url, const WTF::Vector<::network::mojom::blink::WebClientHintsType>& in_accept_ch_frame, OnAcceptCHFrameReceivedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::AcceptCHFrameObserver::OnAcceptCHFrameReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("accept_ch_frame"), in_accept_ch_frame,
                        "<value of type const WTF::Vector<::network::mojom::blink::WebClientHintsType>&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAcceptCHFrameObserver_OnAcceptCHFrameReceived_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in AcceptCHFrameObserver.OnAcceptCHFrameReceived request");
  mojo::internal::MessageFragment<
      typename decltype(params->accept_ch_frame)::BaseType>
      accept_ch_frame_fragment(params.message());
  const mojo::internal::ContainerValidateParams accept_ch_frame_validate_params(
      0, ::network::mojom::internal::WebClientHintsType_Data::Validate);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
      in_accept_ch_frame, accept_ch_frame_fragment, &accept_ch_frame_validate_params);
  params->accept_ch_frame.Set(
      accept_ch_frame_fragment.is_null() ? nullptr : accept_ch_frame_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->accept_ch_frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null accept_ch_frame in AcceptCHFrameObserver.OnAcceptCHFrameReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AcceptCHFrameObserver::Name_);
  message.set_method_name("OnAcceptCHFrameReceived");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void AcceptCHFrameObserverProxy::Clone(
    ::mojo::PendingReceiver<AcceptCHFrameObserver> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::AcceptCHFrameObserver::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingReceiver<AcceptCHFrameObserver>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAcceptCHFrameObserver_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::AcceptCHFrameObserver_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::AcceptCHFrameObserverInterfaceBase>>(
      in_listener, &params->listener, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in AcceptCHFrameObserver.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AcceptCHFrameObserver::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder {
 public:
  static AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder> proxy(
        new AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder);
};

bool AcceptCHFrameObserver_OnAcceptCHFrameReceived_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  int32_t p_status{};
  AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AcceptCHFrameObserver::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder::Run(
    int32_t in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type int32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kAcceptCHFrameObserver_OnAcceptCHFrameReceived_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->status = in_status;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AcceptCHFrameObserver::Name_);
  message.set_method_name("OnAcceptCHFrameReceived");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AcceptCHFrameObserverStubDispatch::Accept(
    AcceptCHFrameObserver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kAcceptCHFrameObserver_OnAcceptCHFrameReceived_Name: {
      break;
    }
    case internal::kAcceptCHFrameObserver_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::AcceptCHFrameObserver::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::AcceptCHFrameObserver::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AcceptCHFrameObserver_Clone_Params_Data* params =
          reinterpret_cast<internal::AcceptCHFrameObserver_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<AcceptCHFrameObserver> p_listener{};
      AcceptCHFrameObserver_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AcceptCHFrameObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_listener));
      return true;
    }
  }
  return false;
}

// static
bool AcceptCHFrameObserverStubDispatch::AcceptWithResponder(
    AcceptCHFrameObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAcceptCHFrameObserver_OnAcceptCHFrameReceived_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::AcceptCHFrameObserver::OnAcceptCHFrameReceived",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::AcceptCHFrameObserver::OnAcceptCHFrameReceived");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_Params_Data* params =
          reinterpret_cast<
              internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      WTF::Vector<::network::mojom::blink::WebClientHintsType> p_accept_ch_frame{};
      AcceptCHFrameObserver_OnAcceptCHFrameReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadAcceptChFrame(&p_accept_ch_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AcceptCHFrameObserver::Name_, 0, false);
        return false;
      }
      AcceptCHFrameObserver::OnAcceptCHFrameReceivedCallback callback =
          AcceptCHFrameObserver_OnAcceptCHFrameReceived_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAcceptCHFrameReceived(
std::move(p_url), 
std::move(p_accept_ch_frame), std::move(callback));
      return true;
    }
    case internal::kAcceptCHFrameObserver_Clone_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAcceptCHFrameObserverValidationInfo[] = {
    {internal::kAcceptCHFrameObserver_OnAcceptCHFrameReceived_Name,
     {&internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_Params_Data::Validate,
      &internal::AcceptCHFrameObserver_OnAcceptCHFrameReceived_ResponseParams_Data::Validate}},
    {internal::kAcceptCHFrameObserver_Clone_Name,
     {&internal::AcceptCHFrameObserver_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AcceptCHFrameObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::AcceptCHFrameObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAcceptCHFrameObserverValidationInfo);
}

bool AcceptCHFrameObserverResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::AcceptCHFrameObserver::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kAcceptCHFrameObserverValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif