// services/network/public/mojom/ct_log_info.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/ct_log_info.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/ct_log_info.mojom-params-data.h"
#include "services/network/public/mojom/ct_log_info.mojom-shared-message-ids.h"

#include "services/network/public/mojom/ct_log_info.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
CTLogInfo::CTLogInfo()
    : public_key(),
      name(),
      operated_by_google(false),
      disqualified_at() {}

CTLogInfo::CTLogInfo(
    const WTF::String& public_key_in,
    const WTF::String& name_in,
    bool operated_by_google_in,
    absl::optional<::base::TimeDelta> disqualified_at_in)
    : public_key(std::move(public_key_in)),
      name(std::move(name_in)),
      operated_by_google(std::move(operated_by_google_in)),
      disqualified_at(std::move(disqualified_at_in)) {}

CTLogInfo::~CTLogInfo() = default;

void CTLogInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_key"), this->public_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operated_by_google"), this->operated_by_google,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disqualified_at"), this->disqualified_at,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type absl::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CTLogInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::CTLogInfo::DataView, ::network::mojom::blink::CTLogInfoPtr>::Read(
    ::network::mojom::blink::CTLogInfo::DataView input,
    ::network::mojom::blink::CTLogInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::CTLogInfoPtr result(::network::mojom::blink::CTLogInfo::New());
  
      if (success && !input.ReadPublicKey(&result->public_key))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->operated_by_google = input.operated_by_google();
      if (success && !input.ReadDisqualifiedAt(&result->disqualified_at))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif