// services/network/public/mojom/devtools_observer.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/devtools_observer.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/network/public/mojom/client_security_state.mojom.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/cors.mojom.h"
#include "services/network/public/mojom/http_raw_headers.mojom.h"
#include "services/network/public/mojom/http_request_headers.mojom.h"
#include "services/network/public/mojom/ip_address_space.mojom.h"
#include "services/network/public/mojom/referrer_policy.mojom.h"
#include "services/network/public/mojom/request_priority.mojom.h"
#include "services/network/public/mojom/trust_tokens.mojom.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_JUMBO_H_
#endif


namespace network {
namespace mojom {


void DevToolsObserverInterceptorForTesting::OnRawRequest(const std::string& devtool_request_id, const std::vector<::net::CookieWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, ::network::mojom::ClientSecurityStatePtr client_security_state) {
  GetForwardingInterface()->OnRawRequest(std::move(devtool_request_id), std::move(cookies_with_access_result), std::move(headers), std::move(client_security_state));
}
void DevToolsObserverInterceptorForTesting::OnRawResponse(const std::string& devtool_request_id, const std::vector<::net::CookieAndLineWithAccessResult>& cookies_with_access_result, std::vector<::network::mojom::HttpRawHeaderPairPtr> headers, const absl::optional<std::string>& raw_response_headers, ::network::mojom::IPAddressSpace resource_address_space, int32_t http_status_code) {
  GetForwardingInterface()->OnRawResponse(std::move(devtool_request_id), std::move(cookies_with_access_result), std::move(headers), std::move(raw_response_headers), std::move(resource_address_space), std::move(http_status_code));
}
void DevToolsObserverInterceptorForTesting::OnPrivateNetworkRequest(const absl::optional<std::string>& devtool_request_id, const ::GURL& url, bool is_warning, ::network::mojom::IPAddressSpace resource_address_space, ::network::mojom::ClientSecurityStatePtr client_security_state) {
  GetForwardingInterface()->OnPrivateNetworkRequest(std::move(devtool_request_id), std::move(url), std::move(is_warning), std::move(resource_address_space), std::move(client_security_state));
}
void DevToolsObserverInterceptorForTesting::OnCorsPreflightRequest(const ::base::UnguessableToken& devtool_request_id, const ::net::HttpRequestHeaders& request_headers, URLRequestDevToolsInfoPtr request_info, const ::GURL& initiator_url, const std::string& initiator_devtool_request_id) {
  GetForwardingInterface()->OnCorsPreflightRequest(std::move(devtool_request_id), std::move(request_headers), std::move(request_info), std::move(initiator_url), std::move(initiator_devtool_request_id));
}
void DevToolsObserverInterceptorForTesting::OnCorsPreflightResponse(const ::base::UnguessableToken& devtool_request_id, const ::GURL& url, ::network::mojom::URLResponseHeadPtr head) {
  GetForwardingInterface()->OnCorsPreflightResponse(std::move(devtool_request_id), std::move(url), std::move(head));
}
void DevToolsObserverInterceptorForTesting::OnCorsPreflightRequestCompleted(const ::base::UnguessableToken& devtool_request_id, const ::network::URLLoaderCompletionStatus& status) {
  GetForwardingInterface()->OnCorsPreflightRequestCompleted(std::move(devtool_request_id), std::move(status));
}
void DevToolsObserverInterceptorForTesting::OnTrustTokenOperationDone(const std::string& devtool_request_id, ::network::mojom::TrustTokenOperationResultPtr result) {
  GetForwardingInterface()->OnTrustTokenOperationDone(std::move(devtool_request_id), std::move(result));
}
void DevToolsObserverInterceptorForTesting::OnCorsError(const absl::optional<std::string>& devtool_request_id, const absl::optional<::url::Origin>& initiator_origin, const ::GURL& url, const ::network::CorsErrorStatus& status) {
  GetForwardingInterface()->OnCorsError(std::move(devtool_request_id), std::move(initiator_origin), std::move(url), std::move(status));
}
void DevToolsObserverInterceptorForTesting::OnSubresourceWebBundleMetadata(const std::string& devtool_request_id, const std::vector<::GURL>& urls) {
  GetForwardingInterface()->OnSubresourceWebBundleMetadata(std::move(devtool_request_id), std::move(urls));
}
void DevToolsObserverInterceptorForTesting::OnSubresourceWebBundleMetadataError(const std::string& devtool_request_id, const std::string& error_message) {
  GetForwardingInterface()->OnSubresourceWebBundleMetadataError(std::move(devtool_request_id), std::move(error_message));
}
void DevToolsObserverInterceptorForTesting::OnSubresourceWebBundleInnerResponse(const std::string& inner_request_devtools_id, const ::GURL& url, const absl::optional<std::string>& bundle_request_devtools_id) {
  GetForwardingInterface()->OnSubresourceWebBundleInnerResponse(std::move(inner_request_devtools_id), std::move(url), std::move(bundle_request_devtools_id));
}
void DevToolsObserverInterceptorForTesting::OnSubresourceWebBundleInnerResponseError(const std::string& inner_request_devtools_id, const ::GURL& url, const std::string& error_message, const absl::optional<std::string>& bundle_request_devtools_id) {
  GetForwardingInterface()->OnSubresourceWebBundleInnerResponseError(std::move(inner_request_devtools_id), std::move(url), std::move(error_message), std::move(bundle_request_devtools_id));
}
void DevToolsObserverInterceptorForTesting::Clone(::mojo::PendingReceiver<DevToolsObserver> listener) {
  GetForwardingInterface()->Clone(std::move(listener));
}
DevToolsObserverAsyncWaiter::DevToolsObserverAsyncWaiter(
    DevToolsObserver* proxy) : proxy_(proxy) {}

DevToolsObserverAsyncWaiter::~DevToolsObserverAsyncWaiter() = default;






}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif