// services/network/public/mojom/network_param.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_param.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_param.mojom-params-data.h"
#include "services/network/public/mojom/network_param.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_param.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_PARAM_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_PARAM_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
AuthChallengeInfo::AuthChallengeInfo()
    : is_proxy(),
      challenger(),
      scheme(),
      realm(),
      challenge(),
      path() {}

AuthChallengeInfo::AuthChallengeInfo(
    bool is_proxy_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& challenger_in,
    const WTF::String& scheme_in,
    const WTF::String& realm_in,
    const WTF::String& challenge_in,
    const WTF::String& path_in)
    : is_proxy(std::move(is_proxy_in)),
      challenger(std::move(challenger_in)),
      scheme(std::move(scheme_in)),
      realm(std::move(realm_in)),
      challenge(std::move(challenge_in)),
      path(std::move(path_in)) {}

AuthChallengeInfo::~AuthChallengeInfo() = default;

void AuthChallengeInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_proxy"), this->is_proxy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenger"), this->challenger,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "realm"), this->realm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenge"), this->challenge,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuthChallengeInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HttpVersion::HttpVersion()
    : major_value(),
      minor_value() {}

HttpVersion::HttpVersion(
    uint16_t major_value_in,
    uint16_t minor_value_in)
    : major_value(std::move(major_value_in)),
      minor_value(std::move(minor_value_in)) {}

HttpVersion::~HttpVersion() = default;
size_t HttpVersion::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->major_value);
  seed = mojo::internal::WTFHash(seed, this->minor_value);
  return seed;
}

void HttpVersion::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "major_value"), this->major_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minor_value"), this->minor_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HttpVersion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::AuthChallengeInfo::DataView, ::network::mojom::blink::AuthChallengeInfoPtr>::Read(
    ::network::mojom::blink::AuthChallengeInfo::DataView input,
    ::network::mojom::blink::AuthChallengeInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::AuthChallengeInfoPtr result(::network::mojom::blink::AuthChallengeInfo::New());
  
      if (success)
        result->is_proxy = input.is_proxy();
      if (success && !input.ReadChallenger(&result->challenger))
        success = false;
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadRealm(&result->realm))
        success = false;
      if (success && !input.ReadChallenge(&result->challenge))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::HttpVersion::DataView, ::network::mojom::blink::HttpVersionPtr>::Read(
    ::network::mojom::blink::HttpVersion::DataView input,
    ::network::mojom::blink::HttpVersionPtr* output) {
  bool success = true;
  ::network::mojom::blink::HttpVersionPtr result(::network::mojom::blink::HttpVersion::New());
  
      if (success)
        result->major_value = input.major_value();
      if (success)
        result->minor_value = input.minor_value();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif