// services/network/public/mojom/origin_policy_manager.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/origin_policy_manager.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "services/network/public/mojom/isolation_info.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ORIGIN_POLICY_MANAGER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ORIGIN_POLICY_MANAGER_MOJOM_JUMBO_H_
#endif


namespace network {
namespace mojom {


void OriginPolicyManagerInterceptorForTesting::RetrieveOriginPolicy(const ::url::Origin& origin, const ::net::IsolationInfo& isolation_info, const absl::optional<std::string>& header_value, RetrieveOriginPolicyCallback callback) {
  GetForwardingInterface()->RetrieveOriginPolicy(std::move(origin), std::move(isolation_info), std::move(header_value), std::move(callback));
}
void OriginPolicyManagerInterceptorForTesting::AddExceptionFor(const ::url::Origin& origin) {
  GetForwardingInterface()->AddExceptionFor(std::move(origin));
}
OriginPolicyManagerAsyncWaiter::OriginPolicyManagerAsyncWaiter(
    OriginPolicyManager* proxy) : proxy_(proxy) {}

OriginPolicyManagerAsyncWaiter::~OriginPolicyManagerAsyncWaiter() = default;

void OriginPolicyManagerAsyncWaiter::RetrieveOriginPolicy(
    const ::url::Origin& origin, const ::net::IsolationInfo& isolation_info, const absl::optional<std::string>& header_value, ::network::OriginPolicy* out_origin_policy) {
  base::RunLoop loop;
  proxy_->RetrieveOriginPolicy(std::move(origin),std::move(isolation_info),std::move(header_value),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::network::OriginPolicy* out_origin_policy
,
             const ::network::OriginPolicy& origin_policy) {*out_origin_policy = std::move(origin_policy);
            loop->Quit();
          },
          &loop,
          out_origin_policy));
  loop.Run();
}





}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif