// services/network/public/mojom/p2p.mojom-blink-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/p2p.mojom-blink-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "services/network/public/mojom/network_interface.mojom-blink.h"
#include "services/network/public/mojom/ip_address.mojom-blink.h"
#include "services/network/public/mojom/ip_endpoint.mojom-blink.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-blink.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_BLINK_JUMBO_H_
#endif


namespace network {
namespace mojom {
namespace blink {


void P2PNetworkNotificationClientInterceptorForTesting::NetworkListChanged(const WTF::Vector<::net::NetworkInterface>& networks, const ::net::IPAddress& default_ipv4_local_address, const ::net::IPAddress& default_ipv6_local_address) {
  GetForwardingInterface()->NetworkListChanged(std::move(networks), std::move(default_ipv4_local_address), std::move(default_ipv6_local_address));
}
P2PNetworkNotificationClientAsyncWaiter::P2PNetworkNotificationClientAsyncWaiter(
    P2PNetworkNotificationClient* proxy) : proxy_(proxy) {}

P2PNetworkNotificationClientAsyncWaiter::~P2PNetworkNotificationClientAsyncWaiter() = default;




void P2PSocketManagerInterceptorForTesting::StartNetworkNotifications(::mojo::PendingRemote<P2PNetworkNotificationClient> client) {
  GetForwardingInterface()->StartNetworkNotifications(std::move(client));
}
void P2PSocketManagerInterceptorForTesting::GetHostAddress(const WTF::String& host_name, bool enable_mdns, GetHostAddressCallback callback) {
  GetForwardingInterface()->GetHostAddress(std::move(host_name), std::move(enable_mdns), std::move(callback));
}
void P2PSocketManagerInterceptorForTesting::CreateSocket(::network::P2PSocketType type, const ::net::IPEndPoint& local_address, const ::network::P2PPortRange& port_range, const ::network::P2PHostAndIPEndPoint& remote_address, ::mojo::PendingRemote<P2PSocketClient> client, ::mojo::PendingReceiver<P2PSocket> socket) {
  GetForwardingInterface()->CreateSocket(std::move(type), std::move(local_address), std::move(port_range), std::move(remote_address), std::move(client), std::move(socket));
}
P2PSocketManagerAsyncWaiter::P2PSocketManagerAsyncWaiter(
    P2PSocketManager* proxy) : proxy_(proxy) {}

P2PSocketManagerAsyncWaiter::~P2PSocketManagerAsyncWaiter() = default;

void P2PSocketManagerAsyncWaiter::GetHostAddress(
    const WTF::String& host_name, bool enable_mdns, WTF::Vector<::net::IPAddress>* out_addresses) {
  base::RunLoop loop;
  proxy_->GetHostAddress(std::move(host_name),std::move(enable_mdns),
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<::net::IPAddress>* out_addresses
,
             const WTF::Vector<::net::IPAddress>& addresses) {*out_addresses = std::move(addresses);
            loop->Quit();
          },
          &loop,
          out_addresses));
  loop.Run();
}



void P2PSocketInterceptorForTesting::Send(const WTF::Vector<int8_t>& data, const ::network::P2PPacketInfo& packet_info, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) {
  GetForwardingInterface()->Send(std::move(data), std::move(packet_info), std::move(traffic_annotation));
}
void P2PSocketInterceptorForTesting::SetOption(::network::P2PSocketOption option, int32_t value) {
  GetForwardingInterface()->SetOption(std::move(option), std::move(value));
}
P2PSocketAsyncWaiter::P2PSocketAsyncWaiter(
    P2PSocket* proxy) : proxy_(proxy) {}

P2PSocketAsyncWaiter::~P2PSocketAsyncWaiter() = default;




void P2PSocketClientInterceptorForTesting::SocketCreated(const ::net::IPEndPoint& local_address, const ::net::IPEndPoint& remote_address) {
  GetForwardingInterface()->SocketCreated(std::move(local_address), std::move(remote_address));
}
void P2PSocketClientInterceptorForTesting::SendComplete(const ::network::P2PSendPacketMetrics& send_metrics) {
  GetForwardingInterface()->SendComplete(std::move(send_metrics));
}
void P2PSocketClientInterceptorForTesting::IncomingTcpConnection(const ::net::IPEndPoint& socket_address, ::mojo::PendingRemote<P2PSocket> socket, ::mojo::PendingReceiver<P2PSocketClient> client) {
  GetForwardingInterface()->IncomingTcpConnection(std::move(socket_address), std::move(socket), std::move(client));
}
void P2PSocketClientInterceptorForTesting::DataReceived(const ::net::IPEndPoint& socket_address, const WTF::Vector<int8_t>& data, ::base::TimeTicks timestamp) {
  GetForwardingInterface()->DataReceived(std::move(socket_address), std::move(data), std::move(timestamp));
}
P2PSocketClientAsyncWaiter::P2PSocketClientAsyncWaiter(
    P2PSocketClient* proxy) : proxy_(proxy) {}

P2PSocketClientAsyncWaiter::~P2PSocketClientAsyncWaiter() = default;






}  // namespace blink
}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif