// services/network/public/mojom/parsed_headers.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/parsed_headers.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/parsed_headers.mojom-params-data.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared-message-ids.h"

#include "services/network/public/mojom/parsed_headers.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_HEADERS_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
ParsedHeaders::ParsedHeaders()
    : content_security_policy(),
      allow_csp_from(),
      cross_origin_embedder_policy(),
      cross_origin_opener_policy(),
      origin_agent_cluster(false),
      accept_ch(),
      accept_ch_lifetime(),
      critical_ch(),
      xfo(::network::mojom::blink::XFrameOptionsValue::kNone),
      link_headers(),
      timing_allow_origin(),
      bfcache_opt_in_unload(false),
      reporting_endpoints() {}

ParsedHeaders::ParsedHeaders(
    WTF::Vector<::network::mojom::blink::ContentSecurityPolicyPtr> content_security_policy_in,
    ::network::mojom::blink::AllowCSPFromHeaderValuePtr allow_csp_from_in,
    const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy_in,
    const ::network::CrossOriginOpenerPolicy& cross_origin_opener_policy_in,
    bool origin_agent_cluster_in,
    absl::optional<WTF::Vector<::network::mojom::blink::WebClientHintsType>> accept_ch_in,
    ::base::TimeDelta accept_ch_lifetime_in,
    absl::optional<WTF::Vector<::network::mojom::blink::WebClientHintsType>> critical_ch_in,
    ::network::mojom::blink::XFrameOptionsValue xfo_in,
    WTF::Vector<::network::mojom::blink::LinkHeaderPtr> link_headers_in,
    ::network::mojom::blink::TimingAllowOriginPtr timing_allow_origin_in,
    bool bfcache_opt_in_unload_in,
    const absl::optional<WTF::HashMap<WTF::String, WTF::String>>& reporting_endpoints_in)
    : content_security_policy(std::move(content_security_policy_in)),
      allow_csp_from(std::move(allow_csp_from_in)),
      cross_origin_embedder_policy(std::move(cross_origin_embedder_policy_in)),
      cross_origin_opener_policy(std::move(cross_origin_opener_policy_in)),
      origin_agent_cluster(std::move(origin_agent_cluster_in)),
      accept_ch(std::move(accept_ch_in)),
      accept_ch_lifetime(std::move(accept_ch_lifetime_in)),
      critical_ch(std::move(critical_ch_in)),
      xfo(std::move(xfo_in)),
      link_headers(std::move(link_headers_in)),
      timing_allow_origin(std::move(timing_allow_origin_in)),
      bfcache_opt_in_unload(std::move(bfcache_opt_in_unload_in)),
      reporting_endpoints(std::move(reporting_endpoints_in)) {}

ParsedHeaders::~ParsedHeaders() = default;

void ParsedHeaders::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_security_policy"), this->content_security_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<::network::mojom::blink::ContentSecurityPolicyPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_csp_from"), this->allow_csp_from,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::AllowCSPFromHeaderValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_embedder_policy"), this->cross_origin_embedder_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::CrossOriginEmbedderPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_opener_policy"), this->cross_origin_opener_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::CrossOriginOpenerPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin_agent_cluster"), this->origin_agent_cluster,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept_ch"), this->accept_ch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<::network::mojom::blink::WebClientHintsType>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept_ch_lifetime"), this->accept_ch_lifetime,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "critical_ch"), this->critical_ch,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::Vector<::network::mojom::blink::WebClientHintsType>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "xfo"), this->xfo,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::XFrameOptionsValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "link_headers"), this->link_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<::network::mojom::blink::LinkHeaderPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timing_allow_origin"), this->timing_allow_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::TimingAllowOriginPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bfcache_opt_in_unload"), this->bfcache_opt_in_unload,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_endpoints"), this->reporting_endpoints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<WTF::HashMap<WTF::String, WTF::String>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ParsedHeaders::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ParsedHeaders::DataView, ::network::mojom::blink::ParsedHeadersPtr>::Read(
    ::network::mojom::blink::ParsedHeaders::DataView input,
    ::network::mojom::blink::ParsedHeadersPtr* output) {
  bool success = true;
  ::network::mojom::blink::ParsedHeadersPtr result(::network::mojom::blink::ParsedHeaders::New());
  
      if (success && !input.ReadContentSecurityPolicy(&result->content_security_policy))
        success = false;
      if (success && !input.ReadAllowCspFrom(&result->allow_csp_from))
        success = false;
      if (success && !input.ReadCrossOriginEmbedderPolicy(&result->cross_origin_embedder_policy))
        success = false;
      if (success && !input.ReadCrossOriginOpenerPolicy(&result->cross_origin_opener_policy))
        success = false;
      if (success)
        result->origin_agent_cluster = input.origin_agent_cluster();
      if (success && !input.ReadAcceptCh(&result->accept_ch))
        success = false;
      if (success && !input.ReadAcceptChLifetime(&result->accept_ch_lifetime))
        success = false;
      if (success && !input.ReadCriticalCh(&result->critical_ch))
        success = false;
      if (success && !input.ReadXfo(&result->xfo))
        success = false;
      if (success && !input.ReadLinkHeaders(&result->link_headers))
        success = false;
      if (success && !input.ReadTimingAllowOrigin(&result->timing_allow_origin))
        success = false;
      if (success)
        result->bfcache_opt_in_unload = input.bfcache_opt_in_unload();
      if (success && !input.ReadReportingEndpoints(&result->reporting_endpoints))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif