// services/network/public/mojom/proxy_config_with_annotation.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/proxy_config_with_annotation.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/proxy_config_with_annotation.mojom-params-data.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom-shared-message-ids.h"

#include "services/network/public/mojom/proxy_config_with_annotation.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_WITH_ANNOTATION_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_WITH_ANNOTATION_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
ProxyConfigWithAnnotation::ProxyConfigWithAnnotation()
    : value(),
      traffic_annotation() {}

ProxyConfigWithAnnotation::ProxyConfigWithAnnotation(
    ::network::mojom::blink::ProxyConfigPtr value_in,
    const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation_in)
    : value(std::move(value_in)),
      traffic_annotation(std::move(traffic_annotation_in)) {}

ProxyConfigWithAnnotation::~ProxyConfigWithAnnotation() = default;

void ProxyConfigWithAnnotation::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::ProxyConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "traffic_annotation"), this->traffic_annotation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyConfigWithAnnotation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ProxyConfigClient::Name_[] = "network.mojom.ProxyConfigClient";

class ProxyConfigClient_FlushProxyConfig_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProxyConfigClient_FlushProxyConfig_ForwardToCallback(
      ProxyConfigClient::FlushProxyConfigCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ProxyConfigClient::FlushProxyConfigCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ProxyConfigClient_FlushProxyConfig_ForwardToCallback);
};

ProxyConfigClientProxy::ProxyConfigClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyConfigClientProxy::OnProxyConfigUpdated(
    ProxyConfigWithAnnotationPtr in_proxy_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ProxyConfigClient::OnProxyConfigUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_config"), in_proxy_config,
                        "<value of type ProxyConfigWithAnnotationPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyConfigClient_OnProxyConfigUpdated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyConfigClient_OnProxyConfigUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->proxy_config)::BaseType> proxy_config_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ProxyConfigWithAnnotationDataView>(
      in_proxy_config, proxy_config_fragment);
  params->proxy_config.Set(
      proxy_config_fragment.is_null() ? nullptr : proxy_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->proxy_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxy_config in ProxyConfigClient.OnProxyConfigUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyConfigClient::Name_);
  message.set_method_name("OnProxyConfigUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProxyConfigClientProxy::FlushProxyConfig(
    FlushProxyConfigCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::ProxyConfigClient::FlushProxyConfig");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyConfigClient_FlushProxyConfig_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyConfigClient_FlushProxyConfig_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyConfigClient::Name_);
  message.set_method_name("FlushProxyConfig");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProxyConfigClient_FlushProxyConfig_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ProxyConfigClient_FlushProxyConfig_ProxyToResponder {
 public:
  static ProxyConfigClient::FlushProxyConfigCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ProxyConfigClient_FlushProxyConfig_ProxyToResponder> proxy(
        new ProxyConfigClient_FlushProxyConfig_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ProxyConfigClient_FlushProxyConfig_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProxyConfigClient_FlushProxyConfig_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ProxyConfigClient_FlushProxyConfig_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ProxyConfigClient::FlushProxyConfigCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ProxyConfigClient_FlushProxyConfig_ProxyToResponder);
};

bool ProxyConfigClient_FlushProxyConfig_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::ProxyConfigClient::FlushProxyConfigCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ProxyConfigClient_FlushProxyConfig_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProxyConfigClient_FlushProxyConfig_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ProxyConfigClient_FlushProxyConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProxyConfigClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void ProxyConfigClient_FlushProxyConfig_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::ProxyConfigClient::FlushProxyConfigCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyConfigClient_FlushProxyConfig_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyConfigClient_FlushProxyConfig_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::ProxyConfigClient::FlushProxyConfigCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyConfigClient::Name_);
  message.set_method_name("FlushProxyConfig");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProxyConfigClientStubDispatch::Accept(
    ProxyConfigClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProxyConfigClient_OnProxyConfigUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ProxyConfigClient::OnProxyConfigUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ProxyConfigClient::OnProxyConfigUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyConfigClient_OnProxyConfigUpdated_Params_Data* params =
          reinterpret_cast<internal::ProxyConfigClient_OnProxyConfigUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ProxyConfigWithAnnotationPtr p_proxy_config{};
      ProxyConfigClient_OnProxyConfigUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProxyConfig(&p_proxy_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyConfigClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProxyConfigUpdated(
std::move(p_proxy_config));
      return true;
    }
    case internal::kProxyConfigClient_FlushProxyConfig_Name: {
      break;
    }
  }
  return false;
}

// static
bool ProxyConfigClientStubDispatch::AcceptWithResponder(
    ProxyConfigClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProxyConfigClient_OnProxyConfigUpdated_Name: {
      break;
    }
    case internal::kProxyConfigClient_FlushProxyConfig_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ProxyConfigClient::FlushProxyConfig",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ProxyConfigClient::FlushProxyConfig");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ProxyConfigClient_FlushProxyConfig_Params_Data* params =
          reinterpret_cast<
              internal::ProxyConfigClient_FlushProxyConfig_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ProxyConfigClient_FlushProxyConfig_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyConfigClient::Name_, 1, false);
        return false;
      }
      ProxyConfigClient::FlushProxyConfigCallback callback =
          ProxyConfigClient_FlushProxyConfig_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushProxyConfig(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyConfigClientValidationInfo[] = {
    {internal::kProxyConfigClient_OnProxyConfigUpdated_Name,
     {&internal::ProxyConfigClient_OnProxyConfigUpdated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProxyConfigClient_FlushProxyConfig_Name,
     {&internal::ProxyConfigClient_FlushProxyConfig_Params_Data::Validate,
      &internal::ProxyConfigClient_FlushProxyConfig_ResponseParams_Data::Validate}},
};

bool ProxyConfigClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ProxyConfigClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyConfigClientValidationInfo);
}

bool ProxyConfigClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ProxyConfigClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kProxyConfigClientValidationInfo);

}
const char ProxyConfigPollerClient::Name_[] = "network.mojom.ProxyConfigPollerClient";

ProxyConfigPollerClientProxy::ProxyConfigPollerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyConfigPollerClientProxy::OnLazyProxyConfigPoll(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::ProxyConfigPollerClient::OnLazyProxyConfigPoll");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyConfigPollerClient_OnLazyProxyConfigPoll_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyConfigPollerClient::Name_);
  message.set_method_name("OnLazyProxyConfigPoll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ProxyConfigPollerClientStubDispatch::Accept(
    ProxyConfigPollerClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProxyConfigPollerClient_OnLazyProxyConfigPoll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ProxyConfigPollerClient::OnLazyProxyConfigPoll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ProxyConfigPollerClient::OnLazyProxyConfigPoll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params_Data* params =
          reinterpret_cast<internal::ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyConfigPollerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLazyProxyConfigPoll();
      return true;
    }
  }
  return false;
}

// static
bool ProxyConfigPollerClientStubDispatch::AcceptWithResponder(
    ProxyConfigPollerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProxyConfigPollerClient_OnLazyProxyConfigPoll_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyConfigPollerClientValidationInfo[] = {
    {internal::kProxyConfigPollerClient_OnLazyProxyConfigPoll_Name,
     {&internal::ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProxyConfigPollerClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ProxyConfigPollerClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyConfigPollerClientValidationInfo);
}

const char ProxyErrorClient::Name_[] = "network.mojom.ProxyErrorClient";

ProxyErrorClientProxy::ProxyErrorClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyErrorClientProxy::OnPACScriptError(
    int32_t in_line_number, const WTF::String& in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ProxyErrorClient::OnPACScriptError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type const WTF::String&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyErrorClient_OnPACScriptError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyErrorClient_OnPACScriptError_Params_Data> params(
          message);
  params.Allocate();
  params->line_number = in_line_number;
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_details, details_fragment);
  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in ProxyErrorClient.OnPACScriptError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyErrorClient::Name_);
  message.set_method_name("OnPACScriptError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProxyErrorClientProxy::OnRequestMaybeFailedDueToProxySettings(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ProxyErrorClient::OnRequestMaybeFailedDueToProxySettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params_Data> params(
          message);
  params.Allocate();
  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyErrorClient::Name_);
  message.set_method_name("OnRequestMaybeFailedDueToProxySettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ProxyErrorClientStubDispatch::Accept(
    ProxyErrorClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProxyErrorClient_OnPACScriptError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ProxyErrorClient::OnPACScriptError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ProxyErrorClient::OnPACScriptError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyErrorClient_OnPACScriptError_Params_Data* params =
          reinterpret_cast<internal::ProxyErrorClient_OnPACScriptError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_line_number{};
      WTF::String p_details{};
      ProxyErrorClient_OnPACScriptError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_line_number = input_data_view.line_number();
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyErrorClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPACScriptError(
std::move(p_line_number), 
std::move(p_details));
      return true;
    }
    case internal::kProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ProxyErrorClient::OnRequestMaybeFailedDueToProxySettings",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ProxyErrorClient::OnRequestMaybeFailedDueToProxySettings");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params_Data* params =
          reinterpret_cast<internal::ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_net_error{};
      ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_net_error = input_data_view.net_error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyErrorClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRequestMaybeFailedDueToProxySettings(
std::move(p_net_error));
      return true;
    }
  }
  return false;
}

// static
bool ProxyErrorClientStubDispatch::AcceptWithResponder(
    ProxyErrorClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProxyErrorClient_OnPACScriptError_Name: {
      break;
    }
    case internal::kProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyErrorClientValidationInfo[] = {
    {internal::kProxyErrorClient_OnPACScriptError_Name,
     {&internal::ProxyErrorClient_OnPACScriptError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Name,
     {&internal::ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProxyErrorClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::ProxyErrorClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyErrorClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ProxyConfigWithAnnotation::DataView, ::network::mojom::blink::ProxyConfigWithAnnotationPtr>::Read(
    ::network::mojom::blink::ProxyConfigWithAnnotation::DataView input,
    ::network::mojom::blink::ProxyConfigWithAnnotationPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyConfigWithAnnotationPtr result(::network::mojom::blink::ProxyConfigWithAnnotation::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadTrafficAnnotation(&result->traffic_annotation))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif