// services/network/public/mojom/tcp_socket.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/tcp_socket.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/tcp_socket.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool TCPConnectedSocketOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPConnectedSocketOptions_Data* object = static_cast<const TCPConnectedSocketOptions_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TCPConnectedSocketOptions_Data::TCPConnectedSocketOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPBoundSocket_Listen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPBoundSocket_Listen_Params_Data* object = static_cast<const TCPBoundSocket_Listen_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->socket, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->socket,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TCPBoundSocket_Listen_Params_Data::TCPBoundSocket_Listen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPBoundSocket_Listen_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPBoundSocket_Listen_ResponseParams_Data* object = static_cast<const TCPBoundSocket_Listen_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TCPBoundSocket_Listen_ResponseParams_Data::TCPBoundSocket_Listen_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPBoundSocket_Connect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPBoundSocket_Connect_Params_Data* object = static_cast<const TCPBoundSocket_Connect_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_addr_list, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_addr_list, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->tcp_connected_socket_options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->socket, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->socket,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TCPBoundSocket_Connect_Params_Data::TCPBoundSocket_Connect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPBoundSocket_Connect_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPBoundSocket_Connect_ResponseParams_Data* object = static_cast<const TCPBoundSocket_Connect_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->peer_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->receive_stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->send_stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TCPBoundSocket_Connect_ResponseParams_Data::TCPBoundSocket_Connect_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPConnectedSocket_UpgradeToTLS_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPConnectedSocket_UpgradeToTLS_Params_Data* object = static_cast<const TCPConnectedSocket_UpgradeToTLS_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host_port_pair, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host_port_pair, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TCPConnectedSocket_UpgradeToTLS_Params_Data::TCPConnectedSocket_UpgradeToTLS_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data* object = static_cast<const TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->receive_stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->send_stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->ssl_info, validation_context))
    return false;

  return true;
}

TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data::TCPConnectedSocket_UpgradeToTLS_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPConnectedSocket_SetSendBufferSize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPConnectedSocket_SetSendBufferSize_Params_Data* object = static_cast<const TCPConnectedSocket_SetSendBufferSize_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TCPConnectedSocket_SetSendBufferSize_Params_Data::TCPConnectedSocket_SetSendBufferSize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data* object = static_cast<const TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data::TCPConnectedSocket_SetSendBufferSize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPConnectedSocket_SetReceiveBufferSize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPConnectedSocket_SetReceiveBufferSize_Params_Data* object = static_cast<const TCPConnectedSocket_SetReceiveBufferSize_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TCPConnectedSocket_SetReceiveBufferSize_Params_Data::TCPConnectedSocket_SetReceiveBufferSize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data* object = static_cast<const TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data::TCPConnectedSocket_SetReceiveBufferSize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPConnectedSocket_SetNoDelay_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPConnectedSocket_SetNoDelay_Params_Data* object = static_cast<const TCPConnectedSocket_SetNoDelay_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TCPConnectedSocket_SetNoDelay_Params_Data::TCPConnectedSocket_SetNoDelay_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPConnectedSocket_SetNoDelay_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPConnectedSocket_SetNoDelay_ResponseParams_Data* object = static_cast<const TCPConnectedSocket_SetNoDelay_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TCPConnectedSocket_SetNoDelay_ResponseParams_Data::TCPConnectedSocket_SetNoDelay_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPConnectedSocket_SetKeepAlive_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPConnectedSocket_SetKeepAlive_Params_Data* object = static_cast<const TCPConnectedSocket_SetKeepAlive_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TCPConnectedSocket_SetKeepAlive_Params_Data::TCPConnectedSocket_SetKeepAlive_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPConnectedSocket_SetKeepAlive_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPConnectedSocket_SetKeepAlive_ResponseParams_Data* object = static_cast<const TCPConnectedSocket_SetKeepAlive_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

TCPConnectedSocket_SetKeepAlive_ResponseParams_Data::TCPConnectedSocket_SetKeepAlive_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SocketObserver_OnReadError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SocketObserver_OnReadError_Params_Data* object = static_cast<const SocketObserver_OnReadError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SocketObserver_OnReadError_Params_Data::SocketObserver_OnReadError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SocketObserver_OnWriteError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SocketObserver_OnWriteError_Params_Data* object = static_cast<const SocketObserver_OnWriteError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

SocketObserver_OnWriteError_Params_Data::SocketObserver_OnWriteError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPServerSocket_Accept_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPServerSocket_Accept_Params_Data* object = static_cast<const TCPServerSocket_Accept_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TCPServerSocket_Accept_Params_Data::TCPServerSocket_Accept_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TCPServerSocket_Accept_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TCPServerSocket_Accept_ResponseParams_Data* object = static_cast<const TCPServerSocket_Accept_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->remote_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->connected_socket,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->send_stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->receive_stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TCPServerSocket_Accept_ResponseParams_Data::TCPServerSocket_Accept_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network
