// services/network/public/mojom/trust_tokens.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/trust_tokens.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/trust_tokens.mojom-params-data.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared-message-ids.h"

#include "services/network/public/mojom/trust_tokens.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
TrustTokenParams::TrustTokenParams()
    : type(),
      refresh_policy(TrustTokenRefreshPolicy::kUseCached),
      sign_request_data(TrustTokenSignRequestData::kOmit),
      include_timestamp_header(false),
      issuers(),
      additional_signed_headers(),
      possibly_unsafe_additional_signing_data() {}

TrustTokenParams::TrustTokenParams(
    TrustTokenOperationType type_in,
    TrustTokenRefreshPolicy refresh_policy_in,
    TrustTokenSignRequestData sign_request_data_in,
    bool include_timestamp_header_in,
    std::vector<::url::Origin> issuers_in,
    std::vector<std::string> additional_signed_headers_in,
    const absl::optional<std::string>& possibly_unsafe_additional_signing_data_in)
    : type(std::move(type_in)),
      refresh_policy(std::move(refresh_policy_in)),
      sign_request_data(std::move(sign_request_data_in)),
      include_timestamp_header(std::move(include_timestamp_header_in)),
      issuers(std::move(issuers_in)),
      additional_signed_headers(std::move(additional_signed_headers_in)),
      possibly_unsafe_additional_signing_data(std::move(possibly_unsafe_additional_signing_data_in)) {}

TrustTokenParams::~TrustTokenParams() = default;

void TrustTokenParams::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenOperationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "refresh_policy"), this->refresh_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenRefreshPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sign_request_data"), this->sign_request_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenSignRequestData>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_timestamp_header"), this->include_timestamp_header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuers"), this->issuers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_signed_headers"), this->additional_signed_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "possibly_unsafe_additional_signing_data"), this->possibly_unsafe_additional_signing_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustTokenParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HasTrustTokensResult::HasTrustTokensResult()
    : status(),
      has_trust_tokens() {}

HasTrustTokensResult::HasTrustTokensResult(
    TrustTokenOperationStatus status_in,
    bool has_trust_tokens_in)
    : status(std::move(status_in)),
      has_trust_tokens(std::move(has_trust_tokens_in)) {}

HasTrustTokensResult::~HasTrustTokensResult() = default;
size_t HasTrustTokensResult::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->status);
  seed = mojo::internal::Hash(seed, this->has_trust_tokens);
  return seed;
}

void HasTrustTokensResult::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenOperationStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_trust_tokens"), this->has_trust_tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HasTrustTokensResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustTokenVerificationKey::TrustTokenVerificationKey()
    : body(),
      expiry() {}

TrustTokenVerificationKey::TrustTokenVerificationKey(
    const std::string& body_in,
    ::base::Time expiry_in)
    : body(std::move(body_in)),
      expiry(std::move(expiry_in)) {}

TrustTokenVerificationKey::~TrustTokenVerificationKey() = default;

void TrustTokenVerificationKey::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiry"), this->expiry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustTokenVerificationKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustTokenKeyCommitmentResult::TrustTokenKeyCommitmentResult()
    : protocol_version(),
      id(),
      batch_size(),
      keys(),
      request_issuance_locally_on(),
      unavailable_local_operation_fallback() {}

TrustTokenKeyCommitmentResult::TrustTokenKeyCommitmentResult(
    TrustTokenProtocolVersion protocol_version_in,
    int32_t id_in,
    int32_t batch_size_in,
    std::vector<TrustTokenVerificationKeyPtr> keys_in,
    std::vector<TrustTokenKeyCommitmentResult::Os> request_issuance_locally_on_in,
    TrustTokenKeyCommitmentResult::UnavailableLocalOperationFallback unavailable_local_operation_fallback_in)
    : protocol_version(std::move(protocol_version_in)),
      id(std::move(id_in)),
      batch_size(std::move(batch_size_in)),
      keys(std::move(keys_in)),
      request_issuance_locally_on(std::move(request_issuance_locally_on_in)),
      unavailable_local_operation_fallback(std::move(unavailable_local_operation_fallback_in)) {}

TrustTokenKeyCommitmentResult::~TrustTokenKeyCommitmentResult() = default;

void TrustTokenKeyCommitmentResult::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol_version"), this->protocol_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenProtocolVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "batch_size"), this->batch_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keys"), this->keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TrustTokenVerificationKeyPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_issuance_locally_on"), this->request_issuance_locally_on,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<TrustTokenKeyCommitmentResult::Os>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unavailable_local_operation_fallback"), this->unavailable_local_operation_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenKeyCommitmentResult::UnavailableLocalOperationFallback>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustTokenKeyCommitmentResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FulfillTrustTokenIssuanceRequest::FulfillTrustTokenIssuanceRequest()
    : issuer(),
      request() {}

FulfillTrustTokenIssuanceRequest::FulfillTrustTokenIssuanceRequest(
    const ::url::Origin& issuer_in,
    const std::string& request_in)
    : issuer(std::move(issuer_in)),
      request(std::move(request_in)) {}

FulfillTrustTokenIssuanceRequest::~FulfillTrustTokenIssuanceRequest() = default;

void FulfillTrustTokenIssuanceRequest::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer"), this->issuer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request"), this->request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FulfillTrustTokenIssuanceRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FulfillTrustTokenIssuanceAnswer::FulfillTrustTokenIssuanceAnswer()
    : status(),
      response() {}

FulfillTrustTokenIssuanceAnswer::FulfillTrustTokenIssuanceAnswer(
    FulfillTrustTokenIssuanceAnswer::Status status_in,
    const std::string& response_in)
    : status(std::move(status_in)),
      response(std::move(response_in)) {}

FulfillTrustTokenIssuanceAnswer::~FulfillTrustTokenIssuanceAnswer() = default;
size_t FulfillTrustTokenIssuanceAnswer::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->status);
  seed = mojo::internal::Hash(seed, this->response);
  return seed;
}

void FulfillTrustTokenIssuanceAnswer::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FulfillTrustTokenIssuanceAnswer::Status>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response"), this->response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FulfillTrustTokenIssuanceAnswer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustTokenOperationResult::TrustTokenOperationResult()
    : type(),
      status(),
      issuer(),
      top_level_origin(),
      issued_token_count(0) {}

TrustTokenOperationResult::TrustTokenOperationResult(
    TrustTokenOperationType type_in,
    TrustTokenOperationStatus status_in,
    const absl::optional<::url::Origin>& issuer_in,
    const absl::optional<::url::Origin>& top_level_origin_in,
    int32_t issued_token_count_in)
    : type(std::move(type_in)),
      status(std::move(status_in)),
      issuer(std::move(issuer_in)),
      top_level_origin(std::move(top_level_origin_in)),
      issued_token_count(std::move(issued_token_count_in)) {}

TrustTokenOperationResult::~TrustTokenOperationResult() = default;

void TrustTokenOperationResult::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenOperationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenOperationStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer"), this->issuer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_level_origin"), this->top_level_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const absl::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issued_token_count"), this->issued_token_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustTokenOperationResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StoredTrustTokensForIssuer::StoredTrustTokensForIssuer()
    : issuer(),
      count() {}

StoredTrustTokensForIssuer::StoredTrustTokensForIssuer(
    const ::url::Origin& issuer_in,
    int32_t count_in)
    : issuer(std::move(issuer_in)),
      count(std::move(count_in)) {}

StoredTrustTokensForIssuer::~StoredTrustTokensForIssuer() = default;

void StoredTrustTokensForIssuer::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer"), this->issuer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "count"), this->count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StoredTrustTokensForIssuer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char HasTrustTokensAnswerer::Name_[] = "network.mojom.HasTrustTokensAnswerer";

class HasTrustTokensAnswerer_HasTrustTokens_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HasTrustTokensAnswerer_HasTrustTokens_ForwardToCallback(
      HasTrustTokensAnswerer::HasTrustTokensCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HasTrustTokensAnswerer::HasTrustTokensCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HasTrustTokensAnswerer_HasTrustTokens_ForwardToCallback);
};

HasTrustTokensAnswererProxy::HasTrustTokensAnswererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HasTrustTokensAnswererProxy::HasTrustTokens(
    const ::url::Origin& in_issuer, HasTrustTokensCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::HasTrustTokensAnswerer::HasTrustTokens", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("issuer"), in_issuer,
                        "<value of type const ::url::Origin&>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kHasTrustTokensAnswerer_HasTrustTokens_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::HasTrustTokensAnswerer_HasTrustTokens_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->issuer)::BaseType> issuer_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_issuer, issuer_fragment);
  params->issuer.Set(
      issuer_fragment.is_null() ? nullptr : issuer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->issuer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issuer in HasTrustTokensAnswerer.HasTrustTokens request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HasTrustTokensAnswerer::Name_);
  message.set_method_name("HasTrustTokens");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HasTrustTokensAnswerer_HasTrustTokens_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder {
 public:
  static HasTrustTokensAnswerer::HasTrustTokensCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder> proxy(
        new HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HasTrustTokensAnswerer::HasTrustTokensCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      HasTrustTokensResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder);
};

bool HasTrustTokensAnswerer_HasTrustTokens_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::HasTrustTokensAnswerer::HasTrustTokensCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  HasTrustTokensResultPtr p_result{};
  HasTrustTokensAnswerer_HasTrustTokens_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HasTrustTokensAnswerer::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder::Run(
    HasTrustTokensResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::HasTrustTokensAnswerer::HasTrustTokensCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type HasTrustTokensResultPtr>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kHasTrustTokensAnswerer_HasTrustTokens_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HasTrustTokensResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::HasTrustTokensAnswerer::HasTrustTokensCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HasTrustTokensAnswerer::Name_);
  message.set_method_name("HasTrustTokens");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HasTrustTokensAnswererStubDispatch::Accept(
    HasTrustTokensAnswerer* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kHasTrustTokensAnswerer_HasTrustTokens_Name: {
      break;
    }
  }
  return false;
}

// static
bool HasTrustTokensAnswererStubDispatch::AcceptWithResponder(
    HasTrustTokensAnswerer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kHasTrustTokensAnswerer_HasTrustTokens_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::HasTrustTokensAnswerer::HasTrustTokens",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::HasTrustTokensAnswerer::HasTrustTokens");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HasTrustTokensAnswerer_HasTrustTokens_Params_Data* params =
          reinterpret_cast<
              internal::HasTrustTokensAnswerer_HasTrustTokens_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_issuer{};
      HasTrustTokensAnswerer_HasTrustTokens_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIssuer(&p_issuer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HasTrustTokensAnswerer::Name_, 0, false);
        return false;
      }
      HasTrustTokensAnswerer::HasTrustTokensCallback callback =
          HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasTrustTokens(
std::move(p_issuer), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kHasTrustTokensAnswererValidationInfo[] = {
    {internal::kHasTrustTokensAnswerer_HasTrustTokens_Name,
     {&internal::HasTrustTokensAnswerer_HasTrustTokens_Params_Data::Validate,
      &internal::HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data::Validate}},
};

bool HasTrustTokensAnswererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::HasTrustTokensAnswerer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kHasTrustTokensAnswererValidationInfo);
}

bool HasTrustTokensAnswererResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::HasTrustTokensAnswerer::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kHasTrustTokensAnswererValidationInfo);

}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::TrustTokenParams::DataView, ::network::mojom::TrustTokenParamsPtr>::Read(
    ::network::mojom::TrustTokenParams::DataView input,
    ::network::mojom::TrustTokenParamsPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenParamsPtr result(::network::mojom::TrustTokenParams::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadRefreshPolicy(&result->refresh_policy))
        success = false;
      if (success && !input.ReadSignRequestData(&result->sign_request_data))
        success = false;
      if (success)
        result->include_timestamp_header = input.include_timestamp_header();
      if (success && !input.ReadIssuers(&result->issuers))
        success = false;
      if (success && !input.ReadAdditionalSignedHeaders(&result->additional_signed_headers))
        success = false;
      if (success && !input.ReadPossiblyUnsafeAdditionalSigningData(&result->possibly_unsafe_additional_signing_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::HasTrustTokensResult::DataView, ::network::mojom::HasTrustTokensResultPtr>::Read(
    ::network::mojom::HasTrustTokensResult::DataView input,
    ::network::mojom::HasTrustTokensResultPtr* output) {
  bool success = true;
  ::network::mojom::HasTrustTokensResultPtr result(::network::mojom::HasTrustTokensResult::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success)
        result->has_trust_tokens = input.has_trust_tokens();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TrustTokenVerificationKey::DataView, ::network::mojom::TrustTokenVerificationKeyPtr>::Read(
    ::network::mojom::TrustTokenVerificationKey::DataView input,
    ::network::mojom::TrustTokenVerificationKeyPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenVerificationKeyPtr result(::network::mojom::TrustTokenVerificationKey::New());
  
      if (success && !input.ReadBody(&result->body))
        success = false;
      if (success && !input.ReadExpiry(&result->expiry))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TrustTokenKeyCommitmentResult::DataView, ::network::mojom::TrustTokenKeyCommitmentResultPtr>::Read(
    ::network::mojom::TrustTokenKeyCommitmentResult::DataView input,
    ::network::mojom::TrustTokenKeyCommitmentResultPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenKeyCommitmentResultPtr result(::network::mojom::TrustTokenKeyCommitmentResult::New());
  
      if (success && !input.ReadProtocolVersion(&result->protocol_version))
        success = false;
      if (success)
        result->id = input.id();
      if (success)
        result->batch_size = input.batch_size();
      if (success && !input.ReadKeys(&result->keys))
        success = false;
      if (success && !input.ReadRequestIssuanceLocallyOn(&result->request_issuance_locally_on))
        success = false;
      if (success && !input.ReadUnavailableLocalOperationFallback(&result->unavailable_local_operation_fallback))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::FulfillTrustTokenIssuanceRequest::DataView, ::network::mojom::FulfillTrustTokenIssuanceRequestPtr>::Read(
    ::network::mojom::FulfillTrustTokenIssuanceRequest::DataView input,
    ::network::mojom::FulfillTrustTokenIssuanceRequestPtr* output) {
  bool success = true;
  ::network::mojom::FulfillTrustTokenIssuanceRequestPtr result(::network::mojom::FulfillTrustTokenIssuanceRequest::New());
  
      if (success && !input.ReadIssuer(&result->issuer))
        success = false;
      if (success && !input.ReadRequest(&result->request))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::FulfillTrustTokenIssuanceAnswer::DataView, ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr>::Read(
    ::network::mojom::FulfillTrustTokenIssuanceAnswer::DataView input,
    ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr* output) {
  bool success = true;
  ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr result(::network::mojom::FulfillTrustTokenIssuanceAnswer::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadResponse(&result->response))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TrustTokenOperationResult::DataView, ::network::mojom::TrustTokenOperationResultPtr>::Read(
    ::network::mojom::TrustTokenOperationResult::DataView input,
    ::network::mojom::TrustTokenOperationResultPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenOperationResultPtr result(::network::mojom::TrustTokenOperationResult::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadIssuer(&result->issuer))
        success = false;
      if (success && !input.ReadTopLevelOrigin(&result->top_level_origin))
        success = false;
      if (success)
        result->issued_token_count = input.issued_token_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::StoredTrustTokensForIssuer::DataView, ::network::mojom::StoredTrustTokensForIssuerPtr>::Read(
    ::network::mojom::StoredTrustTokensForIssuer::DataView input,
    ::network::mojom::StoredTrustTokensForIssuerPtr* output) {
  bool success = true;
  ::network::mojom::StoredTrustTokensForIssuerPtr result(::network::mojom::StoredTrustTokensForIssuer::New());
  
      if (success && !input.ReadIssuer(&result->issuer))
        success = false;
      if (success)
        result->count = input.count();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif