// services/network/public/mojom/url_loader.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/url_loader.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_loader.mojom-params-data.h"
#include "services/network/public/mojom/url_loader.mojom-shared-message-ids.h"

#include "services/network/public/mojom/url_loader.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
URLLoaderClientEndpoints::URLLoaderClientEndpoints()
    : url_loader(),
      url_loader_client() {}

URLLoaderClientEndpoints::URLLoaderClientEndpoints(
    ::mojo::PendingRemote<URLLoader> url_loader_in,
    ::mojo::PendingReceiver<URLLoaderClient> url_loader_client_in)
    : url_loader(std::move(url_loader_in)),
      url_loader_client(std::move(url_loader_client_in)) {}

URLLoaderClientEndpoints::~URLLoaderClientEndpoints() = default;

void URLLoaderClientEndpoints::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_loader"), this->url_loader,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<URLLoader>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url_loader_client"), this->url_loader_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<URLLoaderClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool URLLoaderClientEndpoints::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char URLLoader::Name_[] = "network.mojom.URLLoader";
constexpr uint32_t URLLoader::kClientDisconnectReason;

URLLoaderProxy::URLLoaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderProxy::FollowRedirect(
    const std::vector<std::string>& in_removed_headers, const ::net::HttpRequestHeaders& in_modified_headers, const ::net::HttpRequestHeaders& in_modified_cors_exempt_headers, const absl::optional<::GURL>& in_new_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoader::FollowRedirect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("removed_headers"), in_removed_headers,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modified_headers"), in_modified_headers,
                        "<value of type const ::net::HttpRequestHeaders&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modified_cors_exempt_headers"), in_modified_cors_exempt_headers,
                        "<value of type const ::net::HttpRequestHeaders&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_url"), in_new_url,
                        "<value of type const absl::optional<::GURL>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoader_FollowRedirect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoader_FollowRedirect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->removed_headers)::BaseType>
      removed_headers_fragment(params.message());
  const mojo::internal::ContainerValidateParams removed_headers_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_removed_headers, removed_headers_fragment, &removed_headers_validate_params);
  params->removed_headers.Set(
      removed_headers_fragment.is_null() ? nullptr : removed_headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->removed_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null removed_headers in URLLoader.FollowRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->modified_headers)::BaseType> modified_headers_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_modified_headers, modified_headers_fragment);
  params->modified_headers.Set(
      modified_headers_fragment.is_null() ? nullptr : modified_headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->modified_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null modified_headers in URLLoader.FollowRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->modified_cors_exempt_headers)::BaseType> modified_cors_exempt_headers_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_modified_cors_exempt_headers, modified_cors_exempt_headers_fragment);
  params->modified_cors_exempt_headers.Set(
      modified_cors_exempt_headers_fragment.is_null() ? nullptr : modified_cors_exempt_headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->modified_cors_exempt_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null modified_cors_exempt_headers in URLLoader.FollowRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_url)::BaseType> new_url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_new_url, new_url_fragment);
  params->new_url.Set(
      new_url_fragment.is_null() ? nullptr : new_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("FollowRedirect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderProxy::SetPriority(
    ::net::RequestPriority in_priority, int32_t in_intra_priority_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoader::SetPriority", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type ::net::RequestPriority>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intra_priority_value"), in_intra_priority_value,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoader_SetPriority_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoader_SetPriority_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::RequestPriority>(
      in_priority, &params->priority);
  params->intra_priority_value = in_intra_priority_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("SetPriority");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderProxy::PauseReadingBodyFromNet(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::URLLoader::PauseReadingBodyFromNet");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoader_PauseReadingBodyFromNet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoader_PauseReadingBodyFromNet_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("PauseReadingBodyFromNet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderProxy::ResumeReadingBodyFromNet(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::URLLoader::ResumeReadingBodyFromNet");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoader_ResumeReadingBodyFromNet_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoader_ResumeReadingBodyFromNet_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoader::Name_);
  message.set_method_name("ResumeReadingBodyFromNet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool URLLoaderStubDispatch::Accept(
    URLLoader* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kURLLoader_FollowRedirect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::FollowRedirect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::FollowRedirect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_FollowRedirect_Params_Data* params =
          reinterpret_cast<internal::URLLoader_FollowRedirect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<std::string> p_removed_headers{};
      ::net::HttpRequestHeaders p_modified_headers{};
      ::net::HttpRequestHeaders p_modified_cors_exempt_headers{};
      absl::optional<::GURL> p_new_url{};
      URLLoader_FollowRedirect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRemovedHeaders(&p_removed_headers))
        success = false;
      if (success && !input_data_view.ReadModifiedHeaders(&p_modified_headers))
        success = false;
      if (success && !input_data_view.ReadModifiedCorsExemptHeaders(&p_modified_cors_exempt_headers))
        success = false;
      if (success && !input_data_view.ReadNewUrl(&p_new_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FollowRedirect(
std::move(p_removed_headers), 
std::move(p_modified_headers), 
std::move(p_modified_cors_exempt_headers), 
std::move(p_new_url));
      return true;
    }
    case internal::kURLLoader_SetPriority_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::SetPriority",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::SetPriority");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_SetPriority_Params_Data* params =
          reinterpret_cast<internal::URLLoader_SetPriority_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::RequestPriority p_priority{};
      int32_t p_intra_priority_value{};
      URLLoader_SetPriority_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (success)
        p_intra_priority_value = input_data_view.intra_priority_value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPriority(
std::move(p_priority), 
std::move(p_intra_priority_value));
      return true;
    }
    case internal::kURLLoader_PauseReadingBodyFromNet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::PauseReadingBodyFromNet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::PauseReadingBodyFromNet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_PauseReadingBodyFromNet_Params_Data* params =
          reinterpret_cast<internal::URLLoader_PauseReadingBodyFromNet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      URLLoader_PauseReadingBodyFromNet_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PauseReadingBodyFromNet();
      return true;
    }
    case internal::kURLLoader_ResumeReadingBodyFromNet_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoader::ResumeReadingBodyFromNet",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoader::ResumeReadingBodyFromNet");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoader_ResumeReadingBodyFromNet_Params_Data* params =
          reinterpret_cast<internal::URLLoader_ResumeReadingBodyFromNet_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      URLLoader_ResumeReadingBodyFromNet_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoader::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResumeReadingBodyFromNet();
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderStubDispatch::AcceptWithResponder(
    URLLoader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kURLLoader_FollowRedirect_Name: {
      break;
    }
    case internal::kURLLoader_SetPriority_Name: {
      break;
    }
    case internal::kURLLoader_PauseReadingBodyFromNet_Name: {
      break;
    }
    case internal::kURLLoader_ResumeReadingBodyFromNet_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderValidationInfo[] = {
    {internal::kURLLoader_FollowRedirect_Name,
     {&internal::URLLoader_FollowRedirect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoader_SetPriority_Name,
     {&internal::URLLoader_SetPriority_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoader_PauseReadingBodyFromNet_Name,
     {&internal::URLLoader_PauseReadingBodyFromNet_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoader_ResumeReadingBodyFromNet_Name,
     {&internal::URLLoader_ResumeReadingBodyFromNet_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::URLLoader::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kURLLoaderValidationInfo);
}

const char URLLoaderClient::Name_[] = "network.mojom.URLLoaderClient";

class URLLoaderClient_OnUploadProgress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  URLLoaderClient_OnUploadProgress_ForwardToCallback(
      URLLoaderClient::OnUploadProgressCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  URLLoaderClient::OnUploadProgressCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(URLLoaderClient_OnUploadProgress_ForwardToCallback);
};

URLLoaderClientProxy::URLLoaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void URLLoaderClientProxy::OnReceiveEarlyHints(
    ::network::mojom::EarlyHintsPtr in_early_hints) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnReceiveEarlyHints", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("early_hints"), in_early_hints,
                        "<value of type ::network::mojom::EarlyHintsPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnReceiveEarlyHints_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnReceiveEarlyHints_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->early_hints)::BaseType> early_hints_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::EarlyHintsDataView>(
      in_early_hints, early_hints_fragment);
  params->early_hints.Set(
      early_hints_fragment.is_null() ? nullptr : early_hints_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->early_hints.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null early_hints in URLLoaderClient.OnReceiveEarlyHints request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveEarlyHints");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnReceiveResponse(
    ::network::mojom::URLResponseHeadPtr in_head) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnReceiveResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head"), in_head,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnReceiveResponse_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnReceiveResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->head)::BaseType> head_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_head, head_fragment);
  params->head.Set(
      head_fragment.is_null() ? nullptr : head_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null head in URLLoaderClient.OnReceiveResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnReceiveRedirect(
    const ::net::RedirectInfo& in_redirect_info, ::network::mojom::URLResponseHeadPtr in_head) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnReceiveRedirect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("redirect_info"), in_redirect_info,
                        "<value of type const ::net::RedirectInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("head"), in_head,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnReceiveRedirect_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnReceiveRedirect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->redirect_info)::BaseType> redirect_info_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLRequestRedirectInfoDataView>(
      in_redirect_info, redirect_info_fragment);
  params->redirect_info.Set(
      redirect_info_fragment.is_null() ? nullptr : redirect_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->redirect_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null redirect_info in URLLoaderClient.OnReceiveRedirect request");
  mojo::internal::MessageFragment<
      typename decltype(params->head)::BaseType> head_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_head, head_fragment);
  params->head.Set(
      head_fragment.is_null() ? nullptr : head_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null head in URLLoaderClient.OnReceiveRedirect request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveRedirect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnUploadProgress(
    int64_t in_current_position, int64_t in_total_size, OnUploadProgressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnUploadProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_position"), in_current_position,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_size"), in_total_size,
                        "<value of type int64_t>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnUploadProgress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnUploadProgress_Params_Data> params(
          message);
  params.Allocate();
  params->current_position = in_current_position;
  params->total_size = in_total_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnUploadProgress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new URLLoaderClient_OnUploadProgress_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void URLLoaderClientProxy::OnReceiveCachedMetadata(
    ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnReceiveCachedMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnReceiveCachedMetadata_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
      in_data, data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in URLLoaderClient.OnReceiveCachedMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnReceiveCachedMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnTransferSizeUpdated(
    int32_t in_transfer_size_diff) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnTransferSizeUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transfer_size_diff"), in_transfer_size_diff,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnTransferSizeUpdated_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data> params(
          message);
  params.Allocate();
  params->transfer_size_diff = in_transfer_size_diff;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnTransferSizeUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnStartLoadingResponseBody(
    ::mojo::ScopedDataPipeConsumerHandle in_body) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnStartLoadingResponseBody", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("body"), in_body,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnStartLoadingResponseBody_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_body, &params->body, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->body),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid body in URLLoaderClient.OnStartLoadingResponseBody request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnStartLoadingResponseBody");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void URLLoaderClientProxy::OnComplete(
    const ::network::URLLoaderCompletionStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::URLLoaderClient::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type const ::network::URLLoaderCompletionStatus&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnComplete_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
      in_status, status_fragment);
  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in URLLoaderClient.OnComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class URLLoaderClient_OnUploadProgress_ProxyToResponder {
 public:
  static URLLoaderClient::OnUploadProgressCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<URLLoaderClient_OnUploadProgress_ProxyToResponder> proxy(
        new URLLoaderClient_OnUploadProgress_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&URLLoaderClient_OnUploadProgress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~URLLoaderClient_OnUploadProgress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  URLLoaderClient_OnUploadProgress_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "URLLoaderClient::OnUploadProgressCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(URLLoaderClient_OnUploadProgress_ProxyToResponder);
};

bool URLLoaderClient_OnUploadProgress_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::URLLoaderClient::OnUploadProgressCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  URLLoaderClient_OnUploadProgress_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        URLLoaderClient::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void URLLoaderClient_OnUploadProgress_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::URLLoaderClient::OnUploadProgressCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kURLLoaderClient_OnUploadProgress_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data> params(
          message);
  params.Allocate();

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::URLLoaderClient::OnUploadProgressCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(URLLoaderClient::Name_);
  message.set_method_name("OnUploadProgress");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool URLLoaderClientStubDispatch::Accept(
    URLLoaderClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kURLLoaderClient_OnReceiveEarlyHints_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnReceiveEarlyHints",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnReceiveEarlyHints");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveEarlyHints_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveEarlyHints_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::EarlyHintsPtr p_early_hints{};
      URLLoaderClient_OnReceiveEarlyHints_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEarlyHints(&p_early_hints))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveEarlyHints(
std::move(p_early_hints));
      return true;
    }
    case internal::kURLLoaderClient_OnReceiveResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnReceiveResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnReceiveResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveResponse_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::mojom::URLResponseHeadPtr p_head{};
      URLLoaderClient_OnReceiveResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveResponse(
std::move(p_head));
      return true;
    }
    case internal::kURLLoaderClient_OnReceiveRedirect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnReceiveRedirect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnReceiveRedirect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveRedirect_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveRedirect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::RedirectInfo p_redirect_info{};
      ::network::mojom::URLResponseHeadPtr p_head{};
      URLLoaderClient_OnReceiveRedirect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRedirectInfo(&p_redirect_info))
        success = false;
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveRedirect(
std::move(p_redirect_info), 
std::move(p_head));
      return true;
    }
    case internal::kURLLoaderClient_OnUploadProgress_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnReceiveCachedMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnReceiveCachedMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnReceiveCachedMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      URLLoaderClient_OnReceiveCachedMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReceiveCachedMetadata(
std::move(p_data));
      return true;
    }
    case internal::kURLLoaderClient_OnTransferSizeUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnTransferSizeUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnTransferSizeUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_transfer_size_diff{};
      URLLoaderClient_OnTransferSizeUpdated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transfer_size_diff = input_data_view.transfer_size_diff();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTransferSizeUpdated(
std::move(p_transfer_size_diff));
      return true;
    }
    case internal::kURLLoaderClient_OnStartLoadingResponseBody_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnStartLoadingResponseBody",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnStartLoadingResponseBody");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_body{};
      URLLoaderClient_OnStartLoadingResponseBody_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_body = input_data_view.TakeBody();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStartLoadingResponseBody(
std::move(p_body));
      return true;
    }
    case internal::kURLLoaderClient_OnComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::URLLoaderClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::URLLoaderClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::URLLoaderCompletionStatus p_status{};
      URLLoaderClient_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(
std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool URLLoaderClientStubDispatch::AcceptWithResponder(
    URLLoaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kURLLoaderClient_OnReceiveEarlyHints_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnReceiveResponse_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnReceiveRedirect_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnUploadProgress_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::URLLoaderClient::OnUploadProgress",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::URLLoaderClient::OnUploadProgress");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::URLLoaderClient_OnUploadProgress_Params_Data* params =
          reinterpret_cast<
              internal::URLLoaderClient_OnUploadProgress_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_current_position{};
      int64_t p_total_size{};
      URLLoaderClient_OnUploadProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_current_position = input_data_view.current_position();
      if (success)
        p_total_size = input_data_view.total_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            URLLoaderClient::Name_, 3, false);
        return false;
      }
      URLLoaderClient::OnUploadProgressCallback callback =
          URLLoaderClient_OnUploadProgress_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnUploadProgress(
std::move(p_current_position), 
std::move(p_total_size), std::move(callback));
      return true;
    }
    case internal::kURLLoaderClient_OnReceiveCachedMetadata_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnTransferSizeUpdated_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnStartLoadingResponseBody_Name: {
      break;
    }
    case internal::kURLLoaderClient_OnComplete_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kURLLoaderClientValidationInfo[] = {
    {internal::kURLLoaderClient_OnReceiveEarlyHints_Name,
     {&internal::URLLoaderClient_OnReceiveEarlyHints_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnReceiveResponse_Name,
     {&internal::URLLoaderClient_OnReceiveResponse_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnReceiveRedirect_Name,
     {&internal::URLLoaderClient_OnReceiveRedirect_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnUploadProgress_Name,
     {&internal::URLLoaderClient_OnUploadProgress_Params_Data::Validate,
      &internal::URLLoaderClient_OnUploadProgress_ResponseParams_Data::Validate}},
    {internal::kURLLoaderClient_OnReceiveCachedMetadata_Name,
     {&internal::URLLoaderClient_OnReceiveCachedMetadata_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnTransferSizeUpdated_Name,
     {&internal::URLLoaderClient_OnTransferSizeUpdated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnStartLoadingResponseBody_Name,
     {&internal::URLLoaderClient_OnStartLoadingResponseBody_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kURLLoaderClient_OnComplete_Name,
     {&internal::URLLoaderClient_OnComplete_Params_Data::Validate,
      nullptr /* no response */}},
};

bool URLLoaderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::URLLoaderClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kURLLoaderClientValidationInfo);
}

bool URLLoaderClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::URLLoaderClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kURLLoaderClientValidationInfo);

}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::URLLoaderClientEndpoints::DataView, ::network::mojom::URLLoaderClientEndpointsPtr>::Read(
    ::network::mojom::URLLoaderClientEndpoints::DataView input,
    ::network::mojom::URLLoaderClientEndpointsPtr* output) {
  bool success = true;
  ::network::mojom::URLLoaderClientEndpointsPtr result(::network::mojom::URLLoaderClientEndpoints::New());
  
      if (success) {
        result->url_loader =
            input.TakeUrlLoader<decltype(result->url_loader)>();
      }
      if (success) {
        result->url_loader_client =
            input.TakeUrlLoaderClient<decltype(result->url_loader_client)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif