// services/network/public/mojom/url_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/url_request.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/url_request.mojom-params-data.h"
namespace network {
namespace mojom {

static NOINLINE const char* SourceTypeToStringHelper(SourceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SourceType::kBrotli:
      return "kBrotli";
    case SourceType::kDeflate:
      return "kDeflate";
    case SourceType::kGzip:
      return "kGzip";
    case SourceType::kNone:
      return "kNone";
    case SourceType::kUnknown:
      return "kUnknown";
    default:
      return nullptr;
  }
}

std::string SourceTypeToString(SourceType value) {
  const char *str = SourceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SourceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SourceType value) {
  return os << SourceTypeToString(value);
}

namespace internal {
// static
bool DataElement_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DataElement_Data* object = static_cast<const DataElement_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DataElement_Tag::BYTES: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bytes, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_bytes, validation_context))
        return false;
      return true;
    }
    case DataElement_Tag::FILE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_file, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_file, validation_context))
        return false;
      return true;
    }
    case DataElement_Tag::DATA_PIPE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_data_pipe, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_data_pipe, validation_context))
        return false;
      return true;
    }
    case DataElement_Tag::CHUNKED_DATA_PIPE: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_chunked_data_pipe, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_chunked_data_pipe, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DataElement");
      return false;
    }
  }
}


// static
bool TrustedUrlRequestParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const TrustedUrlRequestParams_Data* object = static_cast<const TrustedUrlRequestParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->isolation_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->isolation_info, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->cookie_observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_network_observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->devtools_observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->client_security_state, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->accept_ch_frame_observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TrustedUrlRequestParams_Data::TrustedUrlRequestParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleTokenParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebBundleTokenParams_Data* object = static_cast<const WebBundleTokenParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bundle_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bundle_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->web_bundle_handle,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebBundleTokenParams_Data::WebBundleTokenParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 224, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLRequest_Data* object = static_cast<const URLRequest_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request_initiator, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_redirect_chain, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams navigation_redirect_chain_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->navigation_redirect_chain, validation_context,
                                         &navigation_redirect_chain_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->isolated_world_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;


  if (!::network::mojom::internal::URLRequestReferrerPolicy_Data
        ::Validate(object->referrer_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cors_exempt_headers, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cors_exempt_headers, validation_context))
    return false;


  if (!::network::mojom::internal::RequestPriority_Data
        ::Validate(object->priority, validation_context))
    return false;


  if (!::network::mojom::internal::CorsPreflightPolicy_Data
        ::Validate(object->cors_preflight_policy, validation_context))
    return false;


  if (!::network::mojom::internal::RequestMode_Data
        ::Validate(object->mode, validation_context))
    return false;


  if (!::network::mojom::internal::CredentialsMode_Data
        ::Validate(object->credentials_mode, validation_context))
    return false;


  if (!::network::mojom::internal::RedirectMode_Data
        ::Validate(object->redirect_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fetch_integrity, 24, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fetch_integrity_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->fetch_integrity, validation_context,
                                         &fetch_integrity_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->destination, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->request_body, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->throttling_profile_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->fetch_window_id, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams devtools_request_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtools_request_id, validation_context,
                                         &devtools_request_id_validate_params)) {
    return false;
  }

  const mojo::internal::ContainerValidateParams devtools_stack_id_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->devtools_stack_id, validation_context,
                                         &devtools_stack_id_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->original_destination, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trusted_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->recursive_prefetch_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trust_token_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->web_bundle_token_params, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams devtools_accepted_stream_types_validate_params(
      0, ::network::mojom::internal::SourceType_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->devtools_accepted_stream_types, validation_context,
                                         &devtools_accepted_stream_types_validate_params)) {
    return false;
  }

  return true;
}

URLRequest_Data::URLRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLRequestBody_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const URLRequestBody_Data* object = static_cast<const URLRequestBody_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->elements, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams elements_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->elements, validation_context,
                                         &elements_validate_params)) {
    return false;
  }

  return true;
}

URLRequestBody_Data::URLRequestBody_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataElementBytes_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DataElementBytes_Data* object = static_cast<const DataElementBytes_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

DataElementBytes_Data::DataElementBytes_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataElementFile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DataElementFile_Data* object = static_cast<const DataElementFile_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expected_modification_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expected_modification_time, validation_context))
    return false;

  return true;
}

DataElementFile_Data::DataElementFile_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataElementDataPipe_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DataElementDataPipe_Data* object = static_cast<const DataElementDataPipe_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->data_pipe_getter, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->data_pipe_getter,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DataElementDataPipe_Data::DataElementDataPipe_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataElementChunkedDataPipe_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const DataElementChunkedDataPipe_Data* object = static_cast<const DataElementChunkedDataPipe_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->data_pipe_getter, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->data_pipe_getter,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DataElementChunkedDataPipe_Data::DataElementChunkedDataPipe_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SourceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::SourceType value) {
  return std::move(context).WriteString(::network::mojom::SourceTypeToString(value));
}

} // namespace perfetto
