// services/network/public/mojom/web_bundle_handle.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/web_bundle_handle.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/web_bundle_handle.mojom-params-data.h"
namespace network {
namespace mojom {

static NOINLINE const char* WebBundleErrorTypeToStringHelper(WebBundleErrorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebBundleErrorType::kMetadataParseError:
      return "kMetadataParseError";
    case WebBundleErrorType::kResponseParseError:
      return "kResponseParseError";
    case WebBundleErrorType::kResourceNotFound:
      return "kResourceNotFound";
    case WebBundleErrorType::kMemoryQuotaExceeded:
      return "kMemoryQuotaExceeded";
    case WebBundleErrorType::kServingConstraintsNotMet:
      return "kServingConstraintsNotMet";
    case WebBundleErrorType::kWebBundleFetchFailed:
      return "kWebBundleFetchFailed";
    default:
      return nullptr;
  }
}

std::string WebBundleErrorTypeToString(WebBundleErrorType value) {
  const char *str = WebBundleErrorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebBundleErrorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebBundleErrorType value) {
  return os << WebBundleErrorTypeToString(value);
}

namespace internal {


// static
bool WebBundleHandle_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebBundleHandle_Clone_Params_Data* object = static_cast<const WebBundleHandle_Clone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebBundleHandle_Clone_Params_Data::WebBundleHandle_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleHandle_OnWebBundleError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebBundleHandle_OnWebBundleError_Params_Data* object = static_cast<const WebBundleHandle_OnWebBundleError_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::network::mojom::internal::WebBundleErrorType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams message_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

WebBundleHandle_OnWebBundleError_Params_Data::WebBundleHandle_OnWebBundleError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebBundleHandle_OnWebBundleLoadFinished_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebBundleHandle_OnWebBundleLoadFinished_Params_Data* object = static_cast<const WebBundleHandle_OnWebBundleLoadFinished_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  return true;
}

WebBundleHandle_OnWebBundleLoadFinished_Params_Data::WebBundleHandle_OnWebBundleLoadFinished_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::WebBundleErrorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::WebBundleErrorType value) {
  return std::move(context).WriteString(::network::mojom::WebBundleErrorTypeToString(value));
}

} // namespace perfetto
