// services/network/public/mojom/web_bundle_handle.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/web_bundle_handle.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/web_bundle_handle.mojom-params-data.h"
#include "services/network/public/mojom/web_bundle_handle.mojom-shared-message-ids.h"

#include "services/network/public/mojom/web_bundle_handle.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEB_BUNDLE_HANDLE_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEB_BUNDLE_HANDLE_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
const char WebBundleHandle::Name_[] = "network.mojom.WebBundleHandle";

WebBundleHandleProxy::WebBundleHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebBundleHandleProxy::Clone(
    ::mojo::PendingReceiver<WebBundleHandle> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebBundleHandle::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<WebBundleHandle>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebBundleHandle_Clone_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebBundleHandle_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::WebBundleHandleInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in WebBundleHandle.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleHandle::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebBundleHandleProxy::OnWebBundleError(
    WebBundleErrorType in_type, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebBundleHandle::OnWebBundleError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type WebBundleErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebBundleHandle_OnWebBundleError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebBundleHandle_OnWebBundleError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::network::mojom::WebBundleErrorType>(
      in_type, &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in WebBundleHandle.OnWebBundleError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleHandle::Name_);
  message.set_method_name("OnWebBundleError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebBundleHandleProxy::OnWebBundleLoadFinished(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebBundleHandle::OnWebBundleLoadFinished", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebBundleHandle_OnWebBundleLoadFinished_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebBundleHandle_OnWebBundleLoadFinished_Params_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebBundleHandle::Name_);
  message.set_method_name("OnWebBundleLoadFinished");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebBundleHandleStubDispatch::Accept(
    WebBundleHandle* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebBundleHandle_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebBundleHandle::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebBundleHandle::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebBundleHandle_Clone_Params_Data* params =
          reinterpret_cast<internal::WebBundleHandle_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<WebBundleHandle> p_receiver{};
      WebBundleHandle_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleHandle::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_receiver));
      return true;
    }
    case internal::kWebBundleHandle_OnWebBundleError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebBundleHandle::OnWebBundleError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebBundleHandle::OnWebBundleError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebBundleHandle_OnWebBundleError_Params_Data* params =
          reinterpret_cast<internal::WebBundleHandle_OnWebBundleError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebBundleErrorType p_type{};
      std::string p_message{};
      WebBundleHandle_OnWebBundleError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleHandle::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWebBundleError(
std::move(p_type), 
std::move(p_message));
      return true;
    }
    case internal::kWebBundleHandle_OnWebBundleLoadFinished_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebBundleHandle::OnWebBundleLoadFinished",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebBundleHandle::OnWebBundleLoadFinished");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebBundleHandle_OnWebBundleLoadFinished_Params_Data* params =
          reinterpret_cast<internal::WebBundleHandle_OnWebBundleLoadFinished_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_success{};
      WebBundleHandle_OnWebBundleLoadFinished_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_success = input_data_view.success();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebBundleHandle::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWebBundleLoadFinished(
std::move(p_success));
      return true;
    }
  }
  return false;
}

// static
bool WebBundleHandleStubDispatch::AcceptWithResponder(
    WebBundleHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebBundleHandle_Clone_Name: {
      break;
    }
    case internal::kWebBundleHandle_OnWebBundleError_Name: {
      break;
    }
    case internal::kWebBundleHandle_OnWebBundleLoadFinished_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebBundleHandleValidationInfo[] = {
    {internal::kWebBundleHandle_Clone_Name,
     {&internal::WebBundleHandle_Clone_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebBundleHandle_OnWebBundleError_Name,
     {&internal::WebBundleHandle_OnWebBundleError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebBundleHandle_OnWebBundleLoadFinished_Name,
     {&internal::WebBundleHandle_OnWebBundleLoadFinished_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebBundleHandleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::WebBundleHandle::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebBundleHandleValidationInfo);
}

}  // namespace mojom
}  // namespace network

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif