// services/network/public/mojom/web_transport.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/web_transport.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/web_transport.mojom-params-data.h"
#include "services/network/public/mojom/web_transport.mojom-shared-message-ids.h"

#include "services/network/public/mojom/web_transport.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
WebTransportError::WebTransportError()
    : net_error(0),
      quic_error(0),
      details(),
      safe_to_report_details(false) {}

WebTransportError::WebTransportError(
    int32_t net_error_in,
    int32_t quic_error_in,
    const WTF::String& details_in,
    bool safe_to_report_details_in)
    : net_error(std::move(net_error_in)),
      quic_error(std::move(quic_error_in)),
      details(std::move(details_in)),
      safe_to_report_details(std::move(safe_to_report_details_in)) {}

WebTransportError::~WebTransportError() = default;
size_t WebTransportError::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->net_error);
  seed = mojo::internal::WTFHash(seed, this->quic_error);
  seed = mojo::internal::WTFHash(seed, this->details);
  seed = mojo::internal::WTFHash(seed, this->safe_to_report_details);
  return seed;
}

void WebTransportError::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "net_error"), this->net_error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quic_error"), this->quic_error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "safe_to_report_details"), this->safe_to_report_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebTransportError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebTransportCertificateFingerprint::WebTransportCertificateFingerprint()
    : algorithm(),
      fingerprint() {}

WebTransportCertificateFingerprint::WebTransportCertificateFingerprint(
    const WTF::String& algorithm_in,
    const WTF::String& fingerprint_in)
    : algorithm(std::move(algorithm_in)),
      fingerprint(std::move(fingerprint_in)) {}

WebTransportCertificateFingerprint::~WebTransportCertificateFingerprint() = default;
size_t WebTransportCertificateFingerprint::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->algorithm);
  seed = mojo::internal::WTFHash(seed, this->fingerprint);
  return seed;
}

void WebTransportCertificateFingerprint::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "algorithm"), this->algorithm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fingerprint"), this->fingerprint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebTransportCertificateFingerprint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char WebTransport::Name_[] = "network.mojom.WebTransport";

class WebTransport_SendDatagram_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebTransport_SendDatagram_ForwardToCallback(
      WebTransport::SendDatagramCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebTransport::SendDatagramCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebTransport_SendDatagram_ForwardToCallback);
};

class WebTransport_CreateStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebTransport_CreateStream_ForwardToCallback(
      WebTransport::CreateStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebTransport::CreateStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebTransport_CreateStream_ForwardToCallback);
};

class WebTransport_AcceptBidirectionalStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebTransport_AcceptBidirectionalStream_ForwardToCallback(
      WebTransport::AcceptBidirectionalStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebTransport::AcceptBidirectionalStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebTransport_AcceptBidirectionalStream_ForwardToCallback);
};

class WebTransport_AcceptUnidirectionalStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebTransport_AcceptUnidirectionalStream_ForwardToCallback(
      WebTransport::AcceptUnidirectionalStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WebTransport::AcceptUnidirectionalStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WebTransport_AcceptUnidirectionalStream_ForwardToCallback);
};

WebTransportProxy::WebTransportProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebTransportProxy::SendDatagram(
    ::base::span<const ::uint8_t> in_data, SendDatagramCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebTransport::SendDatagram", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransport_SendDatagram_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_SendDatagram_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in WebTransport.SendDatagram request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("SendDatagram");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebTransport_SendDatagram_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WebTransportProxy::CreateStream(
    ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable, CreateStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebTransport::CreateStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("readable"), in_readable,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransport_CreateStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_CreateStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_readable, &params->readable, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->readable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid readable in WebTransport.CreateStream request");
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_writable, &params->writable, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("CreateStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebTransport_CreateStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WebTransportProxy::AcceptBidirectionalStream(
    AcceptBidirectionalStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::WebTransport::AcceptBidirectionalStream");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransport_AcceptBidirectionalStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_AcceptBidirectionalStream_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("AcceptBidirectionalStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebTransport_AcceptBidirectionalStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WebTransportProxy::AcceptUnidirectionalStream(
    AcceptUnidirectionalStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::WebTransport::AcceptUnidirectionalStream");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransport_AcceptUnidirectionalStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_AcceptUnidirectionalStream_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("AcceptUnidirectionalStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebTransport_AcceptUnidirectionalStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WebTransportProxy::SendFin(
    uint32_t in_stream_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebTransport::SendFin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransport_SendFin_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_SendFin_Params_Data> params(
          message);
  params.Allocate();
  params->stream_id = in_stream_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("SendFin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebTransportProxy::AbortStream(
    uint32_t in_stream_id, uint64_t in_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebTransport::AbortStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type uint64_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransport_AbortStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_AbortStream_Params_Data> params(
          message);
  params.Allocate();
  params->stream_id = in_stream_id;
  params->code = in_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("AbortStream");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebTransportProxy::SetOutgoingDatagramExpirationDuration(
    ::base::TimeDelta in_duration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebTransport::SetOutgoingDatagramExpirationDuration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration"), in_duration,
                        "<value of type ::base::TimeDelta>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransport_SetOutgoingDatagramExpirationDuration_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_SetOutgoingDatagramExpirationDuration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->duration)::BaseType> duration_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_duration, duration_fragment);
  params->duration.Set(
      duration_fragment.is_null() ? nullptr : duration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->duration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duration in WebTransport.SetOutgoingDatagramExpirationDuration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("SetOutgoingDatagramExpirationDuration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class WebTransport_SendDatagram_ProxyToResponder {
 public:
  static WebTransport::SendDatagramCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebTransport_SendDatagram_ProxyToResponder> proxy(
        new WebTransport_SendDatagram_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebTransport_SendDatagram_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebTransport_SendDatagram_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebTransport_SendDatagram_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebTransport::SendDatagramCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebTransport_SendDatagram_ProxyToResponder);
};

bool WebTransport_SendDatagram_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::WebTransport::SendDatagramCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebTransport_SendDatagram_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebTransport_SendDatagram_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_result{};
  WebTransport_SendDatagram_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebTransport::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void WebTransport_SendDatagram_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::WebTransport::SendDatagramCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransport_SendDatagram_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_SendDatagram_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->result = in_result;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::WebTransport::SendDatagramCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("SendDatagram");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebTransport_CreateStream_ProxyToResponder {
 public:
  static WebTransport::CreateStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebTransport_CreateStream_ProxyToResponder> proxy(
        new WebTransport_CreateStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebTransport_CreateStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebTransport_CreateStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebTransport_CreateStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebTransport::CreateStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_succeeded, uint32_t in_stream_id);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebTransport_CreateStream_ProxyToResponder);
};

bool WebTransport_CreateStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::WebTransport::CreateStreamCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebTransport_CreateStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebTransport_CreateStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  bool p_succeeded{};
  uint32_t p_stream_id{};
  WebTransport_CreateStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_succeeded = input_data_view.succeeded();
  if (success)
    p_stream_id = input_data_view.stream_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebTransport::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_succeeded), 
std::move(p_stream_id));
  return true;
}

void WebTransport_CreateStream_ProxyToResponder::Run(
    bool in_succeeded, uint32_t in_stream_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::WebTransport::CreateStreamCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("succeeded"), in_succeeded,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransport_CreateStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_CreateStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->succeeded = in_succeeded;
  params->stream_id = in_stream_id;

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::WebTransport::CreateStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("CreateStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebTransport_AcceptBidirectionalStream_ProxyToResponder {
 public:
  static WebTransport::AcceptBidirectionalStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebTransport_AcceptBidirectionalStream_ProxyToResponder> proxy(
        new WebTransport_AcceptBidirectionalStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebTransport_AcceptBidirectionalStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebTransport_AcceptBidirectionalStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebTransport_AcceptBidirectionalStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebTransport::AcceptBidirectionalStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebTransport_AcceptBidirectionalStream_ProxyToResponder);
};

bool WebTransport_AcceptBidirectionalStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::WebTransport::AcceptBidirectionalStreamCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebTransport_AcceptBidirectionalStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebTransport_AcceptBidirectionalStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint32_t p_stream_id{};
  ::mojo::ScopedDataPipeConsumerHandle p_readable{};
  ::mojo::ScopedDataPipeProducerHandle p_writable{};
  WebTransport_AcceptBidirectionalStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_stream_id = input_data_view.stream_id();
  if (success)
    p_readable = input_data_view.TakeReadable();
  if (success)
    p_writable = input_data_view.TakeWritable();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebTransport::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_stream_id), 
std::move(p_readable), 
std::move(p_writable));
  return true;
}

void WebTransport_AcceptBidirectionalStream_ProxyToResponder::Run(
    uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable, ::mojo::ScopedDataPipeProducerHandle in_writable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::WebTransport::AcceptBidirectionalStreamCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("readable"), in_readable,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writable"), in_writable,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransport_AcceptBidirectionalStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_AcceptBidirectionalStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->stream_id = in_stream_id;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_readable, &params->readable, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->readable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid readable in ");
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_writable, &params->writable, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->writable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid writable in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::WebTransport::AcceptBidirectionalStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("AcceptBidirectionalStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebTransport_AcceptUnidirectionalStream_ProxyToResponder {
 public:
  static WebTransport::AcceptUnidirectionalStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WebTransport_AcceptUnidirectionalStream_ProxyToResponder> proxy(
        new WebTransport_AcceptUnidirectionalStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WebTransport_AcceptUnidirectionalStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebTransport_AcceptUnidirectionalStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WebTransport_AcceptUnidirectionalStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WebTransport::AcceptUnidirectionalStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WebTransport_AcceptUnidirectionalStream_ProxyToResponder);
};

bool WebTransport_AcceptUnidirectionalStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::WebTransport::AcceptUnidirectionalStreamCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::WebTransport_AcceptUnidirectionalStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebTransport_AcceptUnidirectionalStream_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  uint32_t p_stream_id{};
  ::mojo::ScopedDataPipeConsumerHandle p_readable{};
  WebTransport_AcceptUnidirectionalStream_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_stream_id = input_data_view.stream_id();
  if (success)
    p_readable = input_data_view.TakeReadable();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebTransport::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_stream_id), 
std::move(p_readable));
  return true;
}

void WebTransport_AcceptUnidirectionalStream_ProxyToResponder::Run(
    uint32_t in_stream_id, ::mojo::ScopedDataPipeConsumerHandle in_readable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::WebTransport::AcceptUnidirectionalStreamCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("readable"), in_readable,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransport_AcceptUnidirectionalStream_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransport_AcceptUnidirectionalStream_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->stream_id = in_stream_id;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_readable, &params->readable, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->readable),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid readable in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::WebTransport::AcceptUnidirectionalStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransport::Name_);
  message.set_method_name("AcceptUnidirectionalStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebTransportStubDispatch::Accept(
    WebTransport* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebTransport_SendDatagram_Name: {
      break;
    }
    case internal::kWebTransport_CreateStream_Name: {
      break;
    }
    case internal::kWebTransport_AcceptBidirectionalStream_Name: {
      break;
    }
    case internal::kWebTransport_AcceptUnidirectionalStream_Name: {
      break;
    }
    case internal::kWebTransport_SendFin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebTransport::SendFin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebTransport::SendFin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebTransport_SendFin_Params_Data* params =
          reinterpret_cast<internal::WebTransport_SendFin_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_stream_id{};
      WebTransport_SendFin_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendFin(
std::move(p_stream_id));
      return true;
    }
    case internal::kWebTransport_AbortStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebTransport::AbortStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebTransport::AbortStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebTransport_AbortStream_Params_Data* params =
          reinterpret_cast<internal::WebTransport_AbortStream_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_stream_id{};
      uint64_t p_code{};
      WebTransport_AbortStream_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (success)
        p_code = input_data_view.code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AbortStream(
std::move(p_stream_id), 
std::move(p_code));
      return true;
    }
    case internal::kWebTransport_SetOutgoingDatagramExpirationDuration_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebTransport::SetOutgoingDatagramExpirationDuration",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebTransport::SetOutgoingDatagramExpirationDuration");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebTransport_SetOutgoingDatagramExpirationDuration_Params_Data* params =
          reinterpret_cast<internal::WebTransport_SetOutgoingDatagramExpirationDuration_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_duration{};
      WebTransport_SetOutgoingDatagramExpirationDuration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDuration(&p_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOutgoingDatagramExpirationDuration(
std::move(p_duration));
      return true;
    }
  }
  return false;
}

// static
bool WebTransportStubDispatch::AcceptWithResponder(
    WebTransport* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebTransport_SendDatagram_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebTransport::SendDatagram",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebTransport::SendDatagram");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebTransport_SendDatagram_Params_Data* params =
          reinterpret_cast<
              internal::WebTransport_SendDatagram_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::span<const ::uint8_t> p_data{};
      WebTransport_SendDatagram_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 0, false);
        return false;
      }
      WebTransport::SendDatagramCallback callback =
          WebTransport_SendDatagram_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendDatagram(
std::move(p_data), std::move(callback));
      return true;
    }
    case internal::kWebTransport_CreateStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebTransport::CreateStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebTransport::CreateStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebTransport_CreateStream_Params_Data* params =
          reinterpret_cast<
              internal::WebTransport_CreateStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedDataPipeConsumerHandle p_readable{};
      ::mojo::ScopedDataPipeProducerHandle p_writable{};
      WebTransport_CreateStream_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_readable = input_data_view.TakeReadable();
      if (success)
        p_writable = input_data_view.TakeWritable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 1, false);
        return false;
      }
      WebTransport::CreateStreamCallback callback =
          WebTransport_CreateStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateStream(
std::move(p_readable), 
std::move(p_writable), std::move(callback));
      return true;
    }
    case internal::kWebTransport_AcceptBidirectionalStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebTransport::AcceptBidirectionalStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebTransport::AcceptBidirectionalStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebTransport_AcceptBidirectionalStream_Params_Data* params =
          reinterpret_cast<
              internal::WebTransport_AcceptBidirectionalStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WebTransport_AcceptBidirectionalStream_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 2, false);
        return false;
      }
      WebTransport::AcceptBidirectionalStreamCallback callback =
          WebTransport_AcceptBidirectionalStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptBidirectionalStream(std::move(callback));
      return true;
    }
    case internal::kWebTransport_AcceptUnidirectionalStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebTransport::AcceptUnidirectionalStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebTransport::AcceptUnidirectionalStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WebTransport_AcceptUnidirectionalStream_Params_Data* params =
          reinterpret_cast<
              internal::WebTransport_AcceptUnidirectionalStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WebTransport_AcceptUnidirectionalStream_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransport::Name_, 3, false);
        return false;
      }
      WebTransport::AcceptUnidirectionalStreamCallback callback =
          WebTransport_AcceptUnidirectionalStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptUnidirectionalStream(std::move(callback));
      return true;
    }
    case internal::kWebTransport_SendFin_Name: {
      break;
    }
    case internal::kWebTransport_AbortStream_Name: {
      break;
    }
    case internal::kWebTransport_SetOutgoingDatagramExpirationDuration_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebTransportValidationInfo[] = {
    {internal::kWebTransport_SendDatagram_Name,
     {&internal::WebTransport_SendDatagram_Params_Data::Validate,
      &internal::WebTransport_SendDatagram_ResponseParams_Data::Validate}},
    {internal::kWebTransport_CreateStream_Name,
     {&internal::WebTransport_CreateStream_Params_Data::Validate,
      &internal::WebTransport_CreateStream_ResponseParams_Data::Validate}},
    {internal::kWebTransport_AcceptBidirectionalStream_Name,
     {&internal::WebTransport_AcceptBidirectionalStream_Params_Data::Validate,
      &internal::WebTransport_AcceptBidirectionalStream_ResponseParams_Data::Validate}},
    {internal::kWebTransport_AcceptUnidirectionalStream_Name,
     {&internal::WebTransport_AcceptUnidirectionalStream_Params_Data::Validate,
      &internal::WebTransport_AcceptUnidirectionalStream_ResponseParams_Data::Validate}},
    {internal::kWebTransport_SendFin_Name,
     {&internal::WebTransport_SendFin_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebTransport_AbortStream_Name,
     {&internal::WebTransport_AbortStream_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebTransport_SetOutgoingDatagramExpirationDuration_Name,
     {&internal::WebTransport_SetOutgoingDatagramExpirationDuration_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebTransportRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebTransport::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebTransportValidationInfo);
}

bool WebTransportResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebTransport::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kWebTransportValidationInfo);

}
const char WebTransportClient::Name_[] = "network.mojom.WebTransportClient";

WebTransportClientProxy::WebTransportClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebTransportClientProxy::OnDatagramReceived(
    ::base::span<const ::uint8_t> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebTransportClient::OnDatagramReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransportClient_OnDatagramReceived_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportClient_OnDatagramReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in WebTransportClient.OnDatagramReceived request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportClient::Name_);
  message.set_method_name("OnDatagramReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebTransportClientProxy::OnIncomingStreamClosed(
    uint32_t in_stream_id, bool in_fin_received) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebTransportClient::OnIncomingStreamClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fin_received"), in_fin_received,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransportClient_OnIncomingStreamClosed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportClient_OnIncomingStreamClosed_Params_Data> params(
          message);
  params.Allocate();
  params->stream_id = in_stream_id;
  params->fin_received = in_fin_received;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportClient::Name_);
  message.set_method_name("OnIncomingStreamClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebTransportClientStubDispatch::Accept(
    WebTransportClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebTransportClient_OnDatagramReceived_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebTransportClient::OnDatagramReceived",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebTransportClient::OnDatagramReceived");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebTransportClient_OnDatagramReceived_Params_Data* params =
          reinterpret_cast<internal::WebTransportClient_OnDatagramReceived_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::span<const ::uint8_t> p_data{};
      WebTransportClient_OnDatagramReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDatagramReceived(
std::move(p_data));
      return true;
    }
    case internal::kWebTransportClient_OnIncomingStreamClosed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebTransportClient::OnIncomingStreamClosed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebTransportClient::OnIncomingStreamClosed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebTransportClient_OnIncomingStreamClosed_Params_Data* params =
          reinterpret_cast<internal::WebTransportClient_OnIncomingStreamClosed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_stream_id{};
      bool p_fin_received{};
      WebTransportClient_OnIncomingStreamClosed_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stream_id = input_data_view.stream_id();
      if (success)
        p_fin_received = input_data_view.fin_received();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnIncomingStreamClosed(
std::move(p_stream_id), 
std::move(p_fin_received));
      return true;
    }
  }
  return false;
}

// static
bool WebTransportClientStubDispatch::AcceptWithResponder(
    WebTransportClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebTransportClient_OnDatagramReceived_Name: {
      break;
    }
    case internal::kWebTransportClient_OnIncomingStreamClosed_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebTransportClientValidationInfo[] = {
    {internal::kWebTransportClient_OnDatagramReceived_Name,
     {&internal::WebTransportClient_OnDatagramReceived_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebTransportClient_OnIncomingStreamClosed_Name,
     {&internal::WebTransportClient_OnIncomingStreamClosed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebTransportClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebTransportClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebTransportClientValidationInfo);
}

const char WebTransportHandshakeClient::Name_[] = "network.mojom.WebTransportHandshakeClient";

WebTransportHandshakeClientProxy::WebTransportHandshakeClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebTransportHandshakeClientProxy::OnConnectionEstablished(
    ::mojo::PendingRemote<WebTransport> in_transport, ::mojo::PendingReceiver<WebTransportClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebTransportHandshakeClient::OnConnectionEstablished", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transport"), in_transport,
                        "<value of type ::mojo::PendingRemote<WebTransport>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingReceiver<WebTransportClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransportHandshakeClient_OnConnectionEstablished_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportHandshakeClient_OnConnectionEstablished_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebTransportInterfaceBase>>(
      in_transport, &params->transport, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->transport),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid transport in WebTransportHandshakeClient.OnConnectionEstablished request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::WebTransportClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in WebTransportHandshakeClient.OnConnectionEstablished request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportHandshakeClient::Name_);
  message.set_method_name("OnConnectionEstablished");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WebTransportHandshakeClientProxy::OnHandshakeFailed(
    WebTransportErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::WebTransportHandshakeClient::OnHandshakeFailed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type WebTransportErrorPtr>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kWebTransportHandshakeClient_OnHandshakeFailed_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::WebTransportHandshakeClient_OnHandshakeFailed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::WebTransportErrorDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebTransportHandshakeClient::Name_);
  message.set_method_name("OnHandshakeFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WebTransportHandshakeClientStubDispatch::Accept(
    WebTransportHandshakeClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kWebTransportHandshakeClient_OnConnectionEstablished_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebTransportHandshakeClient::OnConnectionEstablished",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebTransportHandshakeClient::OnConnectionEstablished");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebTransportHandshakeClient_OnConnectionEstablished_Params_Data* params =
          reinterpret_cast<internal::WebTransportHandshakeClient_OnConnectionEstablished_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<WebTransport> p_transport{};
      ::mojo::PendingReceiver<WebTransportClient> p_client{};
      WebTransportHandshakeClient_OnConnectionEstablished_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_transport =
            input_data_view.TakeTransport<decltype(p_transport)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportHandshakeClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnectionEstablished(
std::move(p_transport), 
std::move(p_client));
      return true;
    }
    case internal::kWebTransportHandshakeClient_OnHandshakeFailed_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::WebTransportHandshakeClient::OnHandshakeFailed",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::WebTransportHandshakeClient::OnHandshakeFailed");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WebTransportHandshakeClient_OnHandshakeFailed_Params_Data* params =
          reinterpret_cast<internal::WebTransportHandshakeClient_OnHandshakeFailed_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WebTransportErrorPtr p_error{};
      WebTransportHandshakeClient_OnHandshakeFailed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebTransportHandshakeClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHandshakeFailed(
std::move(p_error));
      return true;
    }
  }
  return false;
}

// static
bool WebTransportHandshakeClientStubDispatch::AcceptWithResponder(
    WebTransportHandshakeClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWebTransportHandshakeClient_OnConnectionEstablished_Name: {
      break;
    }
    case internal::kWebTransportHandshakeClient_OnHandshakeFailed_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebTransportHandshakeClientValidationInfo[] = {
    {internal::kWebTransportHandshakeClient_OnConnectionEstablished_Name,
     {&internal::WebTransportHandshakeClient_OnConnectionEstablished_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kWebTransportHandshakeClient_OnHandshakeFailed_Name,
     {&internal::WebTransportHandshakeClient_OnHandshakeFailed_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebTransportHandshakeClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::WebTransportHandshakeClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kWebTransportHandshakeClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::WebTransportError::DataView, ::network::mojom::blink::WebTransportErrorPtr>::Read(
    ::network::mojom::blink::WebTransportError::DataView input,
    ::network::mojom::blink::WebTransportErrorPtr* output) {
  bool success = true;
  ::network::mojom::blink::WebTransportErrorPtr result(::network::mojom::blink::WebTransportError::New());
  
      if (success)
        result->net_error = input.net_error();
      if (success)
        result->quic_error = input.quic_error();
      if (success && !input.ReadDetails(&result->details))
        success = false;
      if (success)
        result->safe_to_report_details = input.safe_to_report_details();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::WebTransportCertificateFingerprint::DataView, ::network::mojom::blink::WebTransportCertificateFingerprintPtr>::Read(
    ::network::mojom::blink::WebTransportCertificateFingerprint::DataView input,
    ::network::mojom::blink::WebTransportCertificateFingerprintPtr* output) {
  bool success = true;
  ::network::mojom::blink::WebTransportCertificateFingerprintPtr result(::network::mojom::blink::WebTransportCertificateFingerprint::New());
  
      if (success && !input.ReadAlgorithm(&result->algorithm))
        success = false;
      if (success && !input.ReadFingerprint(&result->fingerprint))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif