// services/network/public/mojom/web_transport.mojom-test-utils.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif


#include "services/network/public/mojom/web_transport.mojom-test-utils.h"

#include <utility>

#include "base/bind.h"
#include "base/run_loop.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_JUMBO_H_
#endif


namespace network {
namespace mojom {


void WebTransportInterceptorForTesting::SendDatagram(::base::span<const ::uint8_t> data, SendDatagramCallback callback) {
  GetForwardingInterface()->SendDatagram(std::move(data), std::move(callback));
}
void WebTransportInterceptorForTesting::CreateStream(::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, CreateStreamCallback callback) {
  GetForwardingInterface()->CreateStream(std::move(readable), std::move(writable), std::move(callback));
}
void WebTransportInterceptorForTesting::AcceptBidirectionalStream(AcceptBidirectionalStreamCallback callback) {
  GetForwardingInterface()->AcceptBidirectionalStream(std::move(callback));
}
void WebTransportInterceptorForTesting::AcceptUnidirectionalStream(AcceptUnidirectionalStreamCallback callback) {
  GetForwardingInterface()->AcceptUnidirectionalStream(std::move(callback));
}
void WebTransportInterceptorForTesting::SendFin(uint32_t stream_id) {
  GetForwardingInterface()->SendFin(std::move(stream_id));
}
void WebTransportInterceptorForTesting::AbortStream(uint32_t stream_id, uint64_t code) {
  GetForwardingInterface()->AbortStream(std::move(stream_id), std::move(code));
}
void WebTransportInterceptorForTesting::SetOutgoingDatagramExpirationDuration(::base::TimeDelta duration) {
  GetForwardingInterface()->SetOutgoingDatagramExpirationDuration(std::move(duration));
}
WebTransportAsyncWaiter::WebTransportAsyncWaiter(
    WebTransport* proxy) : proxy_(proxy) {}

WebTransportAsyncWaiter::~WebTransportAsyncWaiter() = default;

void WebTransportAsyncWaiter::SendDatagram(
    ::base::span<const ::uint8_t> data, bool* out_result) {
  base::RunLoop loop;
  proxy_->SendDatagram(std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}
void WebTransportAsyncWaiter::CreateStream(
    ::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, bool* out_succeeded, uint32_t* out_stream_id) {
  base::RunLoop loop;
  proxy_->CreateStream(std::move(readable),std::move(writable),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_succeeded
,
             uint32_t* out_stream_id
,
             bool succeeded,
             uint32_t stream_id) {*out_succeeded = std::move(succeeded);*out_stream_id = std::move(stream_id);
            loop->Quit();
          },
          &loop,
          out_succeeded,
          out_stream_id));
  loop.Run();
}
void WebTransportAsyncWaiter::AcceptBidirectionalStream(
    uint32_t* out_stream_id, ::mojo::ScopedDataPipeConsumerHandle* out_readable, ::mojo::ScopedDataPipeProducerHandle* out_writable) {
  base::RunLoop loop;
  proxy_->AcceptBidirectionalStream(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_stream_id
,
             ::mojo::ScopedDataPipeConsumerHandle* out_readable
,
             ::mojo::ScopedDataPipeProducerHandle* out_writable
,
             uint32_t stream_id,
             ::mojo::ScopedDataPipeConsumerHandle readable,
             ::mojo::ScopedDataPipeProducerHandle writable) {*out_stream_id = std::move(stream_id);*out_readable = std::move(readable);*out_writable = std::move(writable);
            loop->Quit();
          },
          &loop,
          out_stream_id,
          out_readable,
          out_writable));
  loop.Run();
}
void WebTransportAsyncWaiter::AcceptUnidirectionalStream(
    uint32_t* out_stream_id, ::mojo::ScopedDataPipeConsumerHandle* out_readable) {
  base::RunLoop loop;
  proxy_->AcceptUnidirectionalStream(
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_stream_id
,
             ::mojo::ScopedDataPipeConsumerHandle* out_readable
,
             uint32_t stream_id,
             ::mojo::ScopedDataPipeConsumerHandle readable) {*out_stream_id = std::move(stream_id);*out_readable = std::move(readable);
            loop->Quit();
          },
          &loop,
          out_stream_id,
          out_readable));
  loop.Run();
}



void WebTransportClientInterceptorForTesting::OnDatagramReceived(::base::span<const ::uint8_t> data) {
  GetForwardingInterface()->OnDatagramReceived(std::move(data));
}
void WebTransportClientInterceptorForTesting::OnIncomingStreamClosed(uint32_t stream_id, bool fin_received) {
  GetForwardingInterface()->OnIncomingStreamClosed(std::move(stream_id), std::move(fin_received));
}
WebTransportClientAsyncWaiter::WebTransportClientAsyncWaiter(
    WebTransportClient* proxy) : proxy_(proxy) {}

WebTransportClientAsyncWaiter::~WebTransportClientAsyncWaiter() = default;




void WebTransportHandshakeClientInterceptorForTesting::OnConnectionEstablished(::mojo::PendingRemote<WebTransport> transport, ::mojo::PendingReceiver<WebTransportClient> client) {
  GetForwardingInterface()->OnConnectionEstablished(std::move(transport), std::move(client));
}
void WebTransportHandshakeClientInterceptorForTesting::OnHandshakeFailed(const absl::optional<::net::WebTransportError>& error) {
  GetForwardingInterface()->OnHandshakeFailed(std::move(error));
}
WebTransportHandshakeClientAsyncWaiter::WebTransportHandshakeClientAsyncWaiter(
    WebTransportHandshakeClient* proxy) : proxy_(proxy) {}

WebTransportHandshakeClientAsyncWaiter::~WebTransportHandshakeClientAsyncWaiter() = default;






}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif