// services/proxy_resolver/public/mojom/proxy_resolver.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-params-data.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared-message-ids.h"

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-import-headers.h"


#ifndef SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_JUMBO_H_
#define SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_JUMBO_H_
#endif
namespace proxy_resolver {
namespace mojom {
ProxyServer::ProxyServer()
    : scheme(),
      host(),
      port() {}

ProxyServer::ProxyServer(
    ProxyScheme scheme_in,
    const std::string& host_in,
    uint16_t port_in)
    : scheme(std::move(scheme_in)),
      host(std::move(host_in)),
      port(std::move(port_in)) {}

ProxyServer::~ProxyServer() = default;

void ProxyServer::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProxyScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyServer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyInfo::ProxyInfo()
    : proxy_servers() {}

ProxyInfo::ProxyInfo(
    std::vector<::net::ProxyServer> proxy_servers_in)
    : proxy_servers(std::move(proxy_servers_in)) {}

ProxyInfo::~ProxyInfo() = default;

void ProxyInfo::WriteIntoTrace(perfetto::TracedValue context) const {
  auto dict = std::move(context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_servers"), this->proxy_servers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::net::ProxyServer>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char HostResolverRequestClient::Name_[] = "proxy_resolver.mojom.HostResolverRequestClient";

HostResolverRequestClientProxy::HostResolverRequestClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HostResolverRequestClientProxy::ReportResult(
    int32_t in_error, const std::vector<::net::IPAddress>& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "proxy_resolver::mojom::HostResolverRequestClient::ReportResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const std::vector<::net::IPAddress>&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kHostResolverRequestClient_ReportResult_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::HostResolverRequestClient_ReportResult_Params_Data> params(
          message);
  params.Allocate();
  params->error = in_error;
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType>
      result_fragment(params.message());
  const mojo::internal::ContainerValidateParams result_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>(
      in_result, result_fragment, &result_validate_params);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in HostResolverRequestClient.ReportResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HostResolverRequestClient::Name_);
  message.set_method_name("ReportResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool HostResolverRequestClientStubDispatch::Accept(
    HostResolverRequestClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kHostResolverRequestClient_ReportResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)proxy_resolver::mojom::HostResolverRequestClient::ReportResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)proxy_resolver::mojom::HostResolverRequestClient::ReportResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::HostResolverRequestClient_ReportResult_Params_Data* params =
          reinterpret_cast<internal::HostResolverRequestClient_ReportResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_error{};
      std::vector<::net::IPAddress> p_result{};
      HostResolverRequestClient_ReportResult_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_error = input_data_view.error();
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HostResolverRequestClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportResult(
std::move(p_error), 
std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool HostResolverRequestClientStubDispatch::AcceptWithResponder(
    HostResolverRequestClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kHostResolverRequestClient_ReportResult_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kHostResolverRequestClientValidationInfo[] = {
    {internal::kHostResolverRequestClient_ReportResult_Name,
     {&internal::HostResolverRequestClient_ReportResult_Params_Data::Validate,
      nullptr /* no response */}},
};

bool HostResolverRequestClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::proxy_resolver::mojom::HostResolverRequestClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kHostResolverRequestClientValidationInfo);
}

const char ProxyResolver::Name_[] = "proxy_resolver.mojom.ProxyResolver";

ProxyResolverProxy::ProxyResolverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyResolverProxy::GetProxyForUrl(
    const ::GURL& in_url, const ::net::NetworkIsolationKey& in_network_isolation_key, ::mojo::PendingRemote<ProxyResolverRequestClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "proxy_resolver::mojom::ProxyResolver::GetProxyForUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_isolation_key"), in_network_isolation_key,
                        "<value of type const ::net::NetworkIsolationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<ProxyResolverRequestClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyResolver_GetProxyForUrl_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolver_GetProxyForUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ProxyResolver.GetProxyForUrl request");
  mojo::internal::MessageFragment<
      typename decltype(params->network_isolation_key)::BaseType> network_isolation_key_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, network_isolation_key_fragment);
  params->network_isolation_key.Set(
      network_isolation_key_fragment.is_null() ? nullptr : network_isolation_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in ProxyResolver.GetProxyForUrl request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::ProxyResolverRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in ProxyResolver.GetProxyForUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolver::Name_);
  message.set_method_name("GetProxyForUrl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ProxyResolverStubDispatch::Accept(
    ProxyResolver* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProxyResolver_GetProxyForUrl_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)proxy_resolver::mojom::ProxyResolver::GetProxyForUrl",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)proxy_resolver::mojom::ProxyResolver::GetProxyForUrl");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyResolver_GetProxyForUrl_Params_Data* params =
          reinterpret_cast<internal::ProxyResolver_GetProxyForUrl_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      ::mojo::PendingRemote<ProxyResolverRequestClient> p_client{};
      ProxyResolver_GetProxyForUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProxyForUrl(
std::move(p_url), 
std::move(p_network_isolation_key), 
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool ProxyResolverStubDispatch::AcceptWithResponder(
    ProxyResolver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProxyResolver_GetProxyForUrl_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyResolverValidationInfo[] = {
    {internal::kProxyResolver_GetProxyForUrl_Name,
     {&internal::ProxyResolver_GetProxyForUrl_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProxyResolverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::proxy_resolver::mojom::ProxyResolver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyResolverValidationInfo);
}

const char ProxyResolverRequestClient::Name_[] = "proxy_resolver.mojom.ProxyResolverRequestClient";

ProxyResolverRequestClientProxy::ProxyResolverRequestClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyResolverRequestClientProxy::ReportResult(
    int32_t in_error, const ::net::ProxyInfo& in_proxy_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "proxy_resolver::mojom::ProxyResolverRequestClient::ReportResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_info"), in_proxy_info,
                        "<value of type const ::net::ProxyInfo&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyResolverRequestClient_ReportResult_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverRequestClient_ReportResult_Params_Data> params(
          message);
  params.Allocate();
  params->error = in_error;
  mojo::internal::MessageFragment<
      typename decltype(params->proxy_info)::BaseType> proxy_info_fragment(
          params.message());
  mojo::internal::Serialize<::proxy_resolver::mojom::ProxyInfoDataView>(
      in_proxy_info, proxy_info_fragment);
  params->proxy_info.Set(
      proxy_info_fragment.is_null() ? nullptr : proxy_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->proxy_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxy_info in ProxyResolverRequestClient.ReportResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverRequestClient::Name_);
  message.set_method_name("ReportResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProxyResolverRequestClientProxy::Alert(
    const std::string& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "proxy_resolver::mojom::ProxyResolverRequestClient::Alert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyResolverRequestClient_Alert_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverRequestClient_Alert_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in ProxyResolverRequestClient.Alert request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverRequestClient::Name_);
  message.set_method_name("Alert");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProxyResolverRequestClientProxy::OnError(
    int32_t in_line_number, const std::string& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "proxy_resolver::mojom::ProxyResolverRequestClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyResolverRequestClient_OnError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverRequestClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  params->line_number = in_line_number;
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in ProxyResolverRequestClient.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverRequestClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProxyResolverRequestClientProxy::ResolveDns(
    const std::string& in_host, ::net::ProxyResolveDnsOperation in_operation, const ::net::NetworkIsolationKey& in_network_isolation_key, ::mojo::PendingRemote<HostResolverRequestClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "proxy_resolver::mojom::ProxyResolverRequestClient::ResolveDns", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operation"), in_operation,
                        "<value of type ::net::ProxyResolveDnsOperation>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_isolation_key"), in_network_isolation_key,
                        "<value of type const ::net::NetworkIsolationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<HostResolverRequestClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyResolverRequestClient_ResolveDns_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverRequestClient_ResolveDns_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host, host_fragment);
  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in ProxyResolverRequestClient.ResolveDns request");
  mojo::internal::Serialize<::proxy_resolver::mojom::HostResolveOperation>(
      in_operation, &params->operation);
  mojo::internal::MessageFragment<
      typename decltype(params->network_isolation_key)::BaseType> network_isolation_key_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, network_isolation_key_fragment);
  params->network_isolation_key.Set(
      network_isolation_key_fragment.is_null() ? nullptr : network_isolation_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in ProxyResolverRequestClient.ResolveDns request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::HostResolverRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in ProxyResolverRequestClient.ResolveDns request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverRequestClient::Name_);
  message.set_method_name("ResolveDns");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ProxyResolverRequestClientStubDispatch::Accept(
    ProxyResolverRequestClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProxyResolverRequestClient_ReportResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::ReportResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::ReportResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyResolverRequestClient_ReportResult_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverRequestClient_ReportResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_error{};
      ::net::ProxyInfo p_proxy_info{};
      ProxyResolverRequestClient_ReportResult_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_error = input_data_view.error();
      if (success && !input_data_view.ReadProxyInfo(&p_proxy_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverRequestClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportResult(
std::move(p_error), 
std::move(p_proxy_info));
      return true;
    }
    case internal::kProxyResolverRequestClient_Alert_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::Alert",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::Alert");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyResolverRequestClient_Alert_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverRequestClient_Alert_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_error{};
      ProxyResolverRequestClient_Alert_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverRequestClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Alert(
std::move(p_error));
      return true;
    }
    case internal::kProxyResolverRequestClient_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyResolverRequestClient_OnError_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverRequestClient_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_line_number{};
      std::string p_error{};
      ProxyResolverRequestClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_line_number = input_data_view.line_number();
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverRequestClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_line_number), 
std::move(p_error));
      return true;
    }
    case internal::kProxyResolverRequestClient_ResolveDns_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::ResolveDns",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)proxy_resolver::mojom::ProxyResolverRequestClient::ResolveDns");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyResolverRequestClient_ResolveDns_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverRequestClient_ResolveDns_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_host{};
      ::net::ProxyResolveDnsOperation p_operation{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      ::mojo::PendingRemote<HostResolverRequestClient> p_client{};
      ProxyResolverRequestClient_ResolveDns_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadOperation(&p_operation))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverRequestClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveDns(
std::move(p_host), 
std::move(p_operation), 
std::move(p_network_isolation_key), 
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool ProxyResolverRequestClientStubDispatch::AcceptWithResponder(
    ProxyResolverRequestClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProxyResolverRequestClient_ReportResult_Name: {
      break;
    }
    case internal::kProxyResolverRequestClient_Alert_Name: {
      break;
    }
    case internal::kProxyResolverRequestClient_OnError_Name: {
      break;
    }
    case internal::kProxyResolverRequestClient_ResolveDns_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyResolverRequestClientValidationInfo[] = {
    {internal::kProxyResolverRequestClient_ReportResult_Name,
     {&internal::ProxyResolverRequestClient_ReportResult_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProxyResolverRequestClient_Alert_Name,
     {&internal::ProxyResolverRequestClient_Alert_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProxyResolverRequestClient_OnError_Name,
     {&internal::ProxyResolverRequestClient_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProxyResolverRequestClient_ResolveDns_Name,
     {&internal::ProxyResolverRequestClient_ResolveDns_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProxyResolverRequestClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::proxy_resolver::mojom::ProxyResolverRequestClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyResolverRequestClientValidationInfo);
}

const char ProxyResolverFactory::Name_[] = "proxy_resolver.mojom.ProxyResolverFactory";

ProxyResolverFactoryProxy::ProxyResolverFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyResolverFactoryProxy::CreateResolver(
    const std::string& in_pac_script, ::mojo::PendingReceiver<ProxyResolver> in_receiver, ::mojo::PendingRemote<ProxyResolverFactoryRequestClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "proxy_resolver::mojom::ProxyResolverFactory::CreateResolver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pac_script"), in_pac_script,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<ProxyResolver>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<ProxyResolverFactoryRequestClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyResolverFactory_CreateResolver_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverFactory_CreateResolver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pac_script)::BaseType> pac_script_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_pac_script, pac_script_fragment);
  params->pac_script.Set(
      pac_script_fragment.is_null() ? nullptr : pac_script_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->pac_script.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pac_script in ProxyResolverFactory.CreateResolver request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::proxy_resolver::mojom::ProxyResolverInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in ProxyResolverFactory.CreateResolver request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::ProxyResolverFactoryRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in ProxyResolverFactory.CreateResolver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverFactory::Name_);
  message.set_method_name("CreateResolver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ProxyResolverFactoryStubDispatch::Accept(
    ProxyResolverFactory* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProxyResolverFactory_CreateResolver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)proxy_resolver::mojom::ProxyResolverFactory::CreateResolver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)proxy_resolver::mojom::ProxyResolverFactory::CreateResolver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyResolverFactory_CreateResolver_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverFactory_CreateResolver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_pac_script{};
      ::mojo::PendingReceiver<ProxyResolver> p_receiver{};
      ::mojo::PendingRemote<ProxyResolverFactoryRequestClient> p_client{};
      ProxyResolverFactory_CreateResolver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPacScript(&p_pac_script))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateResolver(
std::move(p_pac_script), 
std::move(p_receiver), 
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool ProxyResolverFactoryStubDispatch::AcceptWithResponder(
    ProxyResolverFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProxyResolverFactory_CreateResolver_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyResolverFactoryValidationInfo[] = {
    {internal::kProxyResolverFactory_CreateResolver_Name,
     {&internal::ProxyResolverFactory_CreateResolver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProxyResolverFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::proxy_resolver::mojom::ProxyResolverFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyResolverFactoryValidationInfo);
}

const char ProxyResolverFactoryRequestClient::Name_[] = "proxy_resolver.mojom.ProxyResolverFactoryRequestClient";

ProxyResolverFactoryRequestClientProxy::ProxyResolverFactoryRequestClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyResolverFactoryRequestClientProxy::ReportResult(
    int32_t in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ReportResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type int32_t>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyResolverFactoryRequestClient_ReportResult_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverFactoryRequestClient_ReportResult_Params_Data> params(
          message);
  params.Allocate();
  params->error = in_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverFactoryRequestClient::Name_);
  message.set_method_name("ReportResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProxyResolverFactoryRequestClientProxy::Alert(
    const std::string& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "proxy_resolver::mojom::ProxyResolverFactoryRequestClient::Alert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyResolverFactoryRequestClient_Alert_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverFactoryRequestClient_Alert_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in ProxyResolverFactoryRequestClient.Alert request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverFactoryRequestClient::Name_);
  message.set_method_name("Alert");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProxyResolverFactoryRequestClientProxy::OnError(
    int32_t in_line_number, const std::string& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "proxy_resolver::mojom::ProxyResolverFactoryRequestClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyResolverFactoryRequestClient_OnError_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverFactoryRequestClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  params->line_number = in_line_number;
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error in ProxyResolverFactoryRequestClient.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverFactoryRequestClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ProxyResolverFactoryRequestClientProxy::ResolveDns(
    const std::string& in_host, ::net::ProxyResolveDnsOperation in_operation, const ::net::NetworkIsolationKey& in_network_isolation_key, ::mojo::PendingRemote<HostResolverRequestClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ResolveDns", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("operation"), in_operation,
                        "<value of type ::net::ProxyResolveDnsOperation>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_isolation_key"), in_network_isolation_key,
                        "<value of type const ::net::NetworkIsolationKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<HostResolverRequestClient>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kProxyResolverFactoryRequestClient_ResolveDns_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::proxy_resolver::mojom::internal::ProxyResolverFactoryRequestClient_ResolveDns_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host, host_fragment);
  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in ProxyResolverFactoryRequestClient.ResolveDns request");
  mojo::internal::Serialize<::proxy_resolver::mojom::HostResolveOperation>(
      in_operation, &params->operation);
  mojo::internal::MessageFragment<
      typename decltype(params->network_isolation_key)::BaseType> network_isolation_key_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, network_isolation_key_fragment);
  params->network_isolation_key.Set(
      network_isolation_key_fragment.is_null() ? nullptr : network_isolation_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in ProxyResolverFactoryRequestClient.ResolveDns request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::HostResolverRequestClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in ProxyResolverFactoryRequestClient.ResolveDns request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyResolverFactoryRequestClient::Name_);
  message.set_method_name("ResolveDns");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ProxyResolverFactoryRequestClientStubDispatch::Accept(
    ProxyResolverFactoryRequestClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kProxyResolverFactoryRequestClient_ReportResult_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ReportResult",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ReportResult");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyResolverFactoryRequestClient_ReportResult_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverFactoryRequestClient_ReportResult_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_error{};
      ProxyResolverFactoryRequestClient_ReportResult_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_error = input_data_view.error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverFactoryRequestClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportResult(
std::move(p_error));
      return true;
    }
    case internal::kProxyResolverFactoryRequestClient_Alert_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::Alert",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::Alert");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyResolverFactoryRequestClient_Alert_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverFactoryRequestClient_Alert_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_error{};
      ProxyResolverFactoryRequestClient_Alert_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverFactoryRequestClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Alert(
std::move(p_error));
      return true;
    }
    case internal::kProxyResolverFactoryRequestClient_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyResolverFactoryRequestClient_OnError_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverFactoryRequestClient_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_line_number{};
      std::string p_error{};
      ProxyResolverFactoryRequestClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_line_number = input_data_view.line_number();
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverFactoryRequestClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_line_number), 
std::move(p_error));
      return true;
    }
    case internal::kProxyResolverFactoryRequestClient_ResolveDns_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ResolveDns",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)proxy_resolver::mojom::ProxyResolverFactoryRequestClient::ResolveDns");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ProxyResolverFactoryRequestClient_ResolveDns_Params_Data* params =
          reinterpret_cast<internal::ProxyResolverFactoryRequestClient_ResolveDns_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_host{};
      ::net::ProxyResolveDnsOperation p_operation{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      ::mojo::PendingRemote<HostResolverRequestClient> p_client{};
      ProxyResolverFactoryRequestClient_ResolveDns_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadOperation(&p_operation))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyResolverFactoryRequestClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveDns(
std::move(p_host), 
std::move(p_operation), 
std::move(p_network_isolation_key), 
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool ProxyResolverFactoryRequestClientStubDispatch::AcceptWithResponder(
    ProxyResolverFactoryRequestClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kProxyResolverFactoryRequestClient_ReportResult_Name: {
      break;
    }
    case internal::kProxyResolverFactoryRequestClient_Alert_Name: {
      break;
    }
    case internal::kProxyResolverFactoryRequestClient_OnError_Name: {
      break;
    }
    case internal::kProxyResolverFactoryRequestClient_ResolveDns_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kProxyResolverFactoryRequestClientValidationInfo[] = {
    {internal::kProxyResolverFactoryRequestClient_ReportResult_Name,
     {&internal::ProxyResolverFactoryRequestClient_ReportResult_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProxyResolverFactoryRequestClient_Alert_Name,
     {&internal::ProxyResolverFactoryRequestClient_Alert_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProxyResolverFactoryRequestClient_OnError_Name,
     {&internal::ProxyResolverFactoryRequestClient_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kProxyResolverFactoryRequestClient_ResolveDns_Name,
     {&internal::ProxyResolverFactoryRequestClient_ResolveDns_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ProxyResolverFactoryRequestClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::proxy_resolver::mojom::ProxyResolverFactoryRequestClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kProxyResolverFactoryRequestClientValidationInfo);
}

}  // namespace mojom
}  // namespace proxy_resolver

namespace mojo {


// static
bool StructTraits<::proxy_resolver::mojom::ProxyServer::DataView, ::proxy_resolver::mojom::ProxyServerPtr>::Read(
    ::proxy_resolver::mojom::ProxyServer::DataView input,
    ::proxy_resolver::mojom::ProxyServerPtr* output) {
  bool success = true;
  ::proxy_resolver::mojom::ProxyServerPtr result(::proxy_resolver::mojom::ProxyServer::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->port = input.port();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::proxy_resolver::mojom::ProxyInfo::DataView, ::proxy_resolver::mojom::ProxyInfoPtr>::Read(
    ::proxy_resolver::mojom::ProxyInfo::DataView input,
    ::proxy_resolver::mojom::ProxyInfoPtr* output) {
  bool success = true;
  ::proxy_resolver::mojom::ProxyInfoPtr result(::proxy_resolver::mojom::ProxyInfo::New());
  
      if (success && !input.ReadProxyServers(&result->proxy_servers))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif