// services/service_manager/public/mojom/connector.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/service_manager/public/mojom/connector.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>

#include "base/compiler_specific.h"
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/service_manager/public/mojom/connector.mojom-params-data.h"
namespace service_manager {
namespace mojom {

static NOINLINE const char* ConnectResultToStringHelper(ConnectResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ConnectResult::SUCCEEDED:
      return "SUCCEEDED";
    case ConnectResult::INVALID_ARGUMENT:
      return "INVALID_ARGUMENT";
    case ConnectResult::ACCESS_DENIED:
      return "ACCESS_DENIED";
    default:
      return nullptr;
  }
}

std::string ConnectResultToString(ConnectResult value) {
  const char *str = ConnectResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ConnectResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ConnectResult value) {
  return os << ConnectResultToString(value);
}

static NOINLINE const char* BindInterfacePriorityToStringHelper(BindInterfacePriority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BindInterfacePriority::kImportant:
      return "kImportant";
    case BindInterfacePriority::kBestEffort:
      return "kBestEffort";
    default:
      return nullptr;
  }
}

std::string BindInterfacePriorityToString(BindInterfacePriority value) {
  const char *str = BindInterfacePriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BindInterfacePriority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BindInterfacePriority value) {
  return os << BindInterfacePriorityToString(value);
}

namespace internal {


// static
bool Identity_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Identity_Data* object = static_cast<const Identity_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instance_group, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->instance_group, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instance_id, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->instance_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->globally_unique_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->globally_unique_id, validation_context))
    return false;

  return true;
}

Identity_Data::Identity_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ServiceInfo_Data* object = static_cast<const ServiceInfo_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sandbox_type, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sandbox_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->sandbox_type, validation_context,
                                         &sandbox_type_validate_params)) {
    return false;
  }

  return true;
}

ServiceInfo_Data::ServiceInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProcessMetadata_SetPID_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ProcessMetadata_SetPID_Params_Data* object = static_cast<const ProcessMetadata_SetPID_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pid, validation_context))
    return false;

  return true;
}

ProcessMetadata_SetPID_Params_Data::ProcessMetadata_SetPID_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Connector_BindInterface_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Connector_BindInterface_Params_Data* object = static_cast<const Connector_BindInterface_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interface_name, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams interface_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->interface_name, validation_context,
                                         &interface_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->interface_pipe, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->interface_pipe,
                                                 validation_context)) {
    return false;
  }


  if (!::service_manager::mojom::internal::BindInterfacePriority_Data
        ::Validate(object->priority, validation_context))
    return false;

  return true;
}

Connector_BindInterface_Params_Data::Connector_BindInterface_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Connector_BindInterface_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Connector_BindInterface_ResponseParams_Data* object = static_cast<const Connector_BindInterface_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::service_manager::mojom::internal::ConnectResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;

  return true;
}

Connector_BindInterface_ResponseParams_Data::Connector_BindInterface_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Connector_QueryService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Connector_QueryService_Params_Data* object = static_cast<const Connector_QueryService_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->service_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams service_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->service_name, validation_context,
                                         &service_name_validate_params)) {
    return false;
  }

  return true;
}

Connector_QueryService_Params_Data::Connector_QueryService_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Connector_QueryService_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Connector_QueryService_ResponseParams_Data* object = static_cast<const Connector_QueryService_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

Connector_QueryService_ResponseParams_Data::Connector_QueryService_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Connector_WarmService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Connector_WarmService_Params_Data* object = static_cast<const Connector_WarmService_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filter, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

Connector_WarmService_Params_Data::Connector_WarmService_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Connector_WarmService_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Connector_WarmService_ResponseParams_Data* object = static_cast<const Connector_WarmService_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::service_manager::mojom::internal::ConnectResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;

  return true;
}

Connector_WarmService_ResponseParams_Data::Connector_WarmService_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Connector_RegisterServiceInstance_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Connector_RegisterServiceInstance_Params_Data* object = static_cast<const Connector_RegisterServiceInstance_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identity, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->identity, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->service, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->service,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->metadata_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Connector_RegisterServiceInstance_Params_Data::Connector_RegisterServiceInstance_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Connector_RegisterServiceInstance_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Connector_RegisterServiceInstance_ResponseParams_Data* object = static_cast<const Connector_RegisterServiceInstance_ResponseParams_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);


  if (!::service_manager::mojom::internal::ConnectResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

Connector_RegisterServiceInstance_ResponseParams_Data::Connector_RegisterServiceInstance_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Connector_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Connector_Clone_Params_Data* object = static_cast<const Connector_Clone_Params_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Connector_Clone_Params_Data::Connector_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace service_manager

namespace perfetto {

// static
void TraceFormatTraits<::service_manager::mojom::ConnectResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::service_manager::mojom::ConnectResult value) {
  return std::move(context).WriteString(::service_manager::mojom::ConnectResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::service_manager::mojom::BindInterfacePriority>::WriteIntoTrace(
   perfetto::TracedValue context, ::service_manager::mojom::BindInterfacePriority value) {
  return std::move(context).WriteString(::service_manager::mojom::BindInterfacePriorityToString(value));
}

} // namespace perfetto
