// services/tracing/public/mojom/background_tracing_agent.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/tracing/public/mojom/background_tracing_agent.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/tracing/public/mojom/background_tracing_agent.mojom-params-data.h"
#include "services/tracing/public/mojom/background_tracing_agent.mojom-shared-message-ids.h"

#include "services/tracing/public/mojom/background_tracing_agent.mojom-import-headers.h"


#ifndef SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_JUMBO_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_JUMBO_H_
#endif
namespace tracing {
namespace mojom {
const char BackgroundTracingAgentClient::Name_[] = "tracing.mojom.BackgroundTracingAgentClient";

BackgroundTracingAgentClientProxy::BackgroundTracingAgentClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BackgroundTracingAgentClientProxy::OnInitialized(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "tracing::mojom::BackgroundTracingAgentClient::OnInitialized");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBackgroundTracingAgentClient_OnInitialized_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::BackgroundTracingAgentClient_OnInitialized_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundTracingAgentClient::Name_);
  message.set_method_name("OnInitialized");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BackgroundTracingAgentClientProxy::OnTriggerBackgroundTrace(
    const std::string& in_histogram_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::BackgroundTracingAgentClient::OnTriggerBackgroundTrace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_name"), in_histogram_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBackgroundTracingAgentClient_OnTriggerBackgroundTrace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->histogram_name)::BaseType> histogram_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_histogram_name, histogram_name_fragment);
  params->histogram_name.Set(
      histogram_name_fragment.is_null() ? nullptr : histogram_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->histogram_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null histogram_name in BackgroundTracingAgentClient.OnTriggerBackgroundTrace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundTracingAgentClient::Name_);
  message.set_method_name("OnTriggerBackgroundTrace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BackgroundTracingAgentClientProxy::OnAbortBackgroundTrace(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "tracing::mojom::BackgroundTracingAgentClient::OnAbortBackgroundTrace");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBackgroundTracingAgentClient_OnAbortBackgroundTrace_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::BackgroundTracingAgentClient_OnAbortBackgroundTrace_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundTracingAgentClient::Name_);
  message.set_method_name("OnAbortBackgroundTrace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool BackgroundTracingAgentClientStubDispatch::Accept(
    BackgroundTracingAgentClient* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBackgroundTracingAgentClient_OnInitialized_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::BackgroundTracingAgentClient::OnInitialized",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::BackgroundTracingAgentClient::OnInitialized");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BackgroundTracingAgentClient_OnInitialized_Params_Data* params =
          reinterpret_cast<internal::BackgroundTracingAgentClient_OnInitialized_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      BackgroundTracingAgentClient_OnInitialized_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundTracingAgentClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnInitialized();
      return true;
    }
    case internal::kBackgroundTracingAgentClient_OnTriggerBackgroundTrace_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::BackgroundTracingAgentClient::OnTriggerBackgroundTrace",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::BackgroundTracingAgentClient::OnTriggerBackgroundTrace");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data* params =
          reinterpret_cast<internal::BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_histogram_name{};
      BackgroundTracingAgentClient_OnTriggerBackgroundTrace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHistogramName(&p_histogram_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundTracingAgentClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTriggerBackgroundTrace(
std::move(p_histogram_name));
      return true;
    }
    case internal::kBackgroundTracingAgentClient_OnAbortBackgroundTrace_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::BackgroundTracingAgentClient::OnAbortBackgroundTrace",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::BackgroundTracingAgentClient::OnAbortBackgroundTrace");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BackgroundTracingAgentClient_OnAbortBackgroundTrace_Params_Data* params =
          reinterpret_cast<internal::BackgroundTracingAgentClient_OnAbortBackgroundTrace_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      BackgroundTracingAgentClient_OnAbortBackgroundTrace_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundTracingAgentClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAbortBackgroundTrace();
      return true;
    }
  }
  return false;
}

// static
bool BackgroundTracingAgentClientStubDispatch::AcceptWithResponder(
    BackgroundTracingAgentClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBackgroundTracingAgentClient_OnInitialized_Name: {
      break;
    }
    case internal::kBackgroundTracingAgentClient_OnTriggerBackgroundTrace_Name: {
      break;
    }
    case internal::kBackgroundTracingAgentClient_OnAbortBackgroundTrace_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBackgroundTracingAgentClientValidationInfo[] = {
    {internal::kBackgroundTracingAgentClient_OnInitialized_Name,
     {&internal::BackgroundTracingAgentClient_OnInitialized_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kBackgroundTracingAgentClient_OnTriggerBackgroundTrace_Name,
     {&internal::BackgroundTracingAgentClient_OnTriggerBackgroundTrace_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kBackgroundTracingAgentClient_OnAbortBackgroundTrace_Name,
     {&internal::BackgroundTracingAgentClient_OnAbortBackgroundTrace_Params_Data::Validate,
      nullptr /* no response */}},
};

bool BackgroundTracingAgentClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::BackgroundTracingAgentClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBackgroundTracingAgentClientValidationInfo);
}

const char BackgroundTracingAgent::Name_[] = "tracing.mojom.BackgroundTracingAgent";

BackgroundTracingAgentProxy::BackgroundTracingAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BackgroundTracingAgentProxy::SetUMACallback(
    const std::string& in_histogram_name, int32_t in_histogram_lower_value, int32_t in_histogram_upper_value, bool in_repeat) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::BackgroundTracingAgent::SetUMACallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_name"), in_histogram_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_lower_value"), in_histogram_lower_value,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_upper_value"), in_histogram_upper_value,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("repeat"), in_repeat,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBackgroundTracingAgent_SetUMACallback_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::BackgroundTracingAgent_SetUMACallback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->histogram_name)::BaseType> histogram_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_histogram_name, histogram_name_fragment);
  params->histogram_name.Set(
      histogram_name_fragment.is_null() ? nullptr : histogram_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->histogram_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null histogram_name in BackgroundTracingAgent.SetUMACallback request");
  params->histogram_lower_value = in_histogram_lower_value;
  params->histogram_upper_value = in_histogram_upper_value;
  params->repeat = in_repeat;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundTracingAgent::Name_);
  message.set_method_name("SetUMACallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BackgroundTracingAgentProxy::ClearUMACallback(
    const std::string& in_histogram_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::BackgroundTracingAgent::ClearUMACallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("histogram_name"), in_histogram_name,
                        "<value of type const std::string&>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBackgroundTracingAgent_ClearUMACallback_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::BackgroundTracingAgent_ClearUMACallback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->histogram_name)::BaseType> histogram_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_histogram_name, histogram_name_fragment);
  params->histogram_name.Set(
      histogram_name_fragment.is_null() ? nullptr : histogram_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->histogram_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null histogram_name in BackgroundTracingAgent.ClearUMACallback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundTracingAgent::Name_);
  message.set_method_name("ClearUMACallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool BackgroundTracingAgentStubDispatch::Accept(
    BackgroundTracingAgent* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBackgroundTracingAgent_SetUMACallback_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::BackgroundTracingAgent::SetUMACallback",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::BackgroundTracingAgent::SetUMACallback");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BackgroundTracingAgent_SetUMACallback_Params_Data* params =
          reinterpret_cast<internal::BackgroundTracingAgent_SetUMACallback_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_histogram_name{};
      int32_t p_histogram_lower_value{};
      int32_t p_histogram_upper_value{};
      bool p_repeat{};
      BackgroundTracingAgent_SetUMACallback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHistogramName(&p_histogram_name))
        success = false;
      if (success)
        p_histogram_lower_value = input_data_view.histogram_lower_value();
      if (success)
        p_histogram_upper_value = input_data_view.histogram_upper_value();
      if (success)
        p_repeat = input_data_view.repeat();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundTracingAgent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUMACallback(
std::move(p_histogram_name), 
std::move(p_histogram_lower_value), 
std::move(p_histogram_upper_value), 
std::move(p_repeat));
      return true;
    }
    case internal::kBackgroundTracingAgent_ClearUMACallback_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::BackgroundTracingAgent::ClearUMACallback",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::BackgroundTracingAgent::ClearUMACallback");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BackgroundTracingAgent_ClearUMACallback_Params_Data* params =
          reinterpret_cast<internal::BackgroundTracingAgent_ClearUMACallback_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_histogram_name{};
      BackgroundTracingAgent_ClearUMACallback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHistogramName(&p_histogram_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundTracingAgent::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearUMACallback(
std::move(p_histogram_name));
      return true;
    }
  }
  return false;
}

// static
bool BackgroundTracingAgentStubDispatch::AcceptWithResponder(
    BackgroundTracingAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBackgroundTracingAgent_SetUMACallback_Name: {
      break;
    }
    case internal::kBackgroundTracingAgent_ClearUMACallback_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBackgroundTracingAgentValidationInfo[] = {
    {internal::kBackgroundTracingAgent_SetUMACallback_Name,
     {&internal::BackgroundTracingAgent_SetUMACallback_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kBackgroundTracingAgent_ClearUMACallback_Name,
     {&internal::BackgroundTracingAgent_ClearUMACallback_Params_Data::Validate,
      nullptr /* no response */}},
};

bool BackgroundTracingAgentRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::BackgroundTracingAgent::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBackgroundTracingAgentValidationInfo);
}

const char BackgroundTracingAgentProvider::Name_[] = "tracing.mojom.BackgroundTracingAgentProvider";

BackgroundTracingAgentProviderProxy::BackgroundTracingAgentProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BackgroundTracingAgentProviderProxy::Create(
    uint64_t in_tracing_process_id, ::mojo::PendingRemote<BackgroundTracingAgentClient> in_client, ::mojo::PendingReceiver<BackgroundTracingAgent> in_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "tracing::mojom::BackgroundTracingAgentProvider::Create", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tracing_process_id"), in_tracing_process_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<BackgroundTracingAgentClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent,
                        "<value of type ::mojo::PendingReceiver<BackgroundTracingAgent>>");
   });
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kBackgroundTracingAgentProvider_Create_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::BackgroundTracingAgentProvider_Create_Params_Data> params(
          message);
  params.Allocate();
  params->tracing_process_id = in_tracing_process_id;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::tracing::mojom::BackgroundTracingAgentClientInterfaceBase>>(
      in_client, &params->client, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in BackgroundTracingAgentProvider.Create request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::tracing::mojom::BackgroundTracingAgentInterfaceBase>>(
      in_agent, &params->agent, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->agent),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid agent in BackgroundTracingAgentProvider.Create request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackgroundTracingAgentProvider::Name_);
  message.set_method_name("Create");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool BackgroundTracingAgentProviderStubDispatch::Accept(
    BackgroundTracingAgentProvider* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kBackgroundTracingAgentProvider_Create_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)tracing::mojom::BackgroundTracingAgentProvider::Create",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)tracing::mojom::BackgroundTracingAgentProvider::Create");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BackgroundTracingAgentProvider_Create_Params_Data* params =
          reinterpret_cast<internal::BackgroundTracingAgentProvider_Create_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint64_t p_tracing_process_id{};
      ::mojo::PendingRemote<BackgroundTracingAgentClient> p_client{};
      ::mojo::PendingReceiver<BackgroundTracingAgent> p_agent{};
      BackgroundTracingAgentProvider_Create_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tracing_process_id = input_data_view.tracing_process_id();
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackgroundTracingAgentProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Create(
std::move(p_tracing_process_id), 
std::move(p_client), 
std::move(p_agent));
      return true;
    }
  }
  return false;
}

// static
bool BackgroundTracingAgentProviderStubDispatch::AcceptWithResponder(
    BackgroundTracingAgentProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBackgroundTracingAgentProvider_Create_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kBackgroundTracingAgentProviderValidationInfo[] = {
    {internal::kBackgroundTracingAgentProvider_Create_Name,
     {&internal::BackgroundTracingAgentProvider_Create_Params_Data::Validate,
      nullptr /* no response */}},
};

bool BackgroundTracingAgentProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::tracing::mojom::BackgroundTracingAgentProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kBackgroundTracingAgentProviderValidationInfo);
}

}  // namespace mojom
}  // namespace tracing

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif