// services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_event.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_EXTERNAL_BEGIN_FRAME_CONTROLLER_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_EXTERNAL_BEGIN_FRAME_CONTROLLER_MOJOM_JUMBO_H_
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"
#endif
namespace viz {
namespace mojom {
const char ExternalBeginFrameController::Name_[] = "viz.mojom.ExternalBeginFrameController";

class ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback(
      ExternalBeginFrameController::IssueExternalBeginFrameCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ExternalBeginFrameController::IssueExternalBeginFrameCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback);
};

ExternalBeginFrameControllerProxy::ExternalBeginFrameControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ExternalBeginFrameControllerProxy::IssueExternalBeginFrame(
    const ::viz::BeginFrameArgs& in_args, bool in_force, IssueExternalBeginFrameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::ExternalBeginFrameController::IssueExternalBeginFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type const ::viz::BeginFrameArgs&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("force"), in_force,
                        "<value of type bool>");
   });
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kExternalBeginFrameController_IssueExternalBeginFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::ExternalBeginFrameController_IssueExternalBeginFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::BeginFrameArgsDataView>(
      in_args, args_fragment);
  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->args.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null args in ExternalBeginFrameController.IssueExternalBeginFrame request");
  params->force = in_force;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExternalBeginFrameController::Name_);
  message.set_method_name("IssueExternalBeginFrame");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder {
 public:
  static ExternalBeginFrameController::IssueExternalBeginFrameCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder> proxy(
        new ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ExternalBeginFrameController::IssueExternalBeginFrameCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::viz::BeginFrameAck& in_ack);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder);
};

bool ExternalBeginFrameController_IssueExternalBeginFrame_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::ExternalBeginFrameController::IssueExternalBeginFrameCallback",
               "message", message->name());
#endif

  DCHECK(message->is_serialized());
  internal::ExternalBeginFrameController_IssueExternalBeginFrame_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ExternalBeginFrameController_IssueExternalBeginFrame_ResponseParams_Data*>(
              message->mutable_payload());
  
  bool success = true;
  ::viz::BeginFrameAck p_ack{};
  ExternalBeginFrameController_IssueExternalBeginFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAck(&p_ack))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ExternalBeginFrameController::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_ack));
  return true;
}

void ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder::Run(
    const ::viz::BeginFrameAck& in_ack) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::ExternalBeginFrameController::IssueExternalBeginFrameCallback", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ack"), in_ack,
                        "<value of type const ::viz::BeginFrameAck&>");
   });
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt);
  
  mojo::Message message(
      internal::kExternalBeginFrameController_IssueExternalBeginFrame_Name, kFlags, 0, 0, nullptr);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::ExternalBeginFrameController_IssueExternalBeginFrame_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ack)::BaseType> ack_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::BeginFrameAckDataView>(
      in_ack, ack_fragment);
  params->ack.Set(
      ack_fragment.is_null() ? nullptr : ack_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ack.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ack in ");

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::ExternalBeginFrameController::IssueExternalBeginFrameCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExternalBeginFrameController::Name_);
  message.set_method_name("IssueExternalBeginFrame");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ExternalBeginFrameControllerStubDispatch::Accept(
    ExternalBeginFrameController* impl,
    mojo::Message* message) {
  switch (message->header()->name) {
    case internal::kExternalBeginFrameController_IssueExternalBeginFrame_Name: {
      break;
    }
  }
  return false;
}

// static
bool ExternalBeginFrameControllerStubDispatch::AcceptWithResponder(
    ExternalBeginFrameController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kExternalBeginFrameController_IssueExternalBeginFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::ExternalBeginFrameController::IssueExternalBeginFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::ExternalBeginFrameController::IssueExternalBeginFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ExternalBeginFrameController_IssueExternalBeginFrame_Params_Data* params =
          reinterpret_cast<
              internal::ExternalBeginFrameController_IssueExternalBeginFrame_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::viz::BeginFrameArgs p_args{};
      bool p_force{};
      ExternalBeginFrameController_IssueExternalBeginFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (success)
        p_force = input_data_view.force();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExternalBeginFrameController::Name_, 0, false);
        return false;
      }
      ExternalBeginFrameController::IssueExternalBeginFrameCallback callback =
          ExternalBeginFrameController_IssueExternalBeginFrame_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IssueExternalBeginFrame(
std::move(p_args), 
std::move(p_force), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kExternalBeginFrameControllerValidationInfo[] = {
    {internal::kExternalBeginFrameController_IssueExternalBeginFrame_Name,
     {&internal::ExternalBeginFrameController_IssueExternalBeginFrame_Params_Data::Validate,
      &internal::ExternalBeginFrameController_IssueExternalBeginFrame_ResponseParams_Data::Validate}},
};

bool ExternalBeginFrameControllerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::ExternalBeginFrameController::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kExternalBeginFrameControllerValidationInfo);
}

bool ExternalBeginFrameControllerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::ExternalBeginFrameController::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kExternalBeginFrameControllerValidationInfo);

}
}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif